/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.AttributesSupport;
import org.javasimon.Manager;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.SimonState;

abstract class AbstractSimon
implements Simon {
    protected Manager manager;
    protected volatile boolean enabled;
    protected long firstUsage;
    protected long lastUsage;
    private final String name;
    private SimonState state = SimonState.INHERIT;
    private Simon parent;
    private final List<Simon> children = new CopyOnWriteArrayList<Simon>();
    private String note;
    private long resetTimestamp;
    private AttributesSupport attributesSupport = new AttributesSupport();
    private Map<Object, Simon> incrementalSimons;

    AbstractSimon(String name, Manager manager) {
        this.name = name;
        this.manager = manager;
        if (name == null || name.equals("")) {
            this.state = SimonState.ENABLED;
            this.enabled = true;
        }
    }

    @Override
    public final Simon getParent() {
        return this.parent;
    }

    @Override
    public final List<Simon> getChildren() {
        return this.children;
    }

    final void setParent(Simon parent) {
        this.parent = parent;
    }

    final synchronized void addChild(AbstractSimon simon) {
        this.children.add(simon);
        simon.setParent(this);
        simon.enabled = this.enabled;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Manager getManager() {
        return this.manager;
    }

    @Override
    public final synchronized void setState(SimonState state, boolean overrule) {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isAnonymousOrRootSimon() || !state.equals((Object)SimonState.INHERIT)) {
            this.state = state;
            this.updateAndPropagateEffectiveState(this.shouldBeEffectivlyEnabled(), overrule);
        }
    }

    private boolean isAnonymousOrRootSimon() {
        return this.name == null || this.name.equals("");
    }

    private synchronized boolean shouldBeEffectivlyEnabled() {
        if (this.state.equals((Object)SimonState.INHERIT)) {
            return this.parent.isEnabled();
        }
        return this.state.equals((Object)SimonState.ENABLED);
    }

    private synchronized void updateAndPropagateEffectiveState(boolean enabled, boolean overrule) {
        this.enabled = enabled;
        for (Simon child : this.children) {
            if (overrule) {
                ((AbstractSimon)child).state = SimonState.INHERIT;
            }
            if (!child.getState().equals((Object)SimonState.INHERIT)) continue;
            ((AbstractSimon)child).updateAndPropagateEffectiveState(enabled, overrule);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void reset() {
        AbstractSimon abstractSimon = this;
        synchronized (abstractSimon) {
            this.resetTimestamp = this.manager.milliTime();
            this.concreteReset();
        }
        if (this.manager != null) {
            this.manager.callback().onSimonReset(this);
        }
    }

    void updateUsages(long now) {
        this.lastUsage = now;
        if (this.firstUsage == 0L) {
            this.firstUsage = this.lastUsage;
        }
    }

    abstract void concreteReset();

    @Override
    @Deprecated
    public synchronized long getLastReset() {
        return this.resetTimestamp;
    }

    @Override
    public final synchronized SimonState getState() {
        return this.state;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public long getFirstUsage() {
        return this.firstUsage;
    }

    @Override
    public long getLastUsage() {
        return this.lastUsage;
    }

    void replaceChild(Simon simon, AbstractSimon newSimon) {
        this.children.remove(simon);
        if (newSimon != null) {
            this.children.add(newSimon);
            newSimon.setParent(this);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributesSupport.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributesSupport.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, Class<T> clazz) {
        return this.attributesSupport.getAttribute(name, clazz);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributesSupport.removeAttribute(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributesSupport.getAttributeNames();
    }

    @Override
    public Map<String, Object> getCopyAsSortedMap() {
        return this.attributesSupport.getCopyAsSortedMap();
    }

    void sampleCommon(Sample sample) {
        sample.setName(this.name);
        sample.setNote(this.note);
        sample.setFirstUsage(this.firstUsage);
        sample.setLastUsage(this.lastUsage);
        sample.setLastReset(this.resetTimestamp);
    }

    Collection<Simon> incrementalSimons() {
        return this.incrementalSimons != null ? this.incrementalSimons.values() : null;
    }

    Simon getAndResetSampleKey(Object key, Simon newSimon) {
        if (this.incrementalSimons == null) {
            this.incrementalSimons = new HashMap<Object, Simon>();
        }
        Simon simon = this.incrementalSimons.get(key);
        this.incrementalSimons.put(key, newSimon);
        return simon;
    }

    Sample sampleIncrementHelper(Object key, Simon newSimon) {
        Simon simon = this.getAndResetSampleKey(key, newSimon);
        if (simon != null) {
            return simon.sample();
        }
        return this.sample();
    }

    @Override
    public synchronized boolean stopIncrementalSampling(Object key) {
        return this.incrementalSimons != null && this.incrementalSimons.remove(key) != null;
    }

    synchronized void purgeIncrementalSimonsOlderThan(long thresholdMs) {
        if (this.incrementalSimons == null) {
            return;
        }
        Iterator<Map.Entry<Object, Simon>> iterator = this.incrementalSimons.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Simon> entry = iterator.next();
            if (entry.getValue().getLastUsage() >= thresholdMs) continue;
            iterator.remove();
        }
        if (this.incrementalSimons.isEmpty()) {
            this.incrementalSimons = null;
        }
    }

    public synchronized String toString() {
        return " [" + this.name + " " + (Object)((Object)this.state) + (this.getNote() != null && this.getNote().length() != 0 ? " \"" + this.getNote() + "\"]" : "]");
    }
}

