/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.groups.impl;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.contenttypes.common.CommonConstants;
import com.openexchange.usm.api.contenttypes.common.ContentType;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.contenttypes.groups.GroupsConstants;
import com.openexchange.usm.api.exceptions.InternalUSMException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.exceptions.UnsupportedContentOperationException;
import com.openexchange.usm.api.ox.json.JSONResult;
import com.openexchange.usm.api.ox.json.JSONResultType;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.AbstractTransferHandler;

public class GroupsContentTypeTransferHandler extends AbstractTransferHandler {

	private static final String WILDCARD_ALL = "*";
	private static final String PATTERN = "pattern";

	public GroupsContentTypeTransferHandler(ContentType contentType, OXJSONAccess ajaxAccess) {
		super(contentType, ajaxAccess);
	}

	@Override
	protected String getOXAjaxAccessPath() {
		return GroupsConstants.GROUPS_PATH;
	}

	@Override
	public void writeNewDataObject(DataObject object) throws USMException {
		if (LOG.isErrorEnabled())
			LOG.error(object.getSession() + " Creating a group is not supported");
		throw new UnsupportedContentOperationException(USMContentTypesGroupsErrorCodes.CREATE_ERROR,
				"Creating a group is not supported");
	}

	@Override
	public void writeUpdatedDataObject(DataObject object, long timestamp) throws USMException {
		if (LOG.isErrorEnabled())
			LOG.error(object.getSession() + " Updating a group is not supported");
		throw new UnsupportedContentOperationException(USMContentTypesGroupsErrorCodes.UPDATE_ERROR,
				"Updating a group is not supported");
	}

	@Override
	public void writeDeletedDataObject(DataObject object) throws USMException {
		if (LOG.isErrorEnabled())
			LOG.error(object.getSession() + " Deleting a group is not supported");
		throw new UnsupportedContentOperationException(USMContentTypesGroupsErrorCodes.DELETE_ERROR,
				"Deleting a group is not supported");
	}

	@Override
	public DataObject[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp)
			throws USMException {
		if (LOG.isErrorEnabled())
			LOG.error(folder.getSession() + " Updating a folder content is not supported for groups");
		throw new UnsupportedContentOperationException(USMContentTypesGroupsErrorCodes.UPDATE_FOLDER_ERROR,
				"Updating a folder content is not supported for groups");
	}

    @Override
    public OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException {
        return new OXFolderContent(true, readFolderContent(folder, folder.getSession().getFieldFilter(folder.getElementsContentType())));
    }

	@Override
	public DataObject[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException {
		Session session = folder.getSession();
		if (LOG.isDebugEnabled())
			LOG.debug(session + " Read all " + _contentType.getID());
		Map<String, String> parameters = new HashMap<String, String>();
		JSONObject requestBody = new JSONObject();
		try {
			requestBody.put(PATTERN, WILDCARD_ALL);
		} catch (JSONException e) {
			throw new InternalUSMException(USMContentTypesGroupsErrorCodes.READ_ALL_JSON_ERROR_1,
					"Can not create request body for searching groups", e);
		}
		JSONResult result = _ajaxAccess.doPut(getOXAjaxAccessPath(), CommonConstants.ACTION_SEARCH, session, parameters,
				requestBody);
		checkResult(result, JSONResultType.JSONObject);
		long timestamp = result.getJSONObject().optLong(CommonConstants.TIMESTAMP, System.currentTimeMillis());
		JSONArray groupsArray = extractArrayResult(result);
		DataObject[] resultArray = new DataObject[groupsArray.length()];
		try {
			for (int i = 0; i < resultArray.length; i++) {
				JSONObject jsonObj = groupsArray.getJSONObject(i);
				resultArray[i] = _contentType.newDataObject(session);
				resultArray[i].setTimestamp(timestamp);
				resultArray[i].setParentFolderID(folder.getID());
				ContentTypeField[] fields = _contentType.getFields();
				for (int j = 0; j < fields.length; j++) {
					ContentTypeField field = fields[j];
					String fieldName = field.getFieldName();
					resultArray[i].setFieldContent(fieldName, field.getFieldType().extractFromJSONObject(session,
							jsonObj, fieldName));
				}
			}
		} catch (JSONException e) {
			throw new InternalUSMException(USMContentTypesGroupsErrorCodes.READ_RESULT_ERROR,
					"Error on reading result", e);
		}
		return resultArray;
	}

}
