/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2012
 * Mail: info@open-xchange.com
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * 
 */

temporary.lists.mail.columns.splice(0, 0, {
    text: "&#x00a0;",
    sortable: false,
    name : ["id", "folder_id"],
    width: "1.6em",
    style: { padding:0, textAlign:"center" },
    set: function(div, data, all, grid) {
        var box;
        if (!div.firstChild) {
            box = newcheckbox();
            box.lgData = data;
            addDOMEvent(div, "mousedown", cancelBubbling);
            addDOMEvent(div, "click", cancelBubbling);
            addDOMEvent(box, "click", function() {
                grid.selection.toggleByKey(box.lgData);
            });
            grid.selection.events.register("Selected", function() {
                box.checked = grid.selection.getByKey(box.lgData);
            });
            div.appendChild(box);
        } else {
            box = div.firstChild;
            box.lgData = data;
            box.display = "";
        }
        box.checked = grid.selection.getByKey(data);
    },
    clear: function(div) {
        if (div.firstChild) div.firstChild.display = "none";
    }
});