/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.mex;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.EndpointInfo;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MEXUtils {
    private MEXUtils() {
    }

    public static List<Element> getWSDLs(Server server) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        String base = (String)message.get("org.apache.cxf.request.url");
        String ctxUri = (String)message.get(Message.PATH_INFO);
        WSDLGetUtils utils = new WSDLGetUtils();
        EndpointInfo info = server.getEndpoint().getEndpointInfo();
        LinkedList<Element> ret = new LinkedList<Element>();
        for (String id : utils.getWSDLIds(message, base, ctxUri, info)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("wsdl", id);
            ret.add(utils.getDocument(message, base, params, ctxUri, info).getDocumentElement());
        }
        return ret;
    }

    public static Map<String, String> getSchemaLocations(Server server) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        String base = (String)message.get("org.apache.cxf.request.url");
        String ctxUri = (String)message.get(Message.PATH_INFO);
        WSDLGetUtils utils = new WSDLGetUtils();
        EndpointInfo info = server.getEndpoint().getEndpointInfo();
        return utils.getSchemaLocations(message, base, ctxUri, info);
    }

    public static List<Element> getSchemas(Server server, String id) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        String base = (String)message.get("org.apache.cxf.request.url");
        String ctxUri = (String)message.get(Message.PATH_INFO);
        WSDLGetUtils utils = new WSDLGetUtils();
        EndpointInfo info = server.getEndpoint().getEndpointInfo();
        Map<String, String> locs = utils.getSchemaLocations(message, base, ctxUri, info);
        LinkedList<Element> ret = new LinkedList<Element>();
        for (Map.Entry<String, String> xsd : locs.entrySet()) {
            if (!StringUtils.isEmpty(id) && !id.equals(xsd.getKey())) continue;
            String query = xsd.getValue().substring(xsd.getValue().indexOf(63) + 1);
            Map<String, String> params = UrlUtils.parseQueryString(query);
            ret.add(utils.getDocument(message, base, params, ctxUri, info).getDocumentElement());
        }
        return ret;
    }

    public static Map<String, String> getPolicyLocations(Server server) {
        return null;
    }

    public static List<Element> getPolicies(Server server, String id) {
        return null;
    }
}

