/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd.graph;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.dcd.graph.ClassNode;
import net.sourceforge.pmd.dcd.graph.NodeVisitor;
import net.sourceforge.pmd.dcd.graph.NodeVisitorAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberNode<S extends MemberNode<S, T>, T extends Member>
implements NodeVisitorAcceptor,
Comparable<S> {
    protected final ClassNode classNode;
    protected final String name;
    protected final String desc;
    private List<MemberNode> uses;
    private List<MemberNode> users;
    private Object decoration;

    public MemberNode(ClassNode classNode, String name, String desc) {
        this.classNode = classNode;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public Object accept(NodeVisitor visitor, Object data) {
        visitor.visitUses(this, data);
        visitor.visitUsers(this, data);
        return data;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public abstract T getMember();

    public void addUse(MemberNode use) {
        if (this.uses == null) {
            this.uses = new ArrayList<MemberNode>(1);
        }
        if (!this.uses.contains(use)) {
            this.uses.add(use);
        }
    }

    public List<MemberNode> getUses() {
        return this.uses != null ? this.uses : Collections.emptyList();
    }

    public void addUser(MemberNode user) {
        if (this.users == null) {
            this.users = new ArrayList<MemberNode>(1);
        }
        if (!this.users.contains(user)) {
            this.users.add(user);
        }
    }

    public List<MemberNode> getUsers() {
        return this.users != null ? this.users : Collections.emptyList();
    }

    public String toString() {
        return this.name + " " + this.desc;
    }

    public String toStringLong() {
        return this.getMember().toString();
    }

    public abstract boolean equals(Object var1);

    public boolean equals(S that) {
        return this.equals(((MemberNode)that).name, ((MemberNode)that).desc);
    }

    public boolean equals(String name, String desc) {
        return this.name.equals(name) && this.desc.equals(desc);
    }

    public int hashCode() {
        return this.name.hashCode() + this.desc.hashCode();
    }
}

