/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.solr.internal.csv.CSVParser;
import org.apache.solr.internal.csv.CSVPrinter;
import org.apache.solr.internal.csv.CSVStrategy;

public class CSVUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[][] EMPTY_DOUBLE_STRING_ARRAY = new String[0][0];

    public static String printLine(String[] values, CSVStrategy strategy) {
        StringWriter stringWriter = new StringWriter();
        CSVPrinter csvPrinter = new CSVPrinter(stringWriter, strategy);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                values[i] = "null";
                continue;
            }
            if (!values[i].equals("null")) continue;
            values[i] = "\"null\"";
        }
        try {
            csvPrinter.println(values);
        }
        catch (IOException e) {
            // empty catch block
        }
        return stringWriter.toString().trim();
    }

    public static String[][] parse(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        String[][] result = new CSVParser(new StringReader(s)).getAllValues();
        if (result == null) {
            result = EMPTY_DOUBLE_STRING_ARRAY;
        }
        return result;
    }

    public static String[] parseLine(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        if (s.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return new CSVParser(new StringReader(s)).getLine();
    }
}

