/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ajax.parser;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.ajax.fields.GroupFields;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;

/**
 * This class parses a JSON into a group object.
 * @author <a href="mailto:marcus@open-xchange.org">Marcus Klein</a>
 */
public class GroupParser extends DataParser {

    /**
     * Default constructor.
     */
    public GroupParser() {
        super(true, null);
    }

    public void parse(final Group group, final JSONObject json)
        throws OXException, JSONException {
        if (json.has(GroupFields.IDENTIFIER)) {
            group.setIdentifier(parseInt(json, GroupFields.IDENTIFIER));
        }
        if (json.has(GroupFields.DISPLAY_NAME)) {
            group.setDisplayName(parseString(json, GroupFields.DISPLAY_NAME));
        }
        if (json.has(GroupFields.NAME)) {
            group.setSimpleName(parseString(json, GroupFields.NAME));
        }
        if (json.has(GroupFields.MEMBERS)) {
            group.setMember(parseMember(json));
        }
    }

    private int[] parseMember(final JSONObject json) throws JSONException {
        final JSONArray jmembers = json.getJSONArray(GroupFields.MEMBERS);
        final int[] retval = new int[jmembers.length()];
        for (int i = 0; i < jmembers.length(); i++) {
            retval[i] = jmembers.getInt(i);
        }
        return retval;
    }
}
