/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.SecureRequest;
import com.hazelcast.client.txn.TransactionRequest;
import com.hazelcast.multimap.MultiMapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import java.io.IOException;
import java.security.Permission;

public abstract class TxnMultiMapRequest
extends TransactionRequest
implements SecureRequest {
    String name;

    protected TxnMultiMapRequest() {
    }

    protected TxnMultiMapRequest(String name, int clientThreadId) {
        super(clientThreadId);
        this.name = name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    public Data toData(Object obj) {
        return this.getClientEngine().toData(obj);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "read");
    }
}

