/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.impl.partition.PartitionListener;
import com.hazelcast.impl.partition.PartitionReplicaChangeEvent;
import com.hazelcast.nio.Address;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class PartitionInfo {
    public static final int MAX_REPLICA_COUNT = 7;
    private final int partitionId;
    private final AtomicReferenceArray<Address> addresses = new AtomicReferenceArray(7);
    private final PartitionListener partitionListener;

    public PartitionInfo(int partitionId, PartitionListener partitionListener) {
        this.partitionId = partitionId;
        this.partitionListener = partitionListener;
    }

    public PartitionInfo(int partitionId) {
        this(partitionId, null);
    }

    public PartitionInfo(PartitionInfo partition) {
        this(partition.getPartitionId(), null);
        this.setPartitionInfo(partition);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public Address getOwner() {
        return this.addresses.get(0);
    }

    public void setReplicaAddress(int index, Address address) {
        boolean changed = false;
        Address currentAddress = this.addresses.get(index);
        if (this.partitionListener != null) {
            changed = currentAddress == null ? address != null : !currentAddress.equals(address);
        }
        this.addresses.set(index, address);
        if (changed) {
            this.partitionListener.replicaChanged(new PartitionReplicaChangeEvent(this.partitionId, index, currentAddress, address));
        }
    }

    public Address getReplicaAddress(int index) {
        return this.addresses != null && this.addresses.length() > index ? this.addresses.get(index) : null;
    }

    public void setPartitionInfo(PartitionInfo partitionInfo) {
        int i = 0;
        while (i < 7) {
            this.setReplicaAddress(i, partitionInfo.getReplicaAddress(i));
            ++i;
        }
    }

    public boolean isBackup(Address address, int backupCount) {
        int backup = Math.min(backupCount + 1, 7);
        int i = 1;
        while (i < backup) {
            if (address.equals(this.getReplicaAddress(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isOwnerOrBackup(Address address, int backupCount) {
        int replicaCount = Math.min(backupCount + 1, 7);
        int i = 0;
        while (i < replicaCount) {
            if (address.equals(this.getReplicaAddress(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition [").append(this.partitionId).append("]{\n");
        int i = 0;
        while (i < 7) {
            Address address = this.addresses.get(i);
            if (address != null) {
                sb.append('\t');
                sb.append(i).append(":").append(address);
                sb.append("\n");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean onDeadAddress(Address deadAddress) {
        int i = 0;
        while (i < 7) {
            if (deadAddress.equals(this.addresses.get(i))) {
                int a = i;
                while (a + 1 < 7) {
                    this.setReplicaAddress(a, this.addresses.get(a + 1));
                    ++a;
                }
                this.setReplicaAddress(6, null);
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getReplicaIndexOf(Address address) {
        int i = 0;
        while (i < 7) {
            if (address.equals(this.addresses.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        int i = 0;
        while (i < 7) {
            Address a1 = this.addresses.get(i);
            Address a2 = that.addresses.get(i);
            if (a1 == null ? a2 != null : !a1.equals(a2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = this.partitionId;
        int i = 0;
        while (i < 7) {
            Address address = this.addresses.get(i);
            result = 31 * result + (address != null ? address.hashCode() : 0);
            ++i;
        }
        return result;
    }
}

