/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MProxyImpl;
import com.hazelcast.impl.SetProxy;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.Iterator;

public class SetProxyImpl
extends AbstractCollection
implements SetProxy,
DataSerializable,
HazelcastInstanceAwareInstance {
    String name = null;
    private transient SetProxy base = null;
    private transient FactoryImpl factory = null;

    public SetProxyImpl() {
    }

    SetProxyImpl(String name, FactoryImpl factory) {
        this.name = name;
        this.factory = factory;
        this.base = new SetProxyReal();
    }

    public SetProxy getBase() {
        return this.base;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (SetProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    @Override
    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    @Override
    public String toString() {
        return "Set [" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetProxyImpl that = (SetProxyImpl)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public int size() {
        this.ensure();
        return this.base.size();
    }

    @Override
    public boolean contains(Object o) {
        this.ensure();
        return this.base.contains(o);
    }

    @Override
    public Iterator iterator() {
        this.ensure();
        return this.base.iterator();
    }

    @Override
    public boolean add(Object o) {
        this.ensure();
        return this.base.add(o);
    }

    @Override
    public boolean remove(Object o) {
        this.ensure();
        return this.base.remove(o);
    }

    @Override
    public void clear() {
        this.ensure();
        this.base.clear();
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    @Override
    public void destroy() {
        this.factory.destroyInstanceClusterWide(this.name, null);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeData(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readData(in);
    }

    @Override
    public String getName() {
        return this.name.substring("m:s:".length());
    }

    @Override
    public void addItemListener(ItemListener itemListener, boolean includeValue) {
        this.ensure();
        this.base.addItemListener(itemListener, includeValue);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.ensure();
        this.base.removeItemListener(itemListener);
    }

    @Override
    public MProxy getMProxy() {
        this.ensure();
        return this.base.getMProxy();
    }

    @Override
    public boolean removeKey(Object key) {
        this.ensure();
        return this.base.removeKey(key);
    }

    class SetProxyReal
    extends AbstractCollection
    implements SetProxy {
        final MProxy mapProxy;

        public SetProxyReal() {
            this.mapProxy = new MProxyImpl(SetProxyImpl.this.name, SetProxyImpl.this.factory);
        }

        @Override
        public Object getId() {
            return SetProxyImpl.this.name;
        }

        @Override
        public boolean equals(Object o) {
            return SetProxyImpl.this.equals(o);
        }

        @Override
        public int hashCode() {
            return SetProxyImpl.this.hashCode();
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return BaseManager.getInstanceType(SetProxyImpl.this.name);
        }

        @Override
        public void addItemListener(ItemListener listener, boolean includeValue) {
            this.mapProxy.addGenericListener(listener, null, includeValue, this.getInstanceType());
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            this.mapProxy.removeGenericListener(listener, null);
        }

        @Override
        public String getName() {
            return SetProxyImpl.this.getName();
        }

        @Override
        public boolean add(Object obj) {
            return this.mapProxy.add(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.mapProxy.removeKey(obj);
        }

        @Override
        public boolean contains(Object obj) {
            return this.mapProxy.containsKey(obj);
        }

        @Override
        public Iterator iterator() {
            return this.mapProxy.keySet().iterator();
        }

        @Override
        public int size() {
            return this.mapProxy.size();
        }

        @Override
        public void clear() {
            this.mapProxy.clear();
        }

        @Override
        public void destroy() {
            SetProxyImpl.this.factory.destroyInstanceClusterWide(SetProxyImpl.this.name, null);
        }

        @Override
        public MProxy getMProxy() {
            return this.mapProxy;
        }

        @Override
        public boolean removeKey(Object key) {
            return this.mapProxy.removeKey(key);
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

