/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class RF {
    private int period;
    private int init;
    private int m;
    private Graph aut;

    private static void buildSuffixAutomaton(char[] x, Graph aut) {
        int m = x.length - 1;
        int init = Automata.getInitial(aut);
        int art = Automata.newVertex(aut);
        Automata.setSuffixLink(aut, init, art);
        int last = init;
        for (int i = 0; i < m; ++i) {
            char c = x[i];
            int p = last;
            int q = Automata.newVertex(aut);
            Automata.setLength(aut, q, Automata.getLength(aut, p) + 1);
            Automata.setPosition(aut, q, Automata.getPosition(aut, p) + 1);
            while (p != init && Automata.getTarget(aut, p, c) == -1) {
                Automata.setTarget(aut, p, c, q);
                Automata.setShift(aut, p, c, Automata.getPosition(aut, q) - Automata.getPosition(aut, p) - 1);
                p = Automata.getSuffixLink(aut, p);
            }
            if (Automata.getTarget(aut, p, c) == -1) {
                Automata.setTarget(aut, init, c, q);
                Automata.setShift(aut, init, c, Automata.getPosition(aut, q) - Automata.getPosition(aut, init) - 1);
                Automata.setSuffixLink(aut, q, init);
            } else if (Automata.getLength(aut, p) + 1 == Automata.getLength(aut, Automata.getTarget(aut, p, c))) {
                Automata.setSuffixLink(aut, q, Automata.getTarget(aut, p, c));
            } else {
                int r = Automata.newVertex(aut);
                Automata.copyVertex(aut, r, Automata.getTarget(aut, p, c));
                Automata.setLength(aut, r, Automata.getLength(aut, p) + 1);
                Automata.setSuffixLink(aut, Automata.getTarget(aut, p, c), r);
                Automata.setSuffixLink(aut, q, r);
                while (p != art && Automata.getLength(aut, Automata.getTarget(aut, p, c)) >= Automata.getLength(aut, r)) {
                    Automata.setShift(aut, p, c, Automata.getPosition(aut, Automata.getTarget(aut, p, c)) - Automata.getPosition(aut, p) - 1);
                    Automata.setTarget(aut, p, c, r);
                    p = Automata.getSuffixLink(aut, p);
                }
            }
            last = q;
        }
        Automata.setTerminal(aut, last);
        while (last != init) {
            last = Automata.getSuffixLink(aut, last);
            Automata.setTerminal(aut, last);
        }
    }

    private static char[] reverse(char[] x) {
        int m = x.length;
        char[] xR = new char[m + 1];
        for (int i = 0; i < m; ++i) {
            xR[i] = x[m - 1 - i];
        }
        xR[m] = '\u0000';
        return xR;
    }

    public static List<Integer> findAll(String pattern, String source) {
        int shift;
        char[] x = pattern.toCharArray();
        char[] y = source.toCharArray();
        int m = x.length;
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Graph aut = Automata.newSuffixAutomaton(2 * (m + 2), 2 * (m + 2) * 65536);
        char[] xR = RF.reverse(x);
        RF.buildSuffixAutomaton(xR, aut);
        int init = Automata.getInitial(aut);
        int period = m;
        for (int j = 0; j <= n - m; j += shift) {
            int i = m - 1;
            int state = init;
            shift = m;
            while (i + j >= 0 && Automata.getTarget(aut, state, y[i + j]) != -1) {
                if (Automata.isTerminal(aut, state = Automata.getTarget(aut, state, y[i + j]))) {
                    period = shift;
                    shift = i;
                }
                --i;
            }
            if (i >= 0) continue;
            result.add(j);
            shift = period;
        }
        return result;
    }

    public static RF compile(String pattern) {
        char[] x = pattern.toCharArray();
        int m = x.length;
        Graph aut = Automata.newSuffixAutomaton(2 * (m + 2), 2 * (m + 2) * 65536);
        char[] xR = RF.reverse(x);
        RF.buildSuffixAutomaton(xR, aut);
        int init = Automata.getInitial(aut);
        int period = m;
        RF rf = new RF();
        rf.period = period;
        rf.aut = aut;
        rf.init = init;
        rf.m = m;
        return rf;
    }

    public List<Integer> findAll(String source) {
        int shift;
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int j = 0; j <= n - this.m; j += shift) {
            int i = this.m - 1;
            int state = this.init;
            shift = this.m;
            while (i + j >= 0 && Automata.getTarget(this.aut, state, y[i + j]) != -1) {
                if (Automata.isTerminal(this.aut, state = Automata.getTarget(this.aut, state, y[i + j]))) {
                    this.period = shift;
                    shift = i;
                }
                --i;
            }
            if (i >= 0) continue;
            result.add(j);
            shift = this.period;
        }
        return result;
    }

    private static class Automata {
        private static final int UNDEFINED = -1;

        private Automata() {
        }

        public static Graph newGraph(int v, int e) {
            Graph g = new Graph();
            g.vertexNumber = v;
            g.edgeNumber = e;
            g.initial = 0;
            g.vertexCounter = 1;
            return g;
        }

        public static Graph newAutomaton(int v, int e) {
            Graph aut = Automata.newGraph(v, e);
            Graph.access$502(aut, new int[e]);
            Graph.access$602(aut, new int[v]);
            return aut;
        }

        public static Graph newSuffixAutomaton(int v, int e) {
            Graph aut = Automata.newAutomaton(v, e);
            Graph.access$502(aut, new int[e]);
            for (int i = 0; i < e; ++i) {
                ((Graph)aut).target[i] = -1;
            }
            Graph.access$702(aut, new int[v]);
            Graph.access$802(aut, new int[v]);
            Graph.access$902(aut, new int[v]);
            Graph.access$1002(aut, new int[e]);
            return aut;
        }

        public static Graph newTrie(int v, int e) {
            Graph aut = Automata.newAutomaton(v, e);
            Graph.access$502(aut, new int[e]);
            for (int i = 0; i < e; ++i) {
                ((Graph)aut).target[i] = -1;
            }
            Graph.access$702(aut, new int[v]);
            Graph.access$802(aut, new int[v]);
            Graph.access$902(aut, new int[v]);
            Graph.access$1002(aut, new int[e]);
            return aut;
        }

        public static int newVertex(Graph g) {
            int res = -1;
            if (g != null && g.vertexCounter <= g.vertexNumber) {
                res = g.vertexCounter++;
            }
            return res;
        }

        public static int getInitial(Graph g) {
            return g.initial;
        }

        public static boolean isTerminal(Graph g, int v) {
            boolean res = false;
            if (g != null && g.terminal != null && v < g.vertexNumber) {
                res = g.terminal[v] == 1;
            }
            return res;
        }

        public static void setTerminal(Graph g, int v) {
            if (g != null && g.terminal != null && v < g.vertexNumber) {
                ((Graph)g).terminal[v] = 1;
            }
        }

        public static int getTarget(Graph g, int v, int c) {
            int res = -1;
            if (g != null && g.target != null && v < g.vertexNumber && v * c < g.edgeNumber) {
                res = g.target[v * (g.edgeNumber / g.vertexNumber) + c];
            }
            return res;
        }

        public static void setTarget(Graph g, int v, int c, int t) {
            if (g != null && g.target != null && v < g.vertexNumber && v * c <= g.edgeNumber && t < g.vertexNumber) {
                ((Graph)g).target[v * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + c] = t;
            }
        }

        public static int getSuffixLink(Graph g, int v) {
            int res = -1;
            if (g != null && g.suffixLink != null && v < g.vertexNumber) {
                res = g.suffixLink[v];
            }
            return res;
        }

        public static void setSuffixLink(Graph g, int v, int s) {
            if (g != null && g.suffixLink != null && v < g.vertexNumber && s < g.vertexNumber) {
                ((Graph)g).suffixLink[v] = s;
            }
        }

        public static int getLength(Graph g, int v) {
            int res = -1;
            if (g != null && g.length != null && v < g.vertexNumber) {
                res = g.length[v];
            }
            return res;
        }

        public static void setLength(Graph g, int v, int ell) {
            if (g != null && g.length != null && v < g.vertexNumber) {
                ((Graph)g).length[v] = ell;
            }
        }

        public static int getPosition(Graph g, int v) {
            int res = -1;
            if (g != null && g.position != null && v < g.vertexNumber) {
                res = g.position[v];
            }
            return res;
        }

        public static void setPosition(Graph g, int v, int p) {
            if (g != null && g.position != null && v < g.vertexNumber) {
                ((Graph)g).position[v] = p;
            }
        }

        public static int getShift(Graph g, int v, int c) {
            int res = -1;
            if (g != null && g.shift != null && v < g.vertexNumber && v * c < g.edgeNumber) {
                res = g.shift[v * (g.edgeNumber / g.vertexNumber) + c];
            }
            return res;
        }

        public static void setShift(Graph g, int v, int c, int s) {
            if (g != null && g.shift != null && v < g.vertexNumber && v * c <= g.edgeNumber) {
                ((Graph)g).shift[v * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + c] = s;
            }
        }

        public static void copyVertex(Graph g, int target, int source) {
            if (g != null && target < g.vertexNumber && source < g.vertexNumber) {
                int i;
                if (g.target != null) {
                    for (i = 0; i < g.edgeNumber / g.vertexNumber; ++i) {
                        ((Graph)g).target[target * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + i] = g.target[source * (g.edgeNumber / g.vertexNumber) + i];
                    }
                }
                if (g.shift != null) {
                    for (i = 0; i < g.edgeNumber / g.vertexNumber; ++i) {
                        ((Graph)g).shift[target * (((Graph)g).edgeNumber / ((Graph)g).vertexNumber) + i] = g.shift[source * (g.edgeNumber / g.vertexNumber) + i];
                    }
                }
                if (g.terminal != null) {
                    ((Graph)g).terminal[target] = g.terminal[source];
                }
                if (g.suffixLink != null) {
                    ((Graph)g).suffixLink[target] = g.suffixLink[source];
                }
                if (g.length != null) {
                    ((Graph)g).length[target] = g.length[source];
                }
                if (g.position != null) {
                    ((Graph)g).position[target] = g.position[source];
                }
            }
        }
    }

    private static class Graph {
        private int vertexNumber;
        private int edgeNumber;
        private int vertexCounter;
        private int initial;
        private int[] terminal;
        private int[] target;
        private int[] suffixLink;
        private int[] length;
        private int[] position;
        private int[] shift;

        private Graph() {
        }

        static /* synthetic */ int[] access$502(Graph x0, int[] x1) {
            x0.target = x1;
            return x1;
        }

        static /* synthetic */ int[] access$602(Graph x0, int[] x1) {
            x0.terminal = x1;
            return x1;
        }

        static /* synthetic */ int[] access$702(Graph x0, int[] x1) {
            x0.suffixLink = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(Graph x0, int[] x1) {
            x0.length = x1;
            return x1;
        }

        static /* synthetic */ int[] access$902(Graph x0, int[] x1) {
            x0.position = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1002(Graph x0, int[] x1) {
            x0.shift = x1;
            return x1;
        }
    }
}

