/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.pmd.util.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static final TypeMap collectionInterfacesByNames = new TypeMap(List.class, Collection.class, Map.class, Set.class);
    public static final TypeMap collectionClassesByNames = new TypeMap(ArrayList.class, LinkedList.class, Vector.class, HashMap.class, LinkedHashMap.class, TreeMap.class, TreeSet.class, HashSet.class, LinkedHashSet.class);

    private CollectionUtil() {
    }

    public static Class getCollectionTypeFor(String shortName) {
        Class cls = collectionClassesByNames.typeFor(shortName);
        if (cls != null) {
            return cls;
        }
        return collectionInterfacesByNames.typeFor(shortName);
    }

    public static boolean isCollectionType(String typeName, boolean includeInterfaces) {
        if (collectionClassesByNames.contains(typeName)) {
            return true;
        }
        return includeInterfaces && collectionInterfacesByNames.contains(typeName);
    }

    public static boolean isCollectionType(Class clazzType, boolean includeInterfaces) {
        if (collectionClassesByNames.contains(clazzType)) {
            return true;
        }
        return includeInterfaces && collectionInterfacesByNames.contains(clazzType);
    }

    public static <T> Set<T> asSet(T[] items) {
        HashSet<T> set = new HashSet<T>(items.length);
        for (int i = 0; i < items.length; ++i) {
            set.add(items[i]);
        }
        return set;
    }

    public static <K, V> Map<K, V> mapFrom(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new RuntimeException("mapFrom keys and values arrays have different sizes");
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<V, K> invertedMapFrom(Map<K, V> source) {
        HashMap<V, K> map = new HashMap<V, K>(source.size());
        for (Map.Entry<K, V> entry : source.entrySet()) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    public static final boolean arraysAreEqual(Object value, Object otherValue) {
        if (value instanceof Object[]) {
            if (otherValue instanceof Object[]) {
                return CollectionUtil.valuesAreTransitivelyEqual((Object[])value, (Object[])otherValue);
            }
            return false;
        }
        return false;
    }

    public static final boolean valuesAreTransitivelyEqual(Object[] thisArray, Object[] thatArray) {
        if (thisArray == thatArray) {
            return true;
        }
        if (thisArray == null || thatArray == null) {
            return false;
        }
        if (thisArray.length != thatArray.length) {
            return false;
        }
        for (int i = 0; i < thisArray.length; ++i) {
            if (CollectionUtil.areEqual(thisArray[i], thatArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        if (value.getClass().getComponentType() != null) {
            return CollectionUtil.arraysAreEqual(value, otherValue);
        }
        return value.equals(otherValue);
    }
}

