/*
 * Decompiled with CFR 0.152.
 */
package javapns.devices.implementations.basic;

import java.sql.Timestamp;
import javapns.devices.Device;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;

public class BasicDevice
implements Device {
    private String deviceId;
    private String token;
    private Timestamp lastRegister;

    public BasicDevice(String token) throws InvalidDeviceTokenFormatException {
        this(token, true);
    }

    public BasicDevice(String token, boolean validate) throws InvalidDeviceTokenFormatException {
        this.deviceId = token;
        this.token = token;
        try {
            this.lastRegister = new Timestamp(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (validate) {
            BasicDevice.validateTokenFormat(token);
        }
    }

    public BasicDevice() {
    }

    public void validateTokenFormat() throws InvalidDeviceTokenFormatException {
        BasicDevice.validateTokenFormat(this.token);
    }

    public static void validateTokenFormat(String token) throws InvalidDeviceTokenFormatException {
        if (token == null) {
            throw new InvalidDeviceTokenFormatException("Device Token is null, and not the required 64 bytes...");
        }
        if (token.getBytes().length != 64) {
            throw new InvalidDeviceTokenFormatException("Device Token has a length of [" + token.getBytes().length + "] and not the required 64 bytes!");
        }
    }

    public BasicDevice(String id, String token, Timestamp register) throws InvalidDeviceTokenFormatException {
        this.deviceId = id;
        this.token = token;
        this.lastRegister = register;
        BasicDevice.validateTokenFormat(token);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getToken() {
        return this.token;
    }

    public Timestamp getLastRegister() {
        return this.lastRegister;
    }

    public void setDeviceId(String id) {
        this.deviceId = id;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setLastRegister(Timestamp lastRegister) {
        this.lastRegister = lastRegister;
    }
}

