/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.logging;

import org.javasimon.callback.logging.LogTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SLF4JLogTemplate<C>
extends LogTemplate<C> {
    protected final Logger logger;
    protected final Marker marker;

    protected SLF4JLogTemplate(Logger logger, Marker marker) {
        this.logger = logger;
        this.marker = marker;
    }

    protected SLF4JLogTemplate(String loggerName, String markerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
        this.marker = markerName == null ? null : MarkerFactory.getMarker((String)markerName);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Marker getMarker() {
        return this.marker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Warn<C>
    extends SLF4JLogTemplate<C> {
        public Warn(String loggerName, String markerName) {
            super(loggerName, markerName);
        }

        public Warn(Logger logger, Marker marker) {
            super(logger, marker);
        }

        @Override
        protected boolean isEnabled(C context) {
            return this.logger.isWarnEnabled(this.marker);
        }

        @Override
        protected void log(String message) {
            this.logger.warn(this.marker, message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info<C>
    extends SLF4JLogTemplate<C> {
        public Info(String loggerName, String markerName) {
            super(loggerName, markerName);
        }

        public Info(Logger logger, Marker marker) {
            super(logger, marker);
        }

        @Override
        protected boolean isEnabled(C context) {
            return this.logger.isInfoEnabled(this.marker);
        }

        @Override
        protected void log(String message) {
            this.logger.info(this.marker, message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Debug<C>
    extends SLF4JLogTemplate<C> {
        public Debug(String loggerName, String markerName) {
            super(loggerName, markerName);
        }

        public Debug(Logger logger, Marker marker) {
            super(logger, marker);
        }

        @Override
        protected boolean isEnabled(C context) {
            return this.logger.isDebugEnabled(this.marker);
        }

        @Override
        protected void log(String message) {
            this.logger.debug(this.marker, message);
        }
    }
}

