/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClassLoaderAwareAsyncCall;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.concurrentmap.AddMapIndex;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.MapOperationsCounter;
import com.hazelcast.monitor.LocalMapOperationStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.util.Clock;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MProxyImpl
extends FactoryAwareNamedProxy
implements MProxy,
DataSerializable {
    private transient MProxy mproxyReal = null;
    private transient ConcurrentMapManager concurrentMapManager = null;
    private transient ListenerManager listenerManager = null;
    private volatile transient MProxy dynamicProxy;

    public MProxyImpl() {
    }

    MProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.mproxyReal = new MProxyReal();
    }

    @Override
    public MapOperationsCounter getMapOperationCounter() {
        return this.mproxyReal.getMapOperationCounter();
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        super.setHazelcastInstance(hazelcastInstance);
        this.concurrentMapManager = this.factory.node.concurrentMapManager;
        this.listenerManager = this.factory.node.listenerManager;
        ClassLoader cl = MProxy.class.getClassLoader();
        this.dynamicProxy = (MProxy)Proxy.newProxyInstance(cl, new Class[]{MProxy.class}, (InvocationHandler)new DynamicInvoker());
    }

    private void beforeCall() {
        this.factory.initialChecks();
        if (this.mproxyReal == null) {
            this.mproxyReal = (MProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    private void afterCall() {
    }

    @Override
    public Object get(Object key) {
        this.beforeCall();
        try {
            Object v = this.mproxyReal.get(key);
            return v;
        }
        catch (Throwable e) {
            Util.throwUncheckedException(e);
            return null;
        }
        finally {
            this.afterCall();
        }
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put(key, value, -1L, TimeUnit.SECONDS);
    }

    public Future getAsync(Object key) {
        this.beforeCall();
        final MProxyImpl mProxy = this;
        final Data dataKey = IOUtil.toData(key);
        ClassLoaderAwareAsyncCall call = new ClassLoaderAwareAsyncCall(){

            @Override
            protected void call() {
                this.setResult(mProxy.get(dataKey));
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    public Future putAsync(Object key, Object value) {
        this.beforeCall();
        final MProxyImpl mProxy = this;
        final Data dataKey = IOUtil.toData(key);
        final Data dataValue = IOUtil.toData(value);
        ClassLoaderAwareAsyncCall call = new ClassLoaderAwareAsyncCall(){

            @Override
            protected void call() {
                this.setResult(mProxy.put(dataKey, dataValue));
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    public Future removeAsync(Object key) {
        this.beforeCall();
        final MProxyImpl mProxy = this;
        final Data dataKey = IOUtil.toData(key);
        ClassLoaderAwareAsyncCall call = new ClassLoaderAwareAsyncCall(){

            @Override
            protected void call() {
                this.setResult(mProxy.remove(dataKey));
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
        this.beforeCall();
        try {
            Object object = this.mproxyReal.put(key, value, ttl, timeunit);
            return object;
        }
        catch (Throwable e) {
            Util.throwUncheckedException(e);
            return null;
        }
        finally {
            this.afterCall();
        }
    }

    @Override
    public Object remove(Object key) {
        this.beforeCall();
        try {
            Object v = this.mproxyReal.remove(key);
            return v;
        }
        catch (Throwable e) {
            Util.throwUncheckedException(e);
            return null;
        }
        finally {
            this.afterCall();
        }
    }

    public Object tryRemove(Object key, long time, TimeUnit timeunit) throws TimeoutException {
        this.beforeCall();
        try {
            Object object = this.mproxyReal.tryRemove(key, time, timeunit);
            return object;
        }
        catch (Throwable e) {
            if (e instanceof TimeoutException) {
                throw (TimeoutException)e;
            }
            Util.throwUncheckedException(e);
            return null;
        }
        finally {
            this.afterCall();
        }
    }

    public void putAndUnlock(Object key, Object value) {
        this.dynamicProxy.putAndUnlock(key, value);
    }

    public Object tryLockAndGet(Object key, long time, TimeUnit timeunit) throws TimeoutException {
        return this.dynamicProxy.tryLockAndGet(key, time, timeunit);
    }

    public Map getAll(Set keys) {
        return this.dynamicProxy.getAll(keys);
    }

    @Override
    public void flush() {
        this.dynamicProxy.flush();
    }

    @Override
    public void putForSync(Object key, Object value) {
        this.dynamicProxy.putForSync(key, value);
    }

    @Override
    public void removeForSync(Object key) {
        this.dynamicProxy.removeForSync(key);
    }

    public void putTransient(Object key, Object value, long time, TimeUnit timeunit) {
        this.dynamicProxy.putTransient(key, value, time, timeunit);
    }

    @Override
    public boolean putFromLoad(Object key, Object value) {
        return this.dynamicProxy.putFromLoad(key, value);
    }

    public boolean tryPut(Object key, Object value, long time, TimeUnit timeunit) {
        return this.dynamicProxy.tryPut(key, value, time, timeunit);
    }

    public void set(Object key, Object value, long time, TimeUnit timeunit) {
        this.dynamicProxy.set(key, value, time, timeunit);
    }

    public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
        return this.dynamicProxy.putIfAbsent(key, value, ttl, timeunit);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.dynamicProxy.putIfAbsent(key, value);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        return this.dynamicProxy.getLocalMapStats();
    }

    @Override
    public void addIndex(String attribute, boolean ordered) {
        this.dynamicProxy.addIndex(attribute, ordered);
    }

    public void addIndex(Expression expression, boolean ordered) {
        this.dynamicProxy.addIndex(expression, ordered);
    }

    @Override
    public Object getId() {
        return this.dynamicProxy.getId();
    }

    public String toString() {
        return "Map [" + this.getName() + "] ";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MProxyImpl mProxy = (MProxyImpl)o;
        return this.name.equals(mProxy.name);
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public void destroy() {
        this.dynamicProxy.destroy();
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return this.dynamicProxy.getInstanceType();
    }

    @Override
    public boolean removeKey(Object key) {
        return this.dynamicProxy.removeKey(key);
    }

    @Override
    public int size() {
        return this.dynamicProxy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dynamicProxy.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.dynamicProxy.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dynamicProxy.containsValue(value);
    }

    public MapEntry getMapEntry(Object key) {
        return this.dynamicProxy.getMapEntry(key);
    }

    @Override
    public void putAll(Map t) {
        this.dynamicProxy.putAll(t);
    }

    @Override
    public void clear() {
        this.dynamicProxy.clear();
    }

    @Override
    public int valueCount(Object key) {
        return this.dynamicProxy.valueCount(key);
    }

    @Override
    public Set allKeys() {
        return this.dynamicProxy.allKeys();
    }

    public Set localKeySet() {
        return this.dynamicProxy.localKeySet();
    }

    public Set localKeySet(Predicate predicate) {
        return this.dynamicProxy.localKeySet(predicate);
    }

    @Override
    public Set keySet() {
        return this.dynamicProxy.keySet();
    }

    @Override
    public Collection values() {
        return this.dynamicProxy.values();
    }

    @Override
    public Set entrySet() {
        return this.dynamicProxy.entrySet();
    }

    public Set keySet(Predicate predicate) {
        return this.dynamicProxy.keySet(predicate);
    }

    public Collection values(Predicate predicate) {
        return this.dynamicProxy.values(predicate);
    }

    public Set entrySet(Predicate predicate) {
        return this.dynamicProxy.entrySet(predicate);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.dynamicProxy.remove(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.dynamicProxy.replace(key, oldValue, newValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        return this.dynamicProxy.replace(key, value);
    }

    @Override
    public String getName() {
        return this.name.substring("c:".length());
    }

    @Override
    public boolean lockMap(long time, TimeUnit timeunit) {
        return this.dynamicProxy.lockMap(time, timeunit);
    }

    @Override
    public void unlockMap() {
        this.dynamicProxy.unlockMap();
    }

    public void lock(Object key) {
        this.dynamicProxy.lock(key);
    }

    public boolean isLocked(Object key) {
        return this.dynamicProxy.isLocked(key);
    }

    public boolean tryLock(Object key) {
        return this.dynamicProxy.tryLock(key);
    }

    public boolean tryLock(Object key, long time, TimeUnit timeunit) {
        return this.dynamicProxy.tryLock(key, time, timeunit);
    }

    public void unlock(Object key) {
        this.dynamicProxy.unlock(key);
    }

    public void forceUnlock(Object key) {
        this.dynamicProxy.forceUnlock(key);
    }

    @Override
    public String getLongName() {
        return this.name;
    }

    @Override
    public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
        this.dynamicProxy.addGenericListener(listener, key, includeValue, instanceType);
    }

    @Override
    public void removeGenericListener(Object listener, Object key) {
        this.dynamicProxy.removeGenericListener(listener, key);
    }

    public void addLocalEntryListener(EntryListener entryListener) {
        this.dynamicProxy.addLocalEntryListener(entryListener);
    }

    public void addEntryListener(EntryListener listener, boolean includeValue) {
        this.dynamicProxy.addEntryListener(listener, includeValue);
    }

    public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
        this.dynamicProxy.addEntryListener(listener, key, includeValue);
    }

    public void removeEntryListener(EntryListener listener) {
        this.dynamicProxy.removeEntryListener(listener);
    }

    public void removeEntryListener(EntryListener listener, Object key) {
        this.dynamicProxy.removeEntryListener(listener, key);
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.dynamicProxy.containsEntry(key, value);
    }

    @Override
    public boolean putMulti(Object key, Object value) {
        return this.dynamicProxy.putMulti(key, value);
    }

    @Override
    public boolean removeMulti(Object key, Object value) {
        return this.dynamicProxy.removeMulti(key, value);
    }

    @Override
    public boolean add(Object value) {
        return this.dynamicProxy.add(value);
    }

    @Override
    public boolean evict(Object key) {
        return this.dynamicProxy.evict(key);
    }

    private static void check(Object obj) {
        Util.checkSerializable(obj);
    }

    private class DynamicInvoker
    implements InvocationHandler {
        private DynamicInvoker() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MProxyImpl.this.beforeCall();
            try {
                Object object = method.invoke((Object)MProxyImpl.this.mproxyReal, args);
                return object;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)e;
                    throw ite.getCause();
                }
                if (e instanceof OutOfMemoryError) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
                }
                throw e;
            }
            finally {
                MProxyImpl.this.afterCall();
            }
        }
    }

    private class MProxyReal
    implements MProxy {
        private final transient MapOperationsCounter mapOperationCounter = new MapOperationsCounter();

        public String toString() {
            return MProxyImpl.this.toString();
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.MAP;
        }

        @Override
        public Object getId() {
            return MProxyImpl.this.name;
        }

        @Override
        public boolean equals(Object o) {
            return MProxyImpl.this.equals(o);
        }

        @Override
        public int hashCode() {
            return MProxyImpl.this.hashCode();
        }

        @Override
        public String getLongName() {
            return MProxyImpl.this.name;
        }

        @Override
        public String getName() {
            return MProxyImpl.this.getName();
        }

        @Override
        public void addIndex(String attribute, boolean ordered) {
            this.addIndex((Expression)Predicates.get(attribute), ordered);
        }

        public void addIndex(Expression expression, boolean ordered) {
            final CountDownLatch latch = new CountDownLatch(1);
            final AddMapIndex addMapIndexProcess = new AddMapIndex(MProxyImpl.this.name, expression, ordered);
            MProxyImpl.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                @Override
                public void process() {
                    MProxyImpl.this.concurrentMapManager.sendProcessableToAll(addMapIndexProcess, true);
                    latch.countDown();
                }
            });
            try {
                latch.await();
                Throwable error = addMapIndexProcess.getError();
                if (error != null) {
                    Util.throwUncheckedException(error);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            MProxyImpl.this.concurrentMapManager.flush(MProxyImpl.this.name);
        }

        public MapEntry getMapEntry(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MGetMapEntry mgetMapEntry = new ConcurrentMapManager.MGetMapEntry(MProxyImpl.this.concurrentMapManager);
            MapEntry mapEntry = mgetMapEntry.get(MProxyImpl.this.name, key);
            this.mapOperationCounter.incrementGets(Clock.currentTimeMillis() - begin);
            return mapEntry;
        }

        @Override
        public boolean putMulti(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPutMulti mput = new ConcurrentMapManager.MPutMulti(MProxyImpl.this.concurrentMapManager);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return mput.put(MProxyImpl.this.name, key, value);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.put(key, value, -1L, TimeUnit.SECONDS);
        }

        @Override
        public void putForSync(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            mput.putForSync(MProxyImpl.this.name, key, value);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
        }

        @Override
        public void removeForSync(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
            mremove.removeForSync(MProxyImpl.this.name, key);
            mremove.clearRequest();
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
        }

        public Map getAll(Set keys) {
            if (keys == null) {
                throw new NullPointerException();
            }
            return MProxyImpl.this.concurrentMapManager.getAll(MProxyImpl.this.name, keys);
        }

        public Future getAsync(Object key) {
            throw new UnsupportedOperationException();
        }

        public Future putAsync(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Future removeAsync(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
            if (ttl < 0L && ttl != -1L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            if (ttl > 0L) {
                ttl = Util.toMillis(ttl, timeunit);
            }
            return this.put(key, value, ttl);
        }

        public void putTransient(Object key, Object value, long ttl, TimeUnit timeunit) {
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            this.mapOperationCounter.incrementOtherOperations();
            MProxyImpl.this.concurrentMapManager.putTransient(MProxyImpl.this.name, key, value, ttl);
        }

        @Override
        public boolean putFromLoad(Object key, Object value) {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.putFromLoad(MProxyImpl.this.name, key, value);
        }

        public Object put(Object key, Object value, long ttl) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            Object result = mput.put(MProxyImpl.this.name, key, value, ttl);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public void set(Object key, Object value, long ttl, TimeUnit timeunit) {
            long begin = Clock.currentTimeMillis();
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            mput.set(MProxyImpl.this.name, key, value, ttl);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
        }

        public boolean tryPut(Object key, Object value, long timeout, TimeUnit timeunit) {
            long begin = Clock.currentTimeMillis();
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
            }
            timeout = Util.toMillis(timeout, timeunit);
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            Boolean result = mput.tryPut(MProxyImpl.this.name, key, value, timeout, -1L);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object tryLockAndGet(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
            long begin = Clock.currentTimeMillis();
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
            }
            timeout = Util.toMillis(timeout, timeunit);
            MProxyImpl.check(key);
            Object result = MProxyImpl.this.concurrentMapManager.tryLockAndGet(MProxyImpl.this.name, key, timeout);
            this.mapOperationCounter.incrementGets(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public boolean lockMap(long time, TimeUnit timeunit) {
            if (((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.tryLock("map_lock_" + MProxyImpl.this.name, time, timeunit)) {
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MLockMap mLockMap = new ConcurrentMapManager.MLockMap(concurrentMapManager, MProxyImpl.this.name, true);
                mLockMap.call();
                return true;
            }
            return false;
        }

        @Override
        public void unlockMap() {
            ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
            concurrentMapManager.getClass();
            ConcurrentMapManager.MLockMap mLockMap = new ConcurrentMapManager.MLockMap(concurrentMapManager, MProxyImpl.this.name, false);
            mLockMap.call();
            ((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.unlock("map_lock_" + MProxyImpl.this.name);
        }

        public void lock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            MProxyImpl.this.concurrentMapManager.lock(MProxyImpl.this.name, key, -1L);
        }

        public boolean isLocked(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MLock mlock = new ConcurrentMapManager.MLock(MProxyImpl.this.concurrentMapManager);
            return mlock.isLocked(MProxyImpl.this.name, key);
        }

        public boolean tryLock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.lock(MProxyImpl.this.name, key, 0L);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            MProxyImpl.check(key);
            if (time < 0L) {
                throw new IllegalArgumentException("Time cannot be negative. time = " + time);
            }
            this.mapOperationCounter.incrementOtherOperations();
            long timeoutMillis = Util.toMillis(time, timeunit);
            return MProxyImpl.this.concurrentMapManager.lock(MProxyImpl.this.name, key, timeoutMillis);
        }

        public void unlock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MLock mlock = new ConcurrentMapManager.MLock(MProxyImpl.this.concurrentMapManager);
            if (!mlock.unlock(MProxyImpl.this.name, key, 0L)) {
                throw new IllegalMonitorStateException("Current thread is not owner of the lock!");
            }
        }

        public void forceUnlock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MLock mlock = new ConcurrentMapManager.MLock(MProxyImpl.this.concurrentMapManager);
            mlock.forceUnlock(MProxyImpl.this.name, key);
        }

        public void putAndUnlock(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            MProxyImpl.this.concurrentMapManager.putAndUnlock(MProxyImpl.this.name, key, value);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
        }

        @Override
        public Object putIfAbsent(Object key, Object value) {
            return this.putIfAbsent(key, value, -1L);
        }

        public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            return this.putIfAbsent(key, value, ttl);
        }

        private Object putIfAbsent(Object key, Object value, long ttl) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = new ConcurrentMapManager.MPut(MProxyImpl.this.concurrentMapManager);
            Object result = mput.putIfAbsent(MProxyImpl.this.name, key, value, ttl);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public Object get(Object key) {
            MProxyImpl.check(key);
            long begin = Clock.currentTimeMillis();
            ConcurrentMapManager.MGet mget = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMGet();
            Object result = mget.get(MProxyImpl.this.name, key, -1L);
            mget.clearRequest();
            this.mapOperationCounter.incrementGets(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public Object remove(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
            Object result = mremove.remove(MProxyImpl.this.name, key);
            mremove.clearRequest();
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object tryRemove(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
            Object result = mremove.tryRemove(MProxyImpl.this.name, key, Util.toMillis(timeout, timeunit));
            mremove.clearRequest();
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public int size() {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.size(MProxyImpl.this.name);
        }

        @Override
        public int valueCount(Object key) {
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MValueCount mcount = new ConcurrentMapManager.MValueCount(MProxyImpl.this.concurrentMapManager);
            int count = ((Number)mcount.count(MProxyImpl.this.name, key, -1L)).intValue();
            return count;
        }

        @Override
        public boolean removeMulti(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MRemoveMulti mremove = new ConcurrentMapManager.MRemoveMulti(MProxyImpl.this.concurrentMapManager);
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return mremove.remove(MProxyImpl.this.name, key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MRemove mremove = new ConcurrentMapManager.MRemove(MProxyImpl.this.concurrentMapManager);
            boolean result = mremove.removeIfSame(MProxyImpl.this.name, key, value);
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public Object replace(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = new ConcurrentMapManager.MPut(MProxyImpl.this.concurrentMapManager);
            Object result = mput.replace(MProxyImpl.this.name, key, value);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public boolean replace(Object key, Object oldValue, Object newValue) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(oldValue);
            MProxyImpl.check(newValue);
            ConcurrentMapManager.MPut mput = new ConcurrentMapManager.MPut(MProxyImpl.this.concurrentMapManager);
            Boolean result = mput.replace(MProxyImpl.this.name, key, oldValue, newValue);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public LocalMapStats getLocalMapStats() {
            this.mapOperationCounter.incrementOtherOperations();
            LocalMapStatsImpl localMapStats = MProxyImpl.this.concurrentMapManager.getLocalMapStats(MProxyImpl.this.name);
            localMapStats.setOperationStats((LocalMapOperationStats)this.mapOperationCounter.getPublishedStats());
            return localMapStats;
        }

        @Override
        public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.this.listenerManager.addListener(MProxyImpl.this.name, listener, key, includeValue, instanceType);
        }

        @Override
        public void removeGenericListener(Object listener, Object key) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.this.listenerManager.removeListener(MProxyImpl.this.name, listener, key);
        }

        public void addLocalEntryListener(EntryListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.this.listenerManager.addLocalListener(MProxyImpl.this.name, listener, this.getInstanceType());
        }

        public void addEntryListener(EntryListener listener, boolean includeValue) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            this.addGenericListener(listener, null, includeValue, this.getInstanceType());
        }

        public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.check(key);
            this.addGenericListener(listener, key, includeValue, this.getInstanceType());
        }

        public void removeEntryListener(EntryListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            this.removeGenericListener(listener, null);
        }

        public void removeEntryListener(EntryListener listener, Object key) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.check(key);
            this.removeGenericListener(listener, key);
        }

        @Override
        public boolean containsEntry(Object key, Object value) {
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            this.mapOperationCounter.incrementOtherOperations();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.has(MProxyImpl.this.name, key) && txn.containsEntry(MProxyImpl.this.name, key, value)) {
                return true;
            }
            ConcurrentMapManager.MContainsKey mContainsKey = new ConcurrentMapManager.MContainsKey(MProxyImpl.this.concurrentMapManager);
            return mContainsKey.containsEntry(MProxyImpl.this.name, key, value);
        }

        @Override
        public boolean containsKey(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.has(MProxyImpl.this.name, key)) {
                Data value = txn.get(MProxyImpl.this.name, key);
                return value != null;
            }
            ConcurrentMapManager.MContainsKey mContainsKey = new ConcurrentMapManager.MContainsKey(MProxyImpl.this.concurrentMapManager);
            return mContainsKey.containsKey(MProxyImpl.this.name, key);
        }

        @Override
        public boolean containsValue(Object value) {
            MProxyImpl.check(value);
            this.mapOperationCounter.incrementOtherOperations();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.containsValue(MProxyImpl.this.name, value)) {
                return true;
            }
            ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
            concurrentMapManager.getClass();
            ConcurrentMapManager.MContainsValue mContainsValue = new ConcurrentMapManager.MContainsValue(concurrentMapManager, MProxyImpl.this.name, value);
            return (Boolean)mContainsValue.call();
        }

        @Override
        public boolean isEmpty() {
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MEmpty mempty = new ConcurrentMapManager.MEmpty(MProxyImpl.this.concurrentMapManager);
            return mempty.isEmpty(MProxyImpl.this.name);
        }

        @Override
        public void putAll(Map map) {
            Set entries = map.entrySet();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                for (Map.Entry entry : entries) {
                    this.put(entry.getKey(), entry.getValue());
                }
            } else {
                MProxyImpl.this.concurrentMapManager.doPutAll(MProxyImpl.this.name, map);
            }
        }

        @Override
        public boolean add(Object value) {
            MProxyImpl.check(value);
            Object old = this.putIfAbsent(value, IOUtil.toData(Boolean.TRUE));
            return old == null;
        }

        @Override
        public boolean removeKey(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemoveItem mRemoveItem = new ConcurrentMapManager.MRemoveItem(MProxyImpl.this.concurrentMapManager);
            boolean result = mRemoveItem.removeItem(MProxyImpl.this.name, key);
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        @Override
        public void clear() {
            CMap cMap = MProxyImpl.this.concurrentMapManager.getMap(MProxyImpl.this.name);
            if (cMap != null && cMap.isClearQuick()) {
                this.mapOperationCounter.incrementOtherOperations();
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MClearQuick mClearQuick = new ConcurrentMapManager.MClearQuick(concurrentMapManager, MProxyImpl.this.name);
                mClearQuick.call();
            } else {
                Set keys = this.keySet();
                for (Object key : keys) {
                    this.removeKey(key);
                }
            }
        }

        public Set localKeySet() {
            return this.localKeySet(null);
        }

        public Set localKeySet(Predicate predicate) {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.queryLocal(MProxyImpl.this.name, ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, predicate);
        }

        public Set entrySet(Predicate predicate) {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, predicate);
        }

        public Set keySet(Predicate predicate) {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, predicate);
        }

        public Collection values(Predicate predicate) {
            return this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, predicate);
        }

        @Override
        public Set entrySet() {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, null);
        }

        @Override
        public Set keySet() {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null);
        }

        @Override
        public Set allKeys() {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL, null);
        }

        @Override
        public MapOperationsCounter getMapOperationCounter() {
            return this.mapOperationCounter;
        }

        @Override
        public Collection values() {
            return this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, null);
        }

        private Collection query(ClusterOperation iteratorType, Predicate predicate) {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.query(MProxyImpl.this.name, iteratorType, predicate);
        }

        @Override
        public void destroy() {
            MProxyImpl.this.factory.destroyInstanceClusterWide(MProxyImpl.this.name, null);
        }

        @Override
        public boolean evict(Object key) {
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MEvict mevict = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMEvict();
            boolean result = mevict.evict(MProxyImpl.this.name, key);
            mevict.clearRequest();
            return result;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

