/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.samples.transform;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.field.address.AddressBuilder;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.TempFileStorageProvider;

public class TransformMessage {
    private static final String HOSTNAME = "localhost";

    public static void main(String[] args) throws Exception {
        TempFileStorageProvider storageProvider = new TempFileStorageProvider();
        DefaultStorageProvider.setInstance((StorageProvider)storageProvider);
        Message template = TransformMessage.createTemplate();
        Message transformed = TransformMessage.transform(template);
        DefaultMessageWriter writer = new DefaultMessageWriter();
        System.out.println("\n\nTransformed message:\n--------------------\n");
        writer.writeMessage(transformed, (OutputStream)System.out);
        transformed.dispose();
        System.out.println("\n\nOriginal template:\n------------------\n");
        writer.writeMessage(template, (OutputStream)System.out);
        template.dispose();
    }

    private static Message transform(Message original) throws IOException, ParseException {
        DefaultMessageBuilder builder = new DefaultMessageBuilder();
        Message message = builder.newMessage(original);
        Multipart multipart = (Multipart)message.getBody();
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            String text = "Text inserted after part " + (i + 1);
            BodyPart bodyPart = TransformMessage.createTextPart(text);
            multipart.addBodyPart((Entity)bodyPart, 2 * i + 1);
        }
        Entity removed = multipart.removeBodyPart(4);
        removed.dispose();
        message.createMessageId(HOSTNAME);
        message.setSubject("Transformed message");
        message.setDate(new Date());
        message.setFrom(AddressBuilder.DEFAULT.parseMailbox("John Doe <jdoe@machine.example>"));
        return message;
    }

    private static Message createTemplate() throws IOException {
        MultipartImpl multipart = new MultipartImpl("mixed");
        BodyPart part1 = TransformMessage.createTextPart("This is the first part of the template..");
        multipart.addBodyPart((Entity)part1);
        BodyPart part2 = TransformMessage.createRandomBinaryPart(200);
        multipart.addBodyPart((Entity)part2);
        BodyPart part3 = TransformMessage.createRandomBinaryPart(300);
        multipart.addBodyPart((Entity)part3);
        MessageImpl message = new MessageImpl();
        message.setMultipart((Multipart)multipart);
        message.setSubject("Template message");
        return message;
    }

    private static BodyPart createTextPart(String text) {
        TextBody body = new StorageBodyFactory().textBody(text, "UTF-8");
        BodyPart bodyPart = new BodyPart();
        bodyPart.setText(body);
        bodyPart.setContentTransferEncoding("quoted-printable");
        return bodyPart;
    }

    private static BodyPart createRandomBinaryPart(int numberOfBytes) throws IOException {
        byte[] data = new byte[numberOfBytes];
        new Random().nextBytes(data);
        BinaryBody body = new StorageBodyFactory().binaryBody((InputStream)new ByteArrayInputStream(data));
        BodyPart bodyPart = new BodyPart();
        bodyPart.setBody((Body)body, "application/octet-stream");
        bodyPart.setContentTransferEncoding("base64");
        return bodyPart;
    }
}

