/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.DefaultRecordStore;
import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionContainer {
    private final MapService mapService;
    private final int partitionId;
    private final ConcurrentMap<String, RecordStore> maps = new ConcurrentHashMap<String, RecordStore>(1000);
    private final ConstructorFunction<String, RecordStore> recordStoreConstructor = new ConstructorFunction<String, RecordStore>(){

        @Override
        public RecordStore createNew(String name) {
            return new DefaultRecordStore(name, PartitionContainer.this.mapService, PartitionContainer.this.partitionId);
        }
    };

    public PartitionContainer(MapService mapService, int partitionId) {
        this.mapService = mapService;
        this.partitionId = partitionId;
    }

    public ConcurrentMap<String, RecordStore> getMaps() {
        return this.maps;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public MapService getMapService() {
        return this.mapService;
    }

    public RecordStore getExistingRecordStore(String name) {
        return (RecordStore)this.maps.get(name);
    }

    public RecordStore getRecordStore(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.maps, name, this.recordStoreConstructor);
    }

    void destroyMap(String name) {
        RecordStore recordStore = (RecordStore)this.maps.remove(name);
        if (recordStore != null) {
            recordStore.clear();
        }
    }

    void clear() {
        for (RecordStore recordStore : this.maps.values()) {
            recordStore.clear();
        }
        this.maps.clear();
    }
}

