/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twitter4j.Configuration;
import twitter4j.TwitterException;
import twitter4j.http.HTMLEntity;
import twitter4j.http.Response;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

public class TwitterResponse
implements Serializable {
    private static Map<String, SimpleDateFormat> formatMap = new HashMap<String, SimpleDateFormat>();
    private static final long serialVersionUID = 3519962197957449562L;
    private transient int rateLimitLimit = -1;
    private transient int rateLimitRemaining = -1;
    private transient long rateLimitReset = -1L;
    private static final boolean IS_DALVIK = Configuration.isDalvik();

    public TwitterResponse() {
    }

    public TwitterResponse(Response res) {
        String reset;
        String remaining;
        String limit = res.getResponseHeader("X-RateLimit-Limit");
        if (limit != null) {
            this.rateLimitLimit = Integer.parseInt(limit);
        }
        if ((remaining = res.getResponseHeader("X-RateLimit-Remaining")) != null) {
            this.rateLimitRemaining = Integer.parseInt(remaining);
        }
        if ((reset = res.getResponseHeader("X-RateLimit-Reset")) != null) {
            this.rateLimitReset = Long.parseLong(reset);
        }
    }

    protected static void ensureRootNodeNameIs(String rootName, Element elem) throws TwitterException {
        if (!rootName.equals(elem.getNodeName())) {
            throw new TwitterException("Unexpected root node name:" + elem.getNodeName() + ". Expected:" + rootName + ". Check the availability of the Twitter API at http://status.twitter.com/.");
        }
    }

    protected static void ensureRootNodeNameIs(String[] rootNames, Element elem) throws TwitterException {
        String actualRootName = elem.getNodeName();
        String[] stringArray = rootNames;
        int n = rootNames.length;
        int n2 = 0;
        while (n2 < n) {
            String rootName = stringArray[n2];
            if (rootName.equals(actualRootName)) {
                return;
            }
            ++n2;
        }
        String expected = "";
        int i = 0;
        while (i < rootNames.length) {
            if (i != 0) {
                expected = String.valueOf(expected) + " or ";
            }
            expected = String.valueOf(expected) + rootNames[i];
            ++i;
        }
        throw new TwitterException("Unexpected root node name:" + elem.getNodeName() + ". Expected:" + expected + ". Check the availability of the Twitter API at http://status.twitter.com/.");
    }

    protected static void ensureRootNodeNameIs(String rootName, Document doc) throws TwitterException {
        Element elem = doc.getDocumentElement();
        if (!rootName.equals(elem.getNodeName())) {
            throw new TwitterException("Unexpected root node name:" + elem.getNodeName() + ". Expected:" + rootName + ". Check the availability of the Twitter API at http://status.twitter.com/");
        }
    }

    protected static boolean isRootNodeNilClasses(Document doc) {
        String root = doc.getDocumentElement().getNodeName();
        return "nil-classes".equals(root) || "nilclasses".equals(root);
    }

    protected static String getChildText(String str, Element elem) {
        return HTMLEntity.unescape(TwitterResponse.getTextContent(str, elem));
    }

    protected static String getTextContent(String str, Element elem) {
        Node node;
        NodeList nodelist = elem.getElementsByTagName(str);
        if (nodelist.getLength() > 0 && (node = nodelist.item(0).getFirstChild()) != null) {
            String nodeValue = node.getNodeValue();
            return nodeValue != null ? nodeValue : "";
        }
        return "";
    }

    protected static int getChildInt(String str, Element elem) {
        String str2 = TwitterResponse.getTextContent(str, elem);
        if (str2 == null || "".equals(str2)) {
            return -1;
        }
        return Integer.valueOf(str2);
    }

    protected static long getChildLong(String str, Element elem) {
        String str2 = TwitterResponse.getTextContent(str, elem);
        if (str2 == null || "".equals(str2)) {
            return -1L;
        }
        return Long.valueOf(str2);
    }

    protected static String getString(String name, JSONObject json, boolean decode) {
        String returnValue = null;
        try {
            returnValue = json.getString(name);
            if (decode) {
                try {
                    returnValue = URLDecoder.decode(returnValue, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return returnValue;
    }

    protected static boolean getChildBoolean(String str, Element elem) {
        String value = TwitterResponse.getTextContent(str, elem);
        return Boolean.valueOf(value);
    }

    protected static Date getChildDate(String str, Element elem) throws TwitterException {
        return TwitterResponse.getChildDate(str, elem, "EEE MMM d HH:mm:ss z yyyy");
    }

    protected static Date getChildDate(String str, Element elem, String format) throws TwitterException {
        return TwitterResponse.parseDate(TwitterResponse.getChildText(str, elem), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Date parseDate(String str, String format) throws TwitterException {
        SimpleDateFormat sdf = formatMap.get(format);
        if (sdf == null) {
            sdf = new SimpleDateFormat(format, Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            formatMap.put(format, sdf);
        }
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.parse(str);
            }
        }
        catch (ParseException pe) {
            throw new TwitterException("Unexpected format(" + str + ") returned from twitter.com");
        }
    }

    protected static int getInt(String key, JSONObject json) throws JSONException {
        String str = json.getString(key);
        if (str == null || "null".equals(str)) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    protected static long getLong(String key, JSONObject json) throws JSONException {
        String str = json.getString(key);
        if (str == null || "null".equals(str)) {
            return -1L;
        }
        return Long.parseLong(str);
    }

    protected static boolean getBoolean(String key, JSONObject json) throws JSONException {
        String str = json.getString(key);
        if (str == null || "null".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }

    public int getRateLimitLimit() {
        return this.rateLimitLimit;
    }

    public int getRateLimitRemaining() {
        return this.rateLimitRemaining;
    }

    public long getRateLimitReset() {
        return this.rateLimitReset;
    }
}

