/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.base.SystemLogRecord;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class GetLogsRequest
implements ConsoleRequest {
    @Override
    public int getType() {
        return 11;
    }

    @Override
    public Object readResponse(DataInput in) throws IOException {
        LinkedList<SystemLogRecord> list = new LinkedList<SystemLogRecord>();
        String node = in.readUTF();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            SystemLogRecord systemLogRecord = new SystemLogRecord();
            systemLogRecord.readData(in);
            systemLogRecord.setNode(node);
            list.add(systemLogRecord);
            ++i;
        }
        return list;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        List<SystemLogRecord> logBundle = mcs.getHazelcastInstance().node.getSystemLogService().getLogBundle();
        Address address = mcs.getHazelcastInstance().node.getThisAddress();
        dos.writeUTF(String.valueOf(address.getHost()) + ":" + address.getPort());
        dos.writeInt(logBundle.size());
        for (SystemLogRecord systemLogRecord : logBundle) {
            systemLogRecord.writeData(dos);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
    }

    @Override
    public void readData(DataInput in) throws IOException {
    }
}

