/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MulticastConfig
implements DataSerializable {
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_MULTICAST_GROUP = "224.2.2.3";
    public static final int DEFAULT_MULTICAST_PORT = 54327;
    public static final int DEFAULT_MULTICAST_TIMEOUT_SECONDS = 2;
    public static final int DEFAULT_MULTICAST_TTL = 32;
    private boolean enabled = true;
    private String multicastGroup = "224.2.2.3";
    private int multicastPort = 54327;
    private int multicastTimeoutSeconds = 2;
    private int multicastTimeToLive = 32;
    private final Set<String> trustedInterfaces = new HashSet<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public MulticastConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public MulticastConfig setMulticastGroup(String multicastGroup) {
        this.multicastGroup = multicastGroup;
        return this;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public MulticastConfig setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
        return this;
    }

    public int getMulticastTimeoutSeconds() {
        return this.multicastTimeoutSeconds;
    }

    public MulticastConfig setMulticastTimeoutSeconds(int multicastTimeoutSeconds) {
        this.multicastTimeoutSeconds = multicastTimeoutSeconds;
        return this;
    }

    public Set<String> getTrustedInterfaces() {
        return this.trustedInterfaces;
    }

    public MulticastConfig setTrustedInterfaces(Set<String> interfaces) {
        this.trustedInterfaces.clear();
        this.trustedInterfaces.addAll(interfaces);
        return this;
    }

    public MulticastConfig addTrustedInterface(String ip) {
        this.trustedInterfaces.add(ip);
        return this;
    }

    public int getMulticastTimeToLive() {
        return this.multicastTimeToLive;
    }

    public MulticastConfig setMulticastTimeToLive(int multicastTimeToLive) {
        this.multicastTimeToLive = multicastTimeToLive;
        return this;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeUTF(this.multicastGroup);
        out.writeInt(this.multicastPort);
        out.writeInt(this.multicastTimeoutSeconds);
        out.writeInt(this.multicastTimeToLive);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.multicastGroup = in.readUTF();
        this.multicastPort = in.readInt();
        this.multicastTimeoutSeconds = in.readInt();
        this.multicastTimeToLive = in.readInt();
    }

    public String toString() {
        return "MulticastConfig [enabled=" + this.enabled + ", multicastGroup=" + this.multicastGroup + ", multicastPort=" + this.multicastPort + ", multicastTimeoutSeconds=" + this.multicastTimeoutSeconds + "]";
    }
}

