/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.TopicManager;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.monitor.LocalTopicStatsImpl;
import com.hazelcast.impl.monitor.TopicOperationsCounter;
import com.hazelcast.monitor.LocalTopicOperationStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.DataSerializable;

public class TopicProxyImpl
extends FactoryAwareNamedProxy
implements TopicProxy,
DataSerializable {
    private transient TopicProxy base = null;
    private TopicManager topicManager = null;
    private ListenerManager listenerManager = null;

    public TopicProxyImpl() {
    }

    TopicProxyImpl(String name, FactoryImpl factory) {
        this.set(name, factory);
        this.base = new TopicProxyReal();
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (TopicProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public void set(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        super.setHazelcastInstance(hazelcastInstance);
        this.topicManager = this.factory.node.topicManager;
        this.listenerManager = this.factory.node.listenerManager;
    }

    @Override
    public String getLongName() {
        return this.base.getLongName();
    }

    @Override
    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "Topic [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicProxyImpl that = (TopicProxyImpl)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public void publish(Object msg) {
        this.ensure();
        this.base.publish(msg);
    }

    public void addMessageListener(MessageListener listener) {
        this.ensure();
        this.base.addMessageListener(listener);
    }

    public void removeMessageListener(MessageListener listener) {
        this.ensure();
        this.base.removeMessageListener(listener);
    }

    @Override
    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    @Override
    public String getName() {
        return this.name.substring("t:".length());
    }

    @Override
    public LocalTopicStats getLocalTopicStats() {
        this.ensure();
        return this.base.getLocalTopicStats();
    }

    @Override
    public TopicOperationsCounter getTopicOperationCounter() {
        return this.base.getTopicOperationCounter();
    }

    class TopicProxyReal
    implements TopicProxy {
        TopicOperationsCounter topicOperationsCounter = new TopicOperationsCounter();

        TopicProxyReal() {
        }

        public void publish(Object msg) {
            Util.checkSerializable(msg);
            this.topicOperationsCounter.incrementPublishes();
            TopicProxyImpl.this.topicManager.doPublish(TopicProxyImpl.this.name, msg);
        }

        public void addMessageListener(MessageListener listener) {
            TopicProxyImpl.this.listenerManager.addListener(TopicProxyImpl.this.name, listener, null, true, this.getInstanceType());
        }

        public void removeMessageListener(MessageListener listener) {
            TopicProxyImpl.this.listenerManager.removeListener(TopicProxyImpl.this.name, listener, null);
        }

        @Override
        public void destroy() {
            TopicProxyImpl.this.factory.destroyInstanceClusterWide(TopicProxyImpl.this.name, null);
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.TOPIC;
        }

        @Override
        public String getName() {
            return TopicProxyImpl.this.getName();
        }

        @Override
        public String getLongName() {
            return TopicProxyImpl.this.name;
        }

        @Override
        public Object getId() {
            return TopicProxyImpl.this.name;
        }

        @Override
        public LocalTopicStats getLocalTopicStats() {
            LocalTopicStatsImpl localTopicStats = TopicProxyImpl.this.topicManager.getTopicInstance(TopicProxyImpl.this.name).getTopicStats();
            localTopicStats.setOperationStats((LocalTopicOperationStats)this.topicOperationsCounter.getPublishedStats());
            return localTopicStats;
        }

        @Override
        public TopicOperationsCounter getTopicOperationCounter() {
            return this.topicOperationsCounter;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

