/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.logging;

import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.callback.logging.LogMessageSource;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.LogTemplates;
import org.javasimon.utils.SimonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingCallback
extends CallbackSkeleton {
    private final LogTemplate<Split> stopwatchLogTemplate;
    private final LogMessageSource<Split> stopwatchLogMessageSource = new LogMessageSource<Split>(){

        @Override
        public String getLogMessage(Split split) {
            return "Split " + SimonUtils.presentNanoTime(split.runningFor()) + " in Stopwatch " + split.getStopwatch();
        }
    };
    private final LogTemplate<String> managerLogTemplate;
    private final LogMessageSource<String> managerLogMessageSource = new LogMessageSource<String>(){

        @Override
        public String getLogMessage(String message) {
            return message;
        }
    };

    public LoggingCallback(LogTemplate<Split> stopwatchLogTemplate, LogTemplate<String> managerLogTemplate) {
        this.stopwatchLogTemplate = stopwatchLogTemplate;
        this.managerLogTemplate = managerLogTemplate;
    }

    public LoggingCallback() {
        this.stopwatchLogTemplate = LogTemplates.toSLF4J(Stopwatch.class.getName(), "debug");
        this.managerLogTemplate = LogTemplates.toSLF4J(SimonManager.class.getName(), "info");
    }

    public LogTemplate<String> getManagerLogTemplate() {
        return this.managerLogTemplate;
    }

    public LogTemplate<Split> getStopwatchLogTemplate() {
        return this.stopwatchLogTemplate;
    }

    protected LogTemplate<Split> getStopwatchLogTemplate(Stopwatch stopwatch) {
        return this.stopwatchLogTemplate;
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        this.getStopwatchLogTemplate(split.getStopwatch()).log(split, this.stopwatchLogMessageSource);
    }

    @Override
    public void onManagerWarning(String warning, Exception cause) {
        this.managerLogTemplate.log(warning, this.managerLogMessageSource);
    }
}

