/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.lastsplits;

import org.javasimon.Split;
import org.javasimon.callback.lastsplits.CircularList;
import org.javasimon.callback.logging.LogMessageSource;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.LogTemplates;
import org.javasimon.utils.SimonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastSplits
implements LogMessageSource<Split> {
    private final CircularList<Split> splits;
    private LogTemplate<Split> logTemplate = LogTemplates.disabled();

    public LastSplits(int capacity) {
        this.splits = new CircularList(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Split split) {
        CircularList<Split> circularList = this.splits;
        synchronized (circularList) {
            this.splits.add(split);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularList<Split> circularList = this.splits;
        synchronized (circularList) {
            this.splits.clear();
        }
    }

    public LogTemplate<Split> getLogTemplate() {
        return this.logTemplate;
    }

    public void setLogTemplate(LogTemplate<Split> logTemplate) {
        this.logTemplate = logTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        CircularList<Split> circularList = this.splits;
        synchronized (circularList) {
            return this.splits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T processFunction(SplitFunction<T> function) {
        CircularList<Split> circularList = this.splits;
        synchronized (circularList) {
            if (this.splits.isEmpty()) {
                return null;
            }
            for (Split split : this.splits) {
                function.evaluate(split);
            }
            return function.result();
        }
    }

    public Double getMean() {
        return this.processFunction(new AbstractSplitFunction<Double>(Double.valueOf(0.0)){

            @Override
            public void evaluate(long runningFor) {
                this.result = (Double)this.result + (double)runningFor;
            }

            @Override
            public Double result() {
                return (Double)this.result / (double)LastSplits.this.splits.size();
            }
        });
    }

    public Long getMin() {
        return this.processFunction(new AbstractSplitFunction<Long>(Long.valueOf(Long.MAX_VALUE)){

            @Override
            public void evaluate(long runningFor) {
                if (runningFor < (Long)this.result) {
                    this.result = runningFor;
                }
            }
        });
    }

    public Long getMax() {
        return this.processFunction(new AbstractSplitFunction<Long>(Long.valueOf(Long.MIN_VALUE)){

            @Override
            public void evaluate(long runningFor) {
                if (runningFor > (Long)this.result) {
                    this.result = runningFor;
                }
            }
        });
    }

    public Double getTrend() {
        return this.getTrend(1000L);
    }

    public Double getTrend(final long timeDeltaThreshold) {
        return this.processFunction(new SplitFunction<Double>(){
            Split lastSplit;
            long result;
            int count;

            @Override
            public void evaluate(Split split) {
                if (this.lastSplit == null) {
                    this.lastSplit = split;
                } else {
                    long timeDelta = split.getStart() - this.lastSplit.getStart();
                    if (timeDelta > timeDeltaThreshold) {
                        long durationDelta = split.runningFor() - this.lastSplit.runningFor();
                        this.result += durationDelta;
                        ++this.count;
                        this.lastSplit = split;
                    }
                }
            }

            @Override
            public Double result() {
                return this.count > 0 ? Double.valueOf((double)this.result / (double)this.count) : null;
            }
        });
    }

    private String getSplitsAsString() {
        return this.processFunction(new AbstractSplitFunction<StringBuilder>(new StringBuilder()){
            private boolean first;
            {
                this.first = true;
            }

            @Override
            public void evaluate(long runningFor) {
                if (this.first) {
                    this.first = false;
                } else {
                    ((StringBuilder)this.result).append(',');
                }
                ((StringBuilder)this.result).append(SimonUtils.presentNanoTime(runningFor));
            }
        }).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int count;
        long min = 0L;
        long mean = 0L;
        long max = 0L;
        long trend = 0L;
        String values = null;
        CircularList<Split> circularList = this.splits;
        synchronized (circularList) {
            count = this.getCount();
            if (count > 0) {
                min = this.getMin();
                mean = this.getMean().longValue();
                max = this.getMax();
                values = this.getSplitsAsString();
                if (count > 1) {
                    trend = this.getTrend().longValue();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder("LastSplits[size=");
        stringBuilder.append(count);
        if (count > 0) {
            stringBuilder.append(",values=[").append(values).append("]").append(",min=").append(SimonUtils.presentNanoTime(min)).append(",mean=").append(SimonUtils.presentNanoTime(mean)).append(",max=").append(SimonUtils.presentNanoTime(max));
            if (count > 1) {
                stringBuilder.append(",trend=").append(SimonUtils.presentNanoTime(trend));
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public String getLogMessage(Split lastSplit) {
        return lastSplit.getStopwatch().getName() + " " + this.toString();
    }

    public void log(Split lastSplit) {
        this.logTemplate.log(lastSplit, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractSplitFunction<T>
    implements SplitFunction<T> {
        protected T result;

        public AbstractSplitFunction(T result) {
            this.result = result;
        }

        public abstract void evaluate(long var1);

        @Override
        public final void evaluate(Split split) {
            this.evaluate(split.runningFor());
        }

        @Override
        public T result() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SplitFunction<T> {
        public void evaluate(Split var1);

        public T result();
    }
}

