/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackBoxContainer;
import com.coremedia.iso.boxes.TrackMetaData;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieBox
extends AbstractContainerBox
implements TrackBoxContainer<TrackBox> {
    public static final String TYPE = "moov";

    public MovieBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    public int getTrackCount() {
        return this.getBoxes(TrackBox.class).size();
    }

    @Override
    public long[] getTrackNumbers() {
        List<TrackBox> trackBoxes = this.getBoxes(TrackBox.class);
        long[] trackNumbers = new long[trackBoxes.size()];
        for (int trackCounter = 0; trackCounter < trackBoxes.size(); ++trackCounter) {
            AbstractBox trackBoxe = trackBoxes.get(trackCounter);
            TrackBox trackBox = (TrackBox)trackBoxe;
            trackNumbers[trackCounter] = trackBox.getTrackHeaderBox().getTrackId();
        }
        return trackNumbers;
    }

    @Override
    public TrackMetaData<TrackBox> getTrackMetaData(long trackId) {
        List<TrackBox> trackBoxes = this.getBoxes(TrackBox.class);
        for (TrackBox trackBox : trackBoxes) {
            if (trackBox.getTrackHeaderBox().getTrackId() != trackId) continue;
            return new TrackMetaData<TrackBox>(trackId, trackBox);
        }
        throw new RuntimeException("TrackId " + trackId + " not contained in " + this);
    }

    public MovieHeaderBox getMovieHeaderBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof MovieHeaderBox)) continue;
            return (MovieHeaderBox)box;
        }
        return null;
    }
}

