/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class RecordingYearBox
extends AbstractFullBox {
    public static final String TYPE = "yrrc";
    int recordingYear;

    public RecordingYearBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 2L;
    }

    public int getRecordingYear() {
        return this.recordingYear;
    }

    public void setRecordingYear(int recordingYear) {
        this.recordingYear = recordingYear;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.recordingYear = in.readUInt16();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt16(this.recordingYear);
    }
}

