/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoQueue;
import org.xsocket.connection.IoSSLHandler;
import org.xsocket.connection.IoSSLProcessor;

final class IoActivateableSSLHandler
extends IoChainableHandler
implements IoSSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private AtomicReference<Mode> modeRef = new AtomicReference<Mode>(Mode.OFF);
    private IoQueue inNetDataQueue = new IoQueue();
    private IoQueue outNetDataQueue = new IoQueue();
    private IoQueue outAppDataQueue = new IoQueue();
    private final IoSSLHandler.PendingWriteMap pendingWriteMap = new IoSSLHandler.PendingWriteMap();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private final IoSSLProcessor sslProcessor;

    IoActivateableSSLHandler(IoChainableHandler successor, SSLContext sslContext, boolean isClientMode, AbstractMemoryManager memoryManager) throws IOException {
        super(successor);
        this.sslProcessor = new IoSSLProcessor(sslContext, isClientMode, memoryManager, this);
    }

    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
    }

    public boolean isSecure() {
        return this.modeRef.get() == Mode.SSL;
    }

    public boolean reset() {
        this.inNetDataQueue.drain();
        this.outNetDataQueue.drain();
        this.outAppDataQueue.drain();
        this.pendingWriteMap.clear();
        return super.reset();
    }

    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.hardFlush();
        }
        this.getSuccessor().close(immediate);
    }

    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    public boolean hasDataToSend() {
        return !this.outAppDataQueue.isEmpty() || super.hasDataToSend();
    }

    public void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.outAppDataQueue.append(buffers);
    }

    public void hardFlush() throws IOException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.modeRef.get() == Mode.SSL) {
            IoQueue ioQueue = this.outAppDataQueue;
            synchronized (ioQueue) {
                if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.addOutAppData(this.outAppDataQueue.drain());
                }
            }
            this.sslProcessor.encrypt();
        } else if (this.modeRef.get() == Mode.OFF || this.modeRef.get() == Mode.PLAIN_OUTGOING_SSL_INCOMING) {
            IoQueue ioQueue = this.outAppDataQueue;
            synchronized (ioQueue) {
                if (!this.outAppDataQueue.isEmpty()) {
                    ByteBuffer[] data = this.outAppDataQueue.drain();
                    this.getSuccessor().write(data);
                }
            }
            this.getSuccessor().flush();
        }
    }

    public boolean preStartSecuredMode() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] switch to prestart secured mode (interpret incomming as SSL, writing plain outgoing plain)");
        }
        if (this.modeRef.get() == Mode.OFF) {
            this.modeRef.set(Mode.PLAIN_OUTGOING_SSL_INCOMING);
            return true;
        }
        LOG.warning("connection is already in ssl mode (mode=" + (Object)((Object)this.modeRef.get()) + "). Ignore (pre)startSecured Mode");
        return false;
    }

    public void startSecuredMode(ByteBuffer[] data) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] switch to secured mode (handle incomming and outgoing as SSL)");
        }
        if (this.modeRef.get() != Mode.PLAIN_OUTGOING_SSL_INCOMING) {
            LOG.warning("connection is not in non_receiving mode (mode=" + (Object)((Object)this.modeRef.get()) + ")");
            return;
        }
        this.modeRef.set(Mode.PRE_SSL2);
        if (data != null && data.length > 0) {
            this.inNetDataQueue.addFirst(data);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] start ssl processor");
        }
        this.sslProcessor.start();
        this.modeRef.set(Mode.SSL);
        this.hardFlush();
        this.readIncomingEncryptedData(this.inNetDataQueue.drain());
    }

    public void onHandshakeFinished() throws IOException {
        this.hardFlush();
    }

    private void readIncomingEncryptedData(ByteBuffer[] inNetDataList) throws ClosedChannelException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.decrypt(inNetDataList);
        }
    }

    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    public void onDataDecrypted(ByteBuffer decryptedBuffer) {
        if (decryptedBuffer == null || !decryptedBuffer.hasRemaining()) {
            return;
        }
        this.getPreviousCallback().onData(new ByteBuffer[]{decryptedBuffer}, decryptedBuffer.remaining());
    }

    public void onPostDataDecrypted() {
        this.getPreviousCallback().onPostData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataEncrypted(ByteBuffer plainData, ByteBuffer encryptedData) throws IOException {
        if (encryptedData.hasRemaining()) {
            this.pendingWriteMap.add(plainData, encryptedData);
        }
        IoQueue ioQueue = this.outNetDataQueue;
        synchronized (ioQueue) {
            this.outNetDataQueue.append(encryptedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostDataEncrypted() throws IOException {
        IoQueue ioQueue = this.outNetDataQueue;
        synchronized (ioQueue) {
            ByteBuffer[] data = this.outNetDataQueue.drain();
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : data) {
                    size += buffer.remaining();
                }
                LOG.fine("sending out app data (" + size + ")");
            }
            this.getSuccessor().write(data);
        }
        this.getSuccessor().flush();
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        public void onData(ByteBuffer[] data, int size) {
            block5: {
                try {
                    Mode md = (Mode)((Object)IoActivateableSSLHandler.this.modeRef.get());
                    if (md == Mode.OFF) {
                        IoActivateableSSLHandler.this.getPreviousCallback().onData(data, size);
                        IoActivateableSSLHandler.this.getPreviousCallback().onPostData();
                        break block5;
                    }
                    if (md == Mode.SSL) {
                        IoActivateableSSLHandler.this.readIncomingEncryptedData(data);
                        break block5;
                    }
                    assert (md == Mode.PLAIN_OUTGOING_SSL_INCOMING || md == Mode.PRE_SSL2);
                    IoActivateableSSLHandler.this.inNetDataQueue.append(data);
                    return;
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + IoActivateableSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public void onPostData() {
        }

        public void onConnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnect();
        }

        public void onConnectException(IOException ioe) {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectException(ioe);
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            IoActivateableSSLHandler.this.getPreviousCallback().onWriteException(ioException, data);
        }

        public void onWritten(ByteBuffer data) {
            ByteBuffer plainData = IoActivateableSSLHandler.this.pendingWriteMap.getPlainIfWritten(data);
            if (plainData != null) {
                IoActivateableSSLHandler.this.getPreviousCallback().onWritten(plainData);
            } else {
                IoActivateableSSLHandler.this.getPreviousCallback().onWritten(data);
            }
        }

        public void onDisconnect() {
            IoActivateableSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        public void onConnectionAbnormalTerminated() {
            IoActivateableSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        OFF,
        PLAIN_OUTGOING_SSL_INCOMING,
        PRE_SSL2,
        SSL;

    }
}

