/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v22Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String genre;
    private String trackNumber;
    private List<ID3Tags.ID3Comment> comments = new ArrayList<ID3Tags.ID3Comment>();

    public ID3v22Handler(ID3v2Frame frame) throws IOException, SAXException, TikaException {
        RawV22TagIterator tags = new RawV22TagIterator(frame);
        while (tags.hasNext()) {
            ID3v2Frame.RawTag tag = tags.next();
            if (tag.name.equals("TT2")) {
                this.title = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TP1")) {
                this.artist = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TAL")) {
                this.album = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TYE")) {
                this.year = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TCM")) {
                this.composer = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("COM")) {
                this.comments.add(this.getComment(tag.data, 0, tag.data.length));
                continue;
            }
            if (tag.name.equals("TRK")) {
                this.trackNumber = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (!tag.name.equals("TCO")) continue;
            this.genre = ID3v22Handler.extractGenre(this.getTagString(tag.data, 0, tag.data.length));
        }
    }

    private String getTagString(byte[] data, int offset, int length) {
        return ID3v2Frame.getTagString(data, offset, length);
    }

    private ID3Tags.ID3Comment getComment(byte[] data, int offset, int length) {
        return ID3v2Frame.getComment(data, offset, length);
    }

    protected static String extractGenre(String rawGenre) {
        int open = rawGenre.indexOf("(");
        int close = rawGenre.indexOf(")");
        if (open == -1 && close == -1) {
            return rawGenre;
        }
        if (open < close) {
            String genreStr = rawGenre.substring(0, open).trim();
            try {
                int genreID = Integer.parseInt(rawGenre.substring(open + 1, close));
                return ID3Tags.GENRES[genreID];
            }
            catch (ArrayIndexOutOfBoundsException invalidNum) {
                return genreStr;
            }
            catch (NumberFormatException notANum) {
                return genreStr;
            }
        }
        return null;
    }

    @Override
    public boolean getTagsPresent() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public String getComposer() {
        return this.composer;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public String getTrackNumber() {
        return this.trackNumber;
    }

    private class RawV22TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV22TagIterator(ID3v2Frame frame) {
            ID3v2Frame iD3v2Frame = frame;
            iD3v2Frame.getClass();
            super(iD3v2Frame, 3, 3, 1, 0);
        }
    }
}

