/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.ListProxy;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ListProxyImpl
extends AbstractList
implements ListProxy,
DataSerializable {
    String name;
    String queueName;
    String mapName;
    FactoryImpl factory;

    public ListProxyImpl() {
    }

    public ListProxyImpl(String name, FactoryImpl factory) {
        this.factory = factory;
        this.setName(name);
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.LIST;
    }

    @Override
    public void destroy() {
        this.factory.destroyInstanceClusterWide(this.name, null);
        this.factory.destroyInstanceClusterWide(this.queueName, null);
        this.factory.destroyInstanceClusterWide(this.mapName, null);
    }

    @Override
    public Object getId() {
        return this.queueName;
    }

    @Override
    public int size() {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.size(this.queueName);
    }

    @Override
    public boolean contains(Object o) {
        this.factory.initialChecks();
        Set<Long> keys = this.factory.node.blockingQueueManager.getValueKeys(this.queueName, IOUtil.toData(o));
        return keys != null && keys.size() > 0;
    }

    @Override
    public Iterator iterator() {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.iterate(this.queueName);
    }

    @Override
    public boolean add(Object o) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.add(this.queueName, o, Integer.MAX_VALUE);
    }

    @Override
    public boolean remove(Object o) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.remove(this.queueName, o);
    }

    @Override
    public boolean addAll(Collection c) {
        for (Object o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public Object get(int index) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.getItemByIndex(this.queueName, index);
    }

    @Override
    public Object set(int index, Object element) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.set(this.queueName, element, index);
    }

    @Override
    public void add(int index, Object element) {
        this.factory.initialChecks();
        try {
            this.factory.node.blockingQueueManager.offer(this.queueName, element, index, 0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Object remove(int index) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.remove(this.queueName, index);
    }

    @Override
    public int indexOf(Object o) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.getIndexOf(this.queueName, o, true);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.factory.initialChecks();
        return this.factory.node.blockingQueueManager.getIndexOf(this.queueName, o, false);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.setName(this.name);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }

    @Override
    public String getName() {
        return this.name.substring("l:".length());
    }

    private void setName(String n) {
        this.name = n;
        this.queueName = "q:" + this.name;
        this.mapName = "c:" + this.queueName;
    }

    @Override
    public void addItemListener(ItemListener itemListener, boolean includeValue) {
        this.factory.initialChecks();
        this.factory.node.blockingQueueManager.addItemListener(this.queueName, itemListener, includeValue);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.factory.initialChecks();
        this.factory.node.blockingQueueManager.removeItemListener(this.queueName, itemListener);
    }

    @Override
    public String toString() {
        return "List [" + this.getName() + "] ";
    }
}

