/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.opendocument;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import net.sf.jooreports.opendocument.OpenDocumentIO;
import net.sf.jooreports.opendocument.OpenDocumentNamespaces;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;

public class SettingsSubDocument {
    private Document document;

    public SettingsSubDocument(InputStream inputStream) throws IOException {
        Builder builder = new Builder();
        try {
            this.document = builder.build(inputStream);
        }
        catch (ParsingException parsingException) {
            throw new IllegalArgumentException("inputStream contains invalid XML: " + parsingException.getMessage());
        }
    }

    public void changeSettings(Map openDocumentSettings) {
        Iterator settings = openDocumentSettings.entrySet().iterator();
        while (settings.hasNext()) {
            Map.Entry setting = settings.next();
            Nodes configNodes = this.document.query("//config:config-item[@config:name='" + setting.getKey() + "']", OpenDocumentNamespaces.XPATH_CONTEXT);
            for (int nodeIndex = 0; nodeIndex < configNodes.size(); ++nodeIndex) {
                Element configElement = (Element)configNodes.get(nodeIndex);
                configElement.removeChildren();
                if (setting.getValue() == null) continue;
                configElement.appendChild((Node)new Text((String)setting.getValue()));
            }
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        Serializer serializer = new Serializer(outputStream, OpenDocumentIO.UTF_8.name());
        serializer.setIndent(1);
        serializer.write(this.document);
    }
}

