/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

ox.gui.initController = function () {

    // set to true for debugging module/folder switch issues
    if (false) {
        ox.UIController.dispatcher.bind("modulechange", function (e) {
            console.warn("modulechange", e);
        });
        ox.UIController.dispatcher.bind("folderchange", function (e) {
            console.warn("folderchange", e);
        });
    }
    
    // change view on module change
    ox.UIController.dispatcher.bind("modulechange", function (e) {
        
        var module = e.module;
        var folder = e.folder;
        var view;
        
        // search field (clear first; mail & contacts set fields afterwards)
        ox.widgets.searchField.active().searchMenu.setFields();
        
        // sidepanel & search bar
        if (module === "portal") {
            ox.widgets.miniCalendar.show();
            ox.widgets.searchField.top.disable();
            view = ox.UIController.showExpertTree ? "foldertree" : "portal";
            ox.widgets.sidepanelViewControl.showView("ox-sidepanel-" + view);
            ox.widgets.sidepanel.toggle(!ox.UIController.showExpertTree);
        } else if (module === "configuration") {
            ox.widgets.miniCalendar.hide();
            ox.widgets.searchField.top.disable();
            ox.widgets.sidepanel.toggle(false);
        } else {
            // collapsed by user?
            if (ox.widgets.sidepanel.userToggle === true) {
                ox.widgets.sidepanel.toggle(true);
            } else {
                ox.widgets.sidepanel.toggle(false);
            }
            ox.widgets.miniCalendar.show();
            // search field
            ox.widgets.searchField.top.enable();
        }
        
        // toggle calendar always when module calendar
        if (module === "calendar") {
            ox.widgets.miniCalendar.toggle(true);
        } else {
            ox.widgets.miniCalendar.refreshState();
        }
        
        var module = ox.UIController.getModule();
        var folder = ox.UIController.getFolder();
        
        // SPAM folder?
        if (module === "mail" && folder === ox.api.folder.isStdFolder("spam", folder)) {
            // SPAM is always in list view
            changeView(ox.api.config.get("gui.mail.view_spam", "mail/list/unthreaded"), "newfolder");
        }
        else if (e.view !== undefined) {
            // change to specific view
            changeView(e.view, module === "configuration" ? "samefolder" : "newfolder");
        }
        else if (menulastviews[module] !== undefined) {
            // change to module
            changeView(menulastviews[module], module === "configuration" ? "samefolder" : "newfolder");
        }
        else {
            alert("Unknown Module: " + module);
        }
        
        // jump to or from configuration? (doesn't trigger folder change since config has no default folder)
        if (e.change === "module" || e.change == "both") {
            if (module === "configuration") {
                // jump in
                ox.widgets.sidepanelViewControl.showView("ox-sidepanel-configuration");
                ox.widgets.configTree.selection.click(menulastviews[module], false, false, true);
            } else if (e.previous.module === "configuration") {
                // jump away
                ox.widgets.sidepanelViewControl.showView("ox-sidepanel-" 
                        + (ox.UIController.showExpertTree ? "foldertree" : module));
            }
        }
        
        // resize toolbar
        ox.ToolBarController.initialResize();
    });
    
    // change view on folder change
    ox.UIController.dispatcher.bind("folderchange", function (e) {
        
        var module = ox.UIController.getModule();
        var folder = ox.UIController.getFolder();
        
        if (e.change === "folder") {
            
            // SPAM folder?
            if (module === "mail" && ox.api.folder.isStdFolder("spam", folder)) {
                // SPAM is always in list view
                changeView(ox.api.config.get("gui.mail.view_spam", "mail/list/unthreaded"), "newfolder");
            }
            else if (e.view !== undefined) {
                // change to specific view
                changeView(e.view, module === "configuration" ? "samefolder" : "newfolder");
            }
            else if (menulastviews[module] !== undefined) {
                // change to module
                changeView(menulastviews[module], e.change === "folder" || e.change === "both" ? "newfolder" : "samefolder");
            }
            else {
                alert("Unknown Module: " + module);
            }
        }
        
        // update sidepanel
        var id = ox.UIController.showExpertTree && module !== "configuration" ? "foldertree" : module;
        var viewControl = ox.widgets.sidepanelViewControl;
        viewControl.showView("ox-sidepanel-" + id);
        // update proper widget
        var views = ox.widgets.sidepanelViews;
        var map = {
            "mail": views.mailTree,
            "calendar": views.calendar,
            "contacts": views.contacts,
            "tasks": views.tasks,
            "infostore": views.infostoreTree,
            "foldertree": views.folderTree
        };
        if (map[id] !== undefined) {
            if (map[id].expandToFolder) {
                // trees
                map[id].expandToFolder(folder);
            } else {
                // flat views
                map[id].selection.clickQuiet(folder);
            }
        }
    });
};
