/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ComputedElement
extends ElementCreator {
    private Expression elementName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private boolean allowNameAsQName;
    private ItemType itemType;

    public ComputedElement(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, SchemaType schemaType, int n, boolean bl, boolean bl2) {
        this.elementName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceResolver;
        this.setSchemaType(schemaType);
        this.validation = n;
        this.inheritNamespaces = bl;
        this.allowNameAsQName = bl2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.elementName = this.elementName.simplify(staticContext);
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify(staticContext);
        }
        Configuration configuration = staticContext.getConfiguration();
        this.setLazyConstruction(configuration.isLazyConstructionMode());
        if (this.getSchemaType() != null) {
            this.itemType = new ContentTypeTest(1, this.getSchemaType(), configuration);
            this.getSchemaType().analyzeContentExpression(this.content, 1, staticContext);
        } else {
            this.itemType = this.validation == 4 || !configuration.isSchemaAware(52) ? new ContentTypeTest(1, BuiltInSchemaFactory.getSchemaType(641), configuration) : NodeKindTest.ELEMENT;
        }
        return super.simplify(staticContext);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.elementName = this.elementName.typeCheck(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(4, "element/name", 0, null);
        roleLocator.setSourceLocator(this);
        this.elementName = this.allowNameAsQName ? TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_ATOMIC, false, roleLocator, staticContext) : TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        if (this.namespace != null) {
            this.namespace = this.namespace.typeCheck(staticContext, itemType);
            roleLocator = new RoleLocator(4, "attribute/namespace", 0, null);
            roleLocator.setSourceLocator(this);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        }
        return super.typeCheck(staticContext, itemType);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType == null) {
            return super.getItemType(typeHierarchy);
        }
        return this.itemType;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        arrayList.add(this.content);
        arrayList.add(this.elementName);
        if (this.namespace != null) {
            arrayList.add(this.namespace);
        }
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.elementName = this.doPromotion(this.elementName, promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this.namespace, promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (schemaType instanceof SimpleType) {
            StaticError staticError = new StaticError("Elements are not permitted here: the containing element has the simple type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (((ComplexType)schemaType).isSimpleContent()) {
            StaticError staticError = new StaticError("Elements are not permitted here: the containing element has a complex type with simple content");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
    }

    public int getNameCode(XPathContext xPathContext) throws XPathException, XPathException {
        String string;
        String string2;
        String string3;
        Object object;
        Controller controller = xPathContext.getController();
        NamePool namePool = controller.getNamePool();
        AtomicValue atomicValue = (AtomicValue)this.elementName.evaluateItem(xPathContext);
        if (atomicValue == null) {
            DynamicError dynamicError = new DynamicError("Invalid element name (empty sequence)", this);
            dynamicError.setErrorCode(this.isXSLT() ? "XTDE0820" : "XPTY0004");
            dynamicError.setXPathContext(xPathContext);
            throw ComputedElement.dynamicError(this, dynamicError, xPathContext);
        }
        if ((atomicValue = atomicValue.getPrimitiveValue()) instanceof StringValue) {
            object = atomicValue.getStringValueCS();
            try {
                String[] stringArray = controller.getConfiguration().getNameChecker().getQNameParts((CharSequence)object);
                string3 = stringArray[0];
                string2 = stringArray[1];
            }
            catch (QNameException qNameException) {
                DynamicError dynamicError = new DynamicError("Invalid element name. " + qNameException.getMessage(), this);
                dynamicError.setErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074");
                dynamicError.setXPathContext(xPathContext);
                throw ComputedElement.dynamicError(this, dynamicError, xPathContext);
            }
        } else if (atomicValue instanceof QNameValue && this.allowNameAsQName) {
            string2 = ((QNameValue)atomicValue).getLocalName();
            string = ((QNameValue)atomicValue).getNamespaceURI();
            this.namespace = new StringValue(string);
            string3 = ((QNameValue)atomicValue).getPrefix();
        } else {
            DynamicError dynamicError = new DynamicError("Computed element name has incorrect type");
            dynamicError.setErrorCode(this.isXSLT() ? "XTDE0820" : "XPTY0004");
            dynamicError.setIsTypeError(true);
            dynamicError.setXPathContext(xPathContext);
            throw ComputedElement.dynamicError(this, dynamicError, xPathContext);
        }
        if (this.namespace == null) {
            string = this.nsContext.getURIForPrefix(string3, true);
            if (string == null) {
                object = new DynamicError("Undeclared prefix in element name: " + string3, this);
                ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0830" : "XQDY0074");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw ComputedElement.dynamicError(this, (XPathException)object, xPathContext);
            }
        } else {
            string = this.namespace.evaluateAsString(xPathContext);
            if (string.equals("")) {
                string3 = "";
            }
            if (string3.equals("xmlns")) {
                string3 = "x-xmlns";
            }
        }
        return namePool.allocate(string3, string, string2);
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
    }

    public int getInstructionNameCode() {
        return 143;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "element ");
        printStream.println(ExpressionTool.indent(n + 1) + "name");
        this.elementName.display(n + 2, printStream, configuration);
        printStream.println(ExpressionTool.indent(n + 1) + "content");
        this.content.display(n + 1, printStream, configuration);
    }
}

