
Name:           open-xchange-gui-l10n
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
BuildRequires:  ant-nodeps
BuildRequires:  ant-apache-regexp
BuildRequires:  ant-trax
BuildRequires:  gettext-devel
BuildRequires:  unzip
BuildRequires:  java-devel >= 1.6.0
Version:	6.22.5
%define		ox_release 5
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          I18N
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
URL:            http://www.open-xchange.com/
Source:         %{name}_%{version}.orig.tar.bz2
Summary:        Package containing i18n helper functions
Provides:       open-xchange-lang = %{version}
Obsoletes:      open-xchange-lang <= %{version}

%description
Package containing i18n helper functions

Authors:
--------
    Open-Xchange

%package -n open-xchange-gui-l10n-de-de
Group:          I18N
Summary:    Package containing translation for de_DE
Requires:   open-xchange-gui-l10n

%description -n open-xchange-gui-l10n-de-de
Package containing translation for de_DE

Authors:
--------
    Open-Xchange

%package -n open-xchange-gui-l10n-en-gb
Group:          I18N
Summary:    Package containing translation for en_GB
Requires:   open-xchange-gui-l10n

%description -n open-xchange-gui-l10n-en-gb
Package containing translation for en_GB

Authors:
--------
    Open-Xchange

%package -n open-xchange-gui-l10n-en-us
Group:          I18N
Summary:    Package containing translation for en_US
Requires:     open-xchange-gui-l10n

%description -n open-xchange-gui-l10n-en-us
Package containing translation for en_US

Authors:
--------
    Open-Xchange

%package -n open-xchange-gui-l10n-fr-fr
Group:          I18N
Summary:    Package containing translation for fr_FR
Requires:   open-xchange-gui-l10n

%description -n open-xchange-gui-l10n-fr-fr
Package containing translation for fr_FR

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-l10n-ja-jp
Group:          I18N
Summary:	Package containing translation for ja_JP
Requires:	open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-ja-jp = %{version}
Obsoletes:	open-xchange-gui-lang-ja-jp <= %{version}

%description -n open-xchange-gui-l10n-ja-jp
Package containing translation for ja_JP

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-l10n-pl-pl
Group:          I18N
Summary:	Package containing translation for pl_PL
Requires:	open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-pl-pl = %{version}
Obsoletes:	open-xchange-gui-lang-pl-pl <= %{version}

%description -n open-xchange-gui-l10n-pl-pl
Package containing translation for pl_PL

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-l10n-es-es
Group:          I18N
Summary:	Package containing translation for es_ES
Requires:	open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-es-es = %{version}
Obsoletes:	open-xchange-gui-lang-es-es <= %{version}

%description -n open-xchange-gui-l10n-es-es
Package containing translation for es_ES

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-l10n-nl-nl
Group:          I18N
Summary:	Package containing translation for nl_NL
Requires:	open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-nl-nl = %{version}
Obsoletes:	open-xchange-gui-lang-nl-nl <= %{version}

%description -n open-xchange-gui-l10n-nl-nl
Package containing translation for nl_NL

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-it-it
Group:          I18N
Summary:        Package containing translation for it_IT
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-it-it = %{version}
Obsoletes:	open-xchange-gui-lang-it-it <= %{version}

%description -n open-xchange-gui-l10n-it-it
Package containing translation for it_IT

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-zh-cn
Group:          I18N
Summary:        Package containing translation for zh_CN
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-zh-cn = %{version}
Obsoletes:	open-xchange-gui-lang-zh-cn <= %{version}

%description -n open-xchange-gui-l10n-zh-cn
Package containing translation for zh_CN

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-zh-tw
Group:          I18N
Summary:        Package containing translation for zh_TW
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-zh-tw = %{version}
Obsoletes:	open-xchange-gui-lang-zh-tw <= %{version}

%description -n open-xchange-gui-l10n-zh-tw
Package containing translation for zh_TW

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-lv-lv
Group:          I18N
Summary:        Package containing translation for lv_LV
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-lv-lv = %{version}
Obsoletes:	open-xchange-gui-lang-lv-lv <= %{version}

%description -n open-xchange-gui-l10n-lv-lv
Package containing translation for lv_LV

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-hu-hu
Group:          I18N
Summary:        Package containing translation for hu_HU
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-hu-hu = %{version}
Obsoletes:	open-xchange-gui-lang-hu-hu <= %{version}

%description -n open-xchange-gui-l10n-hu-hu
Package containing translation for hu_HU

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-cs-cz
Group:          I18N
Summary:        Package containing translation for cs_CZ
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-cs-cz = %{version}
Obsoletes:	open-xchange-gui-lang-cs-cz <= %{version}

%description -n open-xchange-gui-l10n-cs-cz
Package containing translation for cs_CZ

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-sk-sk
Group:          I18N
Summary:        Package containing translation for sk_SK
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-sk-sk = %{version}
Obsoletes:	open-xchange-gui-lang-sk-sk <= %{version}

%description -n open-xchange-gui-l10n-sk-sk
Package containing translation for sk_SK

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-fr-ca
Group:          I18N
Summary:        Package containing translation for fr_CA
Requires:       open-xchange-gui-l10n
Requires:       open-xchange-gui-l10n-fr-fr
Provides:       open-xchange-gui-lang-fr-ca = %{version}
Obsoletes:      open-xchange-gui-lang-fr-ca <= %{version}

%description -n open-xchange-gui-l10n-fr-ca
Package containing translation for fr_CA

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-ro-ro
Group:          I18N
Summary:        Package containing translation for ro_RO
Requires:       open-xchange-gui-l10n
Provides:	open-xchange-gui-lang-ro-ro = %{version}
Obsoletes:	open-xchange-gui-lang-ro-ro <= %{version}

%description -n open-xchange-gui-l10n-ro-ro
Package containing translation for ro_RO

Authors:
--------
    Open-Xchange

%package -n open-xchange-gui-l10n-de-ch
Group:          I18N
Summary:    Package containing translation for de_CH
Requires:   open-xchange-gui-l10n
Requires:   open-xchange-gui-l10n-de-de

%description -n open-xchange-gui-l10n-de-ch
Package containing translation for de_CH

Authors:
--------
    Open-Xchange

%package -n open-xchange-gui-l10n-es-mx
Group:          I18N
Summary:    Package containing translation for es_MX
Requires:   open-xchange-gui-l10n
Requires:   open-xchange-gui-l10n-es-mx

%description -n open-xchange-gui-l10n-es-mx
Package containing translation for es_MX

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-ca-es
Group:          I18N
Summary:        Package containing translation for ca_ES
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-ca-es = %{version}
Obsoletes:  open-xchange-gui-lang-community-ca-es <= %{version}

%description -n open-xchange-gui-l10n-ca-es
Package containing translation for ca_ES.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-da-dk
Group:          I18N
Summary:        Package containing translation for da_DK
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-da-dk = %{version}
Obsoletes:  open-xchange-gui-lang-community-da-dk <= %{version}

%description -n open-xchange-gui-l10n-da-dk
Package containing translation for da_DK.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-el-gr
Group:          I18N
Summary:        Package containing translation for el_GR
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-el-gr = %{version}
Obsoletes:  open-xchange-gui-lang-community-el-gr <= %{version}

%description -n open-xchange-gui-l10n-el-gr
Package containing translation for el_GR.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-eu-es
Group:          I18N
Summary:        Package containing translation for eu_ES
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-eu-es = %{version}
Obsoletes:  open-xchange-gui-lang-community-eu-es <= %{version}

%description -n open-xchange-gui-l10n-eu-es
Package containing translation for eu_ES.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-gl-es
Group:          I18N
Summary:        Package containing translation for gl_ES
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-gl-es = %{version}
Obsoletes:  open-xchange-gui-lang-community-gl-es <= %{version}

%description -n open-xchange-gui-l10n-gl-es
Package containing translation for gl_ES.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-he-he
Group:          I18N
Summary:        Package containing translation for he_HE
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-he-he = %{version}
Obsoletes:  open-xchange-gui-lang-community-he-he <= %{version}

%description -n open-xchange-gui-l10n-he-he
Package containing translation for he_HE.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-ko-ko
Group:          I18N
Summary:        Package containing translation for ko_KO
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-ko-ko = %{version}
Obsoletes:  open-xchange-gui-lang-community-ko-ko <= %{version}

%description -n open-xchange-gui-l10n-ko-ko
Package containing translation for ko_KO.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

#%package -n     open-xchange-gui-l10n-no-nb
#Group:          I18N
#Summary:        Package containing translation for no_NB
#Requires:       open-xchange-gui-l10n
#Provides:   open-xchange-gui-lang-community-no-nb = %{version}
#Obsoletes:  open-xchange-gui-lang-community-no-nb <= %{version}
#
#%description -n open-xchange-gui-l10n-no-nb
#Package containing translation for no_NB.
#This localization package are driven by the community.
#
#Authors:
#--------
#    Open-Xchange

%package -n     open-xchange-gui-l10n-pt-br
Group:          I18N
Summary:        Package containing translation for pt_BR
Requires:       open-xchange-gui-l10n
Requires:       open-xchange-gui-l10n-pt-pt
Provides:   open-xchange-gui-lang-community-pt-br = %{version}
Obsoletes:  open-xchange-gui-lang-community-pt-br <= %{version}

%description -n open-xchange-gui-l10n-pt-br
Package containing translation for pt_BR.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-pt-pt
Group:          I18N
Summary:        Package containing translation for pt_PT
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-pt-pt = %{version}
Obsoletes:  open-xchange-gui-lang-community-pt-pt <= %{version}

%description -n open-xchange-gui-l10n-pt-pt
Package containing translation for pt_PT.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-ru-ru
Group:          I18N
Summary:        Package containing translation for ru_RU
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-ru-ru = %{version}
Obsoletes:  open-xchange-gui-lang-community-ru-ru <= %{version}

%description -n open-xchange-gui-l10n-ru-ru
Package containing translation for ru_RU.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-sv-se
Group:          I18N
Summary:        Package containing translation for sv_SE
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-sv-sv = %{version}
Provides:   open-xchange-gui-l10n-sv-sv = %{version}
Obsoletes:  open-xchange-gui-lang-community-sv-sv <= %{version}
Obsoletes:  open-xchange-gui-l10n-sv-sv <= %{version}

%description -n open-xchange-gui-l10n-sv-se
Package containing translation for sv_SE.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-th-th
Group:          I18N
Summary:        Package containing translation for th_TH
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-th-th = %{version}
Obsoletes:  open-xchange-gui-lang-community-th-th <= %{version}

%description -n open-xchange-gui-l10n-th-th
Package containing translation for th_TH.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-l10n-tr-tr
Group:          I18N
Summary:        Package containing translation for tr_TR
Requires:       open-xchange-gui-l10n
Provides:   open-xchange-gui-lang-community-tr-tr = %{version}
Obsoletes:  open-xchange-gui-lang-community-tr-tr <= %{version}

%description -n open-xchange-gui-l10n-tr-tr
Package containing translation for tr_TR.
This localization package are driven by the community.

Authors:
--------
    Open-Xchange

#%package -n     open-xchange-gui-l10n-vi-vi
#Group:          I18N
#Summary:        Package containing translation for vi_VI
#Requires:       open-xchange-gui-l10n
#Provides:   open-xchange-gui-lang-community-vi-vi = %{version}
#Obsoletes:  open-xchange-gui-lang-community-vi-vi <= %{version}
#
#%description -n open-xchange-gui-l10n-vi-vi
#Package containing translation for vi_VI.
#This localization package are driven by the community.
#
#Authors:
#--------
#    Open-Xchange

%prep
%setup -q -n %{name}-%{version}

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif
mkdir -p %{buildroot}/opt/open-xchange/lib
mkdir -p %{buildroot}/opt/open-xchange/etc/i18n.d
mkdir -p %{buildroot}/%{docroot}/ox6/lang
mkdir -p %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/
install -m 644 l10n/languages.js %{buildroot}/%{docroot}/ox6/lang/languages.js
install -m 644 l10n/lib/i18nfunctions.sh %{buildroot}/opt/open-xchange/lib/i18nfunctions.sh
install -m 644 l10n/lib/i18nfunctions.fake.sh %{buildroot}/opt/open-xchange/etc/i18nfunctions.sh
export ANT_OPTS="-Dfile.encoding=UTF-8"
( cd l10n; ant gui-lang; )
for lang in ca_ES cs_CZ da_DK de_CH de_DE el_GR en_GB en_US es_ES eu_ES fr_CA fr_FR gl_ES he_HE hu_HU it_IT ja_JP ko_KO lv_LV nl_NL pl_PL pt_BR pt_PT ro_RO ru_RU sk_SK sv_SE th_TH tr_TR zh_CN zh_TW es_MX; do
	DLANG=$(tr '[[:upper:]]' '[[:lower:]]' <<< ${lang/*_})
	TLANG=${lang/_*}
	test -e l10n/$lang/lang.name && \
		install -m 644 l10n/$lang/lang.name %{buildroot}/opt/open-xchange/etc/i18n.d/$lang.name
	test -e l10n/lang/${lang}.js && \
		install -m 644 l10n/lang/${lang}.js \
		%{buildroot}/%{docroot}/ox6/lang/${lang}.js
	test -e l10n/$lang/tinymce_lang_pack.${lang}.zip && \
		unzip l10n/$lang/tinymce_lang_pack.${lang}.zip \
			-d %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/ && \
	find %{buildroot}/%{docroot}/ox6/3rdparty/tinymce -type f -name "*${TLANG}*.js" \
		-printf '"%p"\n' > filelist_${lang} && \
		perl -pi -e 's;%{buildroot}/;;' filelist_${lang}
done

%clean
%{__rm} -rf %{buildroot}

%pre
if [ "$1" = 1 -a -e %{docroot}/ox6/lang/languages.js ]
then
    grep -vE '^.*\(de_DE|fr_FR|en_US|en_GB\).*$' %{docroot}/ox6/lang/languages.js > %{docroot}/ox6/lang/languages.js.new
    mv %{docroot}/ox6/lang/languages.js.new %{docroot}/ox6/lang/languages.js
fi

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-de-de
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang de_DE || true

%postun -n open-xchange-gui-l10n-de-de
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang de_DE || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-en-gb
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang en_GB || true

%postun -n open-xchange-gui-l10n-en-gb
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang en_GB || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-en-us
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang en_US || true

%postun -n open-xchange-gui-l10n-en-us
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang en_US || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-fr-fr
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang fr_FR || true

%postun -n open-xchange-gui-l10n-fr-fr
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang fr_FR || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-ja-jp
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ja_JP || true

%postun -n open-xchange-gui-l10n-ja-jp
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ja_JP || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-pl-pl
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang pl_PL || true

%postun -n open-xchange-gui-l10n-pl-pl
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang pl_PL || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-es-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang es_ES || true

%postun -n open-xchange-gui-l10n-es-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang es_ES || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-nl-nl
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang nl_NL || true

%postun -n open-xchange-gui-l10n-nl-nl
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang nl_NL || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-it-it
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang it_IT || true

%postun -n open-xchange-gui-l10n-it-it
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang it_IT || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-zh-cn
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang zh_CN || true

%postun -n open-xchange-gui-l10n-zh-cn
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang zh_CN || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-zh-tw
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang zh_TW || true

%postun -n open-xchange-gui-l10n-zh-tw
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang zh_TW || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-lv-lv
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang lv_LV || true

%postun -n open-xchange-gui-l10n-lv-lv
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang lv_LV || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-hu-hu
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang hu_HU || true

%postun -n open-xchange-gui-l10n-hu-hu
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang hu_HU || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-cs-cz
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang cs_CZ || true

%postun -n open-xchange-gui-l10n-cs-cz
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang cs_CZ || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-sk-sk
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang sk_SK || true

%postun -n open-xchange-gui-l10n-sk-sk
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang sk_SK || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-fr-ca
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang fr_CA || true

%postun -n open-xchange-gui-l10n-fr-ca
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang fr_CA || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-ro-ro
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ro_RO || true

%postun -n open-xchange-gui-l10n-ro-ro
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ro_RO || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-de-ch
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang de_CH || true

%postun -n open-xchange-gui-l10n-de-ch
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang de_CH || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-es-mx
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang es_MX || true

%postun -n open-xchange-gui-l10n-es-mx
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang es_MX || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-ca-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ca_ES || true

%postun -n open-xchange-gui-l10n-ca-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ca_ES || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-da-dk
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang da_DK || true

%postun -n open-xchange-gui-l10n-da-dk
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang da_DK || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-el-gr
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang el_GR || true

%postun -n open-xchange-gui-l10n-el-gr
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang el_GR || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-eu-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang eu_ES || true

%postun -n open-xchange-gui-l10n-eu-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang eu_ES || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-gl-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang gl_ES || true

%postun -n open-xchange-gui-l10n-gl-es
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang gl_ES || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-he-he
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang he_HE || true

%postun -n open-xchange-gui-l10n-he-he
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang he_HE || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-ko-ko
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ko_KO || true

%postun -n open-xchange-gui-l10n-ko-ko
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ko_KO || true

#------------------------------------------------------------------------------------------
#%post -n open-xchange-gui-l10n-no-nb
#. /opt/open-xchange/lib/i18nfunctions.sh
#test ${1:-0} -eq 1 && addLang no_NB || true
#
#%postun -n open-xchange-gui-l10n-no-nb
#. /opt/open-xchange/lib/i18nfunctions.sh
#test ${1:-0} -eq 0 && removeLang no_NB || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-pt-br
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang pt_BR || true

%postun -n open-xchange-gui-l10n-pt-br
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang pt_BR || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-pt-pt
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang pt_PT || true

%postun -n open-xchange-gui-l10n-pt-pt
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang pt_PT || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-ru-ru
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ru_RU || true

%postun -n open-xchange-gui-l10n-ru-ru
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ru_RU || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-sv-se
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang sv_SE || true

%postun -n open-xchange-gui-l10n-sv-se
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang sv_SE || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-th-th
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang th_TH || true

%postun -n open-xchange-gui-l10n-th-th
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang th_TH || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-l10n-tr-tr
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang tr_TR || true

%postun -n open-xchange-gui-l10n-tr-tr
. /opt/open-xchange/lib/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang tr_TR || true

#------------------------------------------------------------------------------------------
#%post -n open-xchange-gui-l10n-vi-vi
#. /opt/open-xchange/lib/i18nfunctions.sh
#test ${1:-0} -eq 1 && addLang vi_VI || true
#
#%postun -n open-xchange-gui-l10n-vi-vi
#. /opt/open-xchange/lib/i18nfunctions.sh
#test ${1:-0} -eq 0 && removeLang vi_VI || true

%files
%defattr(-,root,root)
%dir /opt/open-xchange/lib
%dir /opt/open-xchange/etc/i18n.d
%dir %{docroot}/ox6/lang
%config(noreplace) %{docroot}/ox6/lang/languages.js
/opt/open-xchange/lib/i18nfunctions.sh
/opt/open-xchange/etc/i18nfunctions.sh
%doc l10n/ChangeLog

%files -n open-xchange-gui-l10n-de-de -f filelist_de_DE
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/de_DE.js
/opt/open-xchange/etc/i18n.d/de_DE.name

%files -n open-xchange-gui-l10n-en-gb
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/en_GB.js
/opt/open-xchange/etc/i18n.d/en_GB.name

%files -n open-xchange-gui-l10n-en-us
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/en_US.js
/opt/open-xchange/etc/i18n.d/en_US.name

%files -n open-xchange-gui-l10n-fr-fr -f filelist_fr_FR
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/fr_FR.js
/opt/open-xchange/etc/i18n.d/fr_FR.name

%files -n open-xchange-gui-l10n-ja-jp -f filelist_ja_JP
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ja_JP.js
/opt/open-xchange/etc/i18n.d/ja_JP.name

%files -n open-xchange-gui-l10n-pl-pl -f filelist_pl_PL
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/pl_PL.js
/opt/open-xchange/etc/i18n.d/pl_PL.name

%files -n open-xchange-gui-l10n-es-es -f filelist_es_ES
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/es_ES.js
/opt/open-xchange/etc/i18n.d/es_ES.name

%files -n open-xchange-gui-l10n-nl-nl -f filelist_nl_NL
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/nl_NL.js
/opt/open-xchange/etc/i18n.d/nl_NL.name

%files -n open-xchange-gui-l10n-it-it -f filelist_it_IT
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/it_IT.js
/opt/open-xchange/etc/i18n.d/it_IT.name

%files -n open-xchange-gui-l10n-zh-cn -f filelist_zh_CN
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/zh_CN.js
/opt/open-xchange/etc/i18n.d/zh_CN.name

%files -n open-xchange-gui-l10n-zh-tw -f filelist_zh_TW
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/zh_TW.js
/opt/open-xchange/etc/i18n.d/zh_TW.name

%files -n open-xchange-gui-l10n-lv-lv -f filelist_lv_LV
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/lv_LV.js
/opt/open-xchange/etc/i18n.d/lv_LV.name

%files -n open-xchange-gui-l10n-hu-hu -f filelist_hu_HU
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/hu_HU.js
/opt/open-xchange/etc/i18n.d/hu_HU.name

%files -n open-xchange-gui-l10n-cs-cz -f filelist_cs_CZ
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/cs_CZ.js
/opt/open-xchange/etc/i18n.d/cs_CZ.name

%files -n open-xchange-gui-l10n-sk-sk -f filelist_sk_SK
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/sk_SK.js
/opt/open-xchange/etc/i18n.d/sk_SK.name

%files -n open-xchange-gui-l10n-fr-ca
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/fr_CA.js
/opt/open-xchange/etc/i18n.d/fr_CA.name

%files -n open-xchange-gui-l10n-ro-ro -f filelist_ro_RO
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ro_RO.js
/opt/open-xchange/etc/i18n.d/ro_RO.name

%files -n open-xchange-gui-l10n-de-ch
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/de_CH.js
/opt/open-xchange/etc/i18n.d/de_CH.name

%files -n open-xchange-gui-l10n-es-mx
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/es_MX.js
/opt/open-xchange/etc/i18n.d/es_MX.name


%files -n open-xchange-gui-l10n-ca-es -f filelist_ca_ES
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ca_ES.js
/opt/open-xchange/etc/i18n.d/ca_ES.name

%files -n open-xchange-gui-l10n-da-dk -f filelist_da_DK
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/da_DK.js
/opt/open-xchange/etc/i18n.d/da_DK.name

%files -n open-xchange-gui-l10n-el-gr -f filelist_el_GR
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/el_GR.js
/opt/open-xchange/etc/i18n.d/el_GR.name

%files -n open-xchange-gui-l10n-eu-es
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/eu_ES.js
/opt/open-xchange/etc/i18n.d/eu_ES.name

%files -n open-xchange-gui-l10n-gl-es
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/gl_ES.js
/opt/open-xchange/etc/i18n.d/gl_ES.name

%files -n open-xchange-gui-l10n-he-he -f filelist_he_HE
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/he_HE.js
/opt/open-xchange/etc/i18n.d/he_HE.name

%files -n open-xchange-gui-l10n-ko-ko -f filelist_ko_KO
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ko_KO.js
/opt/open-xchange/etc/i18n.d/ko_KO.name

#%files -n open-xchange-gui-l10n-no-nb
#%defattr(-,root,root)
#%dir %{docroot}/ox6/lang
#%{docroot}/ox6/lang/no_NB.js
#/opt/open-xchange/etc/i18n.d/no_NB.name

%files -n open-xchange-gui-l10n-pt-br
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/pt_BR.js
/opt/open-xchange/etc/i18n.d/pt_BR.name

%files -n open-xchange-gui-l10n-pt-pt -f filelist_pt_PT
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/pt_PT.js
/opt/open-xchange/etc/i18n.d/pt_PT.name

%files -n open-xchange-gui-l10n-ru-ru -f filelist_ru_RU
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ru_RU.js
/opt/open-xchange/etc/i18n.d/ru_RU.name

%files -n open-xchange-gui-l10n-sv-se -f filelist_sv_SE
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/sv_SE.js
/opt/open-xchange/etc/i18n.d/sv_SE.name

%files -n open-xchange-gui-l10n-th-th -f filelist_th_TH
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/th_TH.js
/opt/open-xchange/etc/i18n.d/th_TH.name

%files -n open-xchange-gui-l10n-tr-tr -f filelist_tr_TR
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/tr_TR.js
/opt/open-xchange/etc/i18n.d/tr_TR.name

#%files -n open-xchange-gui-l10n-vi-vi
#%defattr(-,root,root)
#%dir %{docroot}/ox6/lang
#%{docroot}/ox6/lang/vi_VI.js
#/opt/open-xchange/etc/i18n.d/vi_VI.name

%changelog
* Wed Nov 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 6.22.5 release
* Mon Nov 18 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-19
* Fri Nov 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 6.22.5 release
* Mon Nov 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-12
* Thu Nov 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 6.22.5 release
* Tue Nov 05 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-12
* Wed Oct 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 6.22.5 release
* Thu Oct 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
First sprint increment for 6.22.5 release
* Tue Sep 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Eleventh candidate for 6.22.4 release
* Fri Sep 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.5 release
* Fri Sep 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Tenth candidate for 6.22.4 release
* Thu Sep 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Ninth candidate for 6.22.4 release
* Sun Sep 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
Eighth candidate for 6.22.4 release
* Tue Aug 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 6.22.4 release
* Fri Aug 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 6.22.4 release
* Mon Aug 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.4
* Wed Aug 14 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-09
* Tue Aug 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.4
* Tue Aug 06 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.4
* Fri Aug 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.4
* Wed Jul 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.4
* Tue Jul 16 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.4
* Mon Jul 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 6.22.3 release
* Fri Jun 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 6.22.3 release
* Wed Jun 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 6.22.3 release
* Wed Jun 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.3
* Thu Jun 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-13
* Tue Jun 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-13
* Wed Mar 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-04
* Tue Mar 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 6.22.2
* Mon Mar 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.2
* Mon Mar 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.2
* Fri Mar 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.2
* Thu Mar 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.2
* Wed Feb 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.2
* Wed Feb 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.2 release
* Fri Feb 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-02-13
* Mon Jan 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-01-28
* Mon Nov 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-11-28
* Wed Nov 14 2012 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 6.22.1
* Tue Nov 13 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.1
* Tue Nov 06 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release build for 6.22.1
* Mon Nov 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release build for 6.22.1
* Wed Oct 31 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.1
* Wed Oct 31 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-10-31
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.1
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.1
* Wed Oct 10 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.0
* Tue Oct 09 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.0
* Fri Oct 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.0
* Fri Oct 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.0
* Tue Aug 21 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.0
* Tue Aug 21 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.0
* Fri Aug 10 2012 Marcus Klein <marcus.klein@open-xchange.com>
Initial release
