/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.TokenEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVRenderer
implements Renderer {
    private char separator;
    public static final char defaultSeparator = ',';

    public CSVRenderer() {
        this(',');
    }

    public CSVRenderer(char separatorChar) {
        this.separator = separatorChar;
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringBuffer rpt = new StringBuffer(1000);
        rpt.append("lines").append(this.separator);
        rpt.append("tokens").append(this.separator);
        rpt.append("occurrences");
        rpt.append(PMD.EOL);
        while (matches.hasNext()) {
            Match match = matches.next();
            rpt.append(match.getLineCount()).append(this.separator);
            rpt.append(match.getTokenCount()).append(this.separator);
            rpt.append(match.getMarkCount()).append(this.separator);
            Iterator<TokenEntry> marks = match.iterator();
            while (marks.hasNext()) {
                TokenEntry mark = marks.next();
                rpt.append(mark.getBeginLine()).append(this.separator);
                rpt.append(mark.getTokenSrcID());
                if (!marks.hasNext()) continue;
                rpt.append(this.separator);
            }
            rpt.append(PMD.EOL);
        }
        return rpt.toString();
    }
}

