/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextTokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection ais = (Collection)aim.get(SP12Constants.SECURITY_CONTEXT_TOKEN);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        ArrayList sctResults = new ArrayList();
        WSSecurityUtil.fetchAllActionResults(results, (int)1024, sctResults);
        for (AssertionInfo ai : ais) {
            SecurityContextToken sctPolicy = (SecurityContextToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired(sctPolicy, message) || !sctResults.isEmpty()) continue;
            ai.setNotAsserted("The received token does not match the token inclusion requirement");
        }
        return true;
    }
}

