/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.adapt.gnu.crypto.hash;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jonelo.jacksum.adapt.gnu.crypto.Registry;
import jonelo.jacksum.adapt.gnu.crypto.hash.BaseHash;
import jonelo.jacksum.adapt.gnu.crypto.hash.Has160;
import jonelo.jacksum.adapt.gnu.crypto.hash.Haval;
import jonelo.jacksum.adapt.gnu.crypto.hash.IMessageDigest;
import jonelo.jacksum.adapt.gnu.crypto.hash.MD2;
import jonelo.jacksum.adapt.gnu.crypto.hash.MD4;
import jonelo.jacksum.adapt.gnu.crypto.hash.MD5;
import jonelo.jacksum.adapt.gnu.crypto.hash.RipeMD128;
import jonelo.jacksum.adapt.gnu.crypto.hash.RipeMD160;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha0;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha160;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha224;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha256;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha384;
import jonelo.jacksum.adapt.gnu.crypto.hash.Sha512;
import jonelo.jacksum.adapt.gnu.crypto.hash.Tiger;
import jonelo.jacksum.adapt.gnu.crypto.hash.Tiger128;
import jonelo.jacksum.adapt.gnu.crypto.hash.Tiger160;
import jonelo.jacksum.adapt.gnu.crypto.hash.Tiger2;
import jonelo.jacksum.adapt.gnu.crypto.hash.Whirlpool;
import jonelo.jacksum.adapt.gnu.crypto.hash.Whirlpool2000;
import jonelo.jacksum.adapt.gnu.crypto.hash.Whirlpool2003;

public class HashFactory
implements Registry {
    private HashFactory() {
    }

    public static IMessageDigest getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BaseHash baseHash = null;
        if (string.equalsIgnoreCase("whirlpool")) {
            baseHash = new Whirlpool();
        } else if (string.equalsIgnoreCase("whirlpool_2000")) {
            baseHash = new Whirlpool2000();
        } else if (string.equalsIgnoreCase("whirlpool_2003")) {
            baseHash = new Whirlpool2003();
        } else if (string.equalsIgnoreCase("ripemd128") || string.equalsIgnoreCase("ripemd-128")) {
            baseHash = new RipeMD128();
        } else if (string.equalsIgnoreCase("ripemd160") || string.equalsIgnoreCase("ripemd-160")) {
            baseHash = new RipeMD160();
        } else if (string.equalsIgnoreCase("sha-160") || string.equalsIgnoreCase("sha-1") || string.equalsIgnoreCase("sha1") || string.equalsIgnoreCase("sha")) {
            baseHash = new Sha160();
        } else if (string.equalsIgnoreCase("sha-224")) {
            baseHash = new Sha224();
        } else if (string.equalsIgnoreCase("sha-384")) {
            baseHash = new Sha384();
        } else if (string.equalsIgnoreCase("sha-256")) {
            baseHash = new Sha256();
        } else if (string.equalsIgnoreCase("sha-512")) {
            baseHash = new Sha512();
        } else if (string.equalsIgnoreCase("tiger")) {
            baseHash = new Tiger();
        } else if (string.equalsIgnoreCase("tiger2")) {
            baseHash = new Tiger2();
        } else if (string.equalsIgnoreCase("tiger-160")) {
            baseHash = new Tiger160();
        } else if (string.equalsIgnoreCase("tiger-128")) {
            baseHash = new Tiger128();
        } else if (string.equalsIgnoreCase("haval")) {
            baseHash = new Haval();
        } else if (string.equalsIgnoreCase("md5")) {
            baseHash = new MD5();
        } else if (string.equalsIgnoreCase("md4")) {
            baseHash = new MD4();
        } else if (string.equalsIgnoreCase("md2")) {
            baseHash = new MD2();
        } else if (string.equalsIgnoreCase("haval")) {
            baseHash = new Haval();
        } else if (string.equalsIgnoreCase("haval_128_3")) {
            baseHash = new Haval(16, 3);
        } else if (string.equalsIgnoreCase("haval_128_4")) {
            baseHash = new Haval(16, 4);
        } else if (string.equalsIgnoreCase("haval_128_5")) {
            baseHash = new Haval(16, 5);
        } else if (string.equalsIgnoreCase("haval_160_3")) {
            baseHash = new Haval(20, 3);
        } else if (string.equalsIgnoreCase("haval_160_4")) {
            baseHash = new Haval(20, 4);
        } else if (string.equalsIgnoreCase("haval_160_5")) {
            baseHash = new Haval(20, 5);
        } else if (string.equalsIgnoreCase("haval_192_3")) {
            baseHash = new Haval(24, 3);
        } else if (string.equalsIgnoreCase("haval_192_4")) {
            baseHash = new Haval(24, 4);
        } else if (string.equalsIgnoreCase("haval_192_5")) {
            baseHash = new Haval(24, 5);
        } else if (string.equalsIgnoreCase("haval_224_3")) {
            baseHash = new Haval(28, 3);
        } else if (string.equalsIgnoreCase("haval_224_4")) {
            baseHash = new Haval(28, 4);
        } else if (string.equalsIgnoreCase("haval_224_5")) {
            baseHash = new Haval(28, 5);
        } else if (string.equalsIgnoreCase("haval_256_3")) {
            baseHash = new Haval(32, 3);
        } else if (string.equalsIgnoreCase("haval_256_4")) {
            baseHash = new Haval(32, 4);
        } else if (string.equalsIgnoreCase("haval_256_5")) {
            baseHash = new Haval(32, 5);
        } else if (string.equalsIgnoreCase("sha-0")) {
            baseHash = new Sha0();
        } else if (string.equalsIgnoreCase("has-160")) {
            baseHash = new Has160();
        }
        return baseHash;
    }

    public static final Set getNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("whirlpool");
        hashSet.add("ripemd128");
        hashSet.add("ripemd160");
        hashSet.add("sha-160");
        hashSet.add("sha-224");
        hashSet.add("sha-256");
        hashSet.add("sha-384");
        hashSet.add("sha-512");
        hashSet.add("tiger");
        hashSet.add("haval");
        hashSet.add("md5");
        hashSet.add("md4");
        hashSet.add("md2");
        hashSet.add("sha-0");
        return Collections.unmodifiableSet(hashSet);
    }
}

