/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.solr.custom;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.tika.Tika;

public class AttachmentUpdateProcessor
extends UpdateRequestProcessor {
    private static final Log LOG = LogFactory.getLog(AttachmentUpdateProcessor.class);
    private static final String ATTACHMENT = "attachment";

    public AttachmentUpdateProcessor(UpdateRequestProcessor next) {
        super(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument inputDocument = cmd.getSolrInputDocument();
        Object attachmentObj = inputDocument.getFieldValue(ATTACHMENT);
        InputStream is = null;
        if (attachmentObj != null) {
            if (attachmentObj instanceof InputStream) {
                LOG.debug((Object)"Attachment is of type InputStream.");
                is = (InputStream)attachmentObj;
            } else if (attachmentObj instanceof String) {
                LOG.debug((Object)"Attachment is of type String.");
                String attachment = (String)attachmentObj;
                LOG.debug((Object)("File: " + attachment));
                try {
                    is = new FileInputStream(attachment);
                }
                catch (FileNotFoundException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (SecurityException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (is != null) {
            try {
                String line;
                Tika tika = new Tika();
                Reader reader = tika.parse(is);
                BufferedReader br = new BufferedReader(reader);
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String text = sb.toString();
                LOG.debug((Object)("Extracted text: " + text));
                if (text != null && !text.isEmpty()) {
                    inputDocument.remove((Object)ATTACHMENT);
                    inputDocument.setField(ATTACHMENT, (Object)text);
                    LOG.debug((Object)"Resetting attachment field.");
                }
            }
            catch (IOException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        super.processAdd(cmd);
    }
}

