/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.log;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.LogConfigurationException;

/**
 * {@link LogFactory} - The <code>org.apache.commons.logging.LogFactory</code> using {@link LogService}.
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a> JavaDoc annotations
 */
public class LogFactory {

	/**
	 * The <tt>AtomicReference</tt> holding {@link LogWrapperFactory} instance.
	 */
	public static final AtomicReference<LogWrapperFactory> FACTORY = new AtomicReference<LogWrapperFactory>();

	/**
     * Convenience method to return a named logger, without the application having to care about factories.
     *
     * @param clazz The class from which a log name will be derived
     * @throws LogConfigurationException If a suitable <code>Log</code> instance cannot be returned
     */
    public static org.apache.commons.logging.Log getLog(final Class<?> clazz) {
		org.apache.commons.logging.Log log = Log.valueOf(org.apache.commons.logging.LogFactory.getLog(clazz));
		final String name = clazz.getName();
		final LogWrapperFactory factory = FACTORY.get();
        if (factory != null) {
			log = factory.wrap(name, log);
		}
		return new PropertiesAppendingLogWrapper(com.openexchange.exception.Log.valueOf(log));
    }

    /**
     * Convenience method to return a named logger, without the application having to care about factories.
     *
     * @param name The logical name of the <code>Log</code> instance to be returned (the meaning of this name is only known to the
     *            underlying logging implementation that is being wrapped)
     * @throws LogConfigurationException If a suitable <code>Log</code> instance cannot be returned
     */
    public static org.apache.commons.logging.Log getLog(final String name) {
		org.apache.commons.logging.Log log = Log.valueOf(org.apache.commons.logging.LogFactory.getLog(name));
		final LogWrapperFactory factory = FACTORY.get();
        if (factory != null) {
			log = factory.wrap(name, log);
		}
		return new PropertiesAppendingLogWrapper(com.openexchange.exception.Log.valueOf(log));
    }




}
