/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Parser {
    private static final String SPLIT_EXPRESSION = " ";
    private static final Map<String, Integer> precedence = new HashMap<String, Integer>();
    private static final List<String> charOperators;

    static {
        precedence.put("(", 15);
        precedence.put(")", 15);
        precedence.put("not", 8);
        precedence.put("=", 10);
        precedence.put(">", 10);
        precedence.put("<", 10);
        precedence.put(">=", 10);
        precedence.put("<=", 10);
        precedence.put("==", 10);
        precedence.put("!=", 10);
        precedence.put("between", 10);
        precedence.put("in", 10);
        precedence.put("like", 10);
        precedence.put("and", 5);
        precedence.put("or", 3);
        charOperators = Arrays.asList("(", ")", " + ", " - ", "=", "<", ">", " * ", " / ", "!");
    }

    /*
     * Unable to fully structure code
     */
    public List<String> toPrefix(String in) {
        indexIn = in.indexOf(" in ");
        if (indexIn == -1) {
            indexIn = in.indexOf(" IN ");
        }
        if (indexIn != -1) {
            indexOpen = in.indexOf("(", indexIn);
            indexClose = in.indexOf(")", indexOpen);
            sub = in.substring(indexOpen, indexClose + 1);
            sub = sub.replaceAll(" ", "");
            in = String.valueOf(in.substring(0, indexOpen)) + sub + in.substring(indexClose + 1);
        }
        stack = new ArrayList<String>();
        output = new ArrayList<String>();
        tokens = this.split(in);
        if (tokens.contains("between") || tokens.contains("BETWEEN")) {
            found = true;
            dirty = false;
            block0: while (found) {
                i = 0;
                while (i < tokens.size()) {
                    if ("between".equalsIgnoreCase(tokens.get(i))) {
                        tokens.set(i, "betweenAnd");
                        tokens.remove(i + 2);
                        dirty = true;
                        continue block0;
                    }
                    ++i;
                }
                found = false;
            }
            if (dirty) {
                i = 0;
                while (i < tokens.size()) {
                    if ("betweenAnd".equals(tokens.get(i))) {
                        tokens.set(i, "between");
                    }
                    ++i;
                }
            }
        }
        for (String token : tokens) {
            block13: {
                if (!this.isOperand(token)) break block13;
                if (!token.equals(")")) ** GOTO lbl51
                while (this.openParanthesesFound(stack)) {
                    output.add((String)stack.remove(stack.size() - 1));
                }
                if (stack.size() <= 0) continue;
                stack.remove(stack.size() - 1);
                continue;
lbl-1000:
                // 1 sources

                {
                    output.add((String)stack.remove(stack.size() - 1));
lbl51:
                    // 2 sources

                    ** while (this.openParanthesesFound(stack) && !this.hasHigherPrecedence((String)token, (String)((String)stack.get((int)(stack.size() - 1)))))
                }
lbl52:
                // 1 sources

                stack.add(token);
                continue;
            }
            output.add(token);
        }
        while (stack.size() > 0) {
            output.add((String)stack.remove(stack.size() - 1));
        }
        return output;
    }

    public List<String> split(String in) {
        StringBuilder result = new StringBuilder();
        char[] chars = in.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (charOperators.contains(String.valueOf(c))) {
                if (i < chars.length - 2 && charOperators.contains(String.valueOf(chars[i + 1])) && !"(".equals(String.valueOf(chars[i + 1])) && !")".equals(String.valueOf(chars[i + 1]))) {
                    result.append(SPLIT_EXPRESSION).append(c).append(chars[i + 1]).append(SPLIT_EXPRESSION);
                    ++i;
                } else {
                    result.append(SPLIT_EXPRESSION).append(c).append(SPLIT_EXPRESSION);
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        String[] tokens = result.toString().split(SPLIT_EXPRESSION);
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        while (i2 < tokens.length) {
            tokens[i2] = tokens[i2].trim();
            if (!tokens[i2].equals("")) {
                list.add(tokens[i2]);
            }
            ++i2;
        }
        return list;
    }

    boolean hasHigherPrecedence(String operator1, String operator2) {
        return precedence.get(operator1.toLowerCase()) > precedence.get(operator2.toLowerCase());
    }

    boolean isOperand(String string) {
        return precedence.containsKey(string.toLowerCase());
    }

    private boolean openParanthesesFound(List<String> stack) {
        return stack.size() > 0 && !stack.get(stack.size() - 1).equals("(");
    }
}

