/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.impl.ascii.rest.HttpCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpDeleteCommand;
import com.hazelcast.impl.ascii.rest.RestValue;

public class HttpDeleteCommandProcessor
extends HttpCommandProcessor<HttpDeleteCommand> {
    public HttpDeleteCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpDeleteCommand command) {
        String uri = command.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/")) {
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
            String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
            String key = uri.substring(indexEnd + 1);
            Object value = this.textCommandService.delete(mapName, key);
            command.send204();
        } else if (uri.startsWith("/hazelcast/rest/queues/")) {
            String secondStr;
            int seconds;
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/queues/".length());
            String queueName = uri.substring("/hazelcast/rest/queues/".length(), indexEnd);
            Object value = this.textCommandService.poll(queueName, seconds = (secondStr = uri.length() > indexEnd + 1 ? uri.substring(indexEnd + 1) : null) == null ? 0 : Integer.parseInt(secondStr));
            if (value == null) {
                command.send204();
            } else if (value instanceof byte[]) {
                command.setResponse(null, (byte[])value);
            } else if (value instanceof RestValue) {
                RestValue restValue = (RestValue)value;
                command.setResponse(restValue.getContentType(), restValue.getValue());
            } else if (value instanceof String) {
                command.setResponse(HttpCommand.CONTENT_TYPE_PLAIN_TEXT, ((String)value).getBytes());
            } else {
                command.setResponse(null, ThreadContext.get().toByteArray(value));
            }
        } else {
            command.send400();
        }
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpDeleteCommand command) {
        this.handle(command);
    }
}

