/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactoryImpl;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class Attendee
extends Property {
    private static final long serialVersionUID = 8430929418723298803L;
    private URI calAddress;

    public Attendee() {
        super("ATTENDEE", PropertyFactoryImpl.getInstance());
    }

    public Attendee(String aValue) throws URISyntaxException {
        super("ATTENDEE", PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public Attendee(ParameterList aList, String aValue) throws URISyntaxException {
        super("ATTENDEE", aList, PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public Attendee(URI aUri) {
        super("ATTENDEE", PropertyFactoryImpl.getInstance());
        this.calAddress = aUri;
    }

    public Attendee(ParameterList aList, URI aUri) {
        super("ATTENDEE", aList, PropertyFactoryImpl.getInstance());
        this.calAddress = aUri;
    }

    public final void setValue(String aValue) throws URISyntaxException {
        this.calAddress = Uris.create(aValue);
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("CUTYPE", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("MEMBER", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("ROLE", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("PARTSTAT", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("RSVP", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DELEGATED-TO", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DELEGATED-FROM", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("SENT-BY", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("CN", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DIR", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("LANGUAGE", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("SCHEDULE-AGENT", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("SCHEDULE-STATUS", this.getParameters());
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI calAddress) {
        this.calAddress = calAddress;
    }
}

