/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalMapStats;
import java.io.Serializable;
import java.util.concurrent.Callable;

public class DistributedMapStatsCallable
implements Callable<MemberMapStat>,
Serializable,
HazelcastInstanceAware {
    private String mapName;
    private transient HazelcastInstance hzInstance;

    public DistributedMapStatsCallable(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public MemberMapStat call() throws Exception {
        IMap map = this.hzInstance.getMap(this.mapName);
        LocalMapStats localMapStats = map.getLocalMapStats();
        Member member = this.hzInstance.getCluster().getLocalMember();
        return new MemberMapStat(member, localMapStats);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hzInstance = hazelcastInstance;
    }

    public static class MemberMapStat
    implements Serializable {
        Member member;
        LocalMapStats localMapStats;

        public MemberMapStat(Member member, LocalMapStats localMapStats) {
            this.member = member;
            this.localMapStats = localMapStats;
        }

        public Member getMember() {
            return this.member;
        }

        public void setMember(Member member) {
            this.member = member;
        }

        public LocalMapStats getLocalMapStats() {
            return this.localMapStats;
        }

        public void setLocalMapStats(LocalMapStats localMapStats) {
            this.localMapStats = localMapStats;
        }
    }
}

