/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.mail;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.ContentTypeField;
import com.openexchange.usm.api.contenttypes.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.MailContentType;
import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.datatypes.DataType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.exceptions.USMSQLException;
import com.openexchange.usm.api.session.ChangeState;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.session.dataobject.DataObjectUtil;
import com.openexchange.usm.session.dataobject.SimpleDataObject;

public class MeetingRequestResponseUtil {

	public static MailAttachment getICalFromExternalAppInvitationMail(DataObject mailObject) {
		if (mailObject.getContentType().getCode() != DefaultContentTypes.MAIL_CODE)
			return null;
		//go trough all email attachments and find an iCal attachment
		Object objAttach = mailObject.getFieldContent("attachments");
		if (objAttach instanceof Object[]) {
			Object[] ar = (Object[]) objAttach;
			for (Object o : ar) {
				if (o instanceof MailAttachment) {
					MailAttachment a = (MailAttachment) o;
					String content_type = a.getContent_type();
					if (content_type != null
							&& (content_type.startsWith("text/calendar") || content_type.startsWith("application/ics"))) {
						return a;
					}
				}
			}
		}
		return null;
	}

	public static DataObject getAppointmentFromExternalInvitation(DataObject changeObject,
			MailAttachment icalFromExternalAppInvitationMail, Session session) throws USMException, JSONException {

		if (changeObject.getContentType().getCode() != DefaultContentTypes.MAIL_CODE)
			return null;
		if (icalFromExternalAppInvitationMail == null)
			return null;
        String attSeqId = icalFromExternalAppInvitationMail.getId();
		
        return getAppointmentObjectFromInvitation(changeObject, session, attSeqId);
	}

    public static DataObject getAppointmentObjectFromInvitation(DataObject changeObject, Session session, String attSeqId) throws USMException, JSONException, DatabaseAccessException, USMSQLException {
        JSONObject iTipAnswer = ((MailContentType) changeObject.getContentType()).analyzeICalAttachment(changeObject, attSeqId);
		JSONObject change = getChangeFromITipAnswer(iTipAnswer);
		ContentType calendarContentType = getCalendarContentType(session);
		if (iTipAnswer.has("messageType") && "cancel".equals(iTipAnswer.getString("messageType"))) {
			if (change != null && change.has("deletedAppointment")) {
				JSONObject app = change.getJSONObject("deletedAppointment");
				DataObject appObj = new SimpleDataObject(session, calendarContentType);
				fillAppObject(calendarContentType, app, appObj);
				appObj.setChangeState(ChangeState.DELETED);
				return appObj;
			} else if (change != null && change.has("currentAppointment")) {
				JSONObject app = change.getJSONObject("currentAppointment");
				DataObject appObj = new SimpleDataObject(session, calendarContentType);
				fillAppObject(calendarContentType, app, appObj);
				appObj.setChangeState(ChangeState.DELETED);
				return appObj;
			} else if (iTipAnswer.has("uid")) {
				DataObject appObj = new SimpleDataObject(session, calendarContentType);
				appObj.setFieldContent("uid", iTipAnswer.getString("uid"));
				appObj.setChangeState(ChangeState.DELETED);
				return appObj;
			}
		}
		if (change == null)
			return null;
		if (change.has("type") && "create".equals(change.getString("type"))) {
			JSONObject newApp = change.getJSONObject("newAppointment");
			DataObject newAppObj = new SimpleDataObject(session, calendarContentType);
			fillAppObject(calendarContentType, newApp, newAppObj);
			newAppObj.setFieldContent("created_by", String.valueOf(session.getUserIdentifier()));
			return newAppObj;
		}

		if (change.has("type") && "update".equals(change.getString("type"))) {
			JSONObject currApp = change.getJSONObject("currentAppointment");
			JSONObject newApp = change.getJSONObject("newAppointment");
			DataObject currAppObj = new SimpleDataObject(session, calendarContentType);
			DataObject newAppObj = new SimpleDataObject(session, calendarContentType);
			fillAppObject(calendarContentType, currApp, currAppObj);
			currAppObj.commitChanges();
			fillAppObject(calendarContentType, newApp, newAppObj);
			newAppObj.commitChanges();
			newAppObj = DataObjectUtil.copyAndModify(currAppObj, newAppObj, true, true);
			if(iTipAnswer.has("messageType") && "reply".equals(iTipAnswer.getString("messageType")))
			    newAppObj.commitChanges(); // sets the state of the object to "unmodified" to be able to differentiate from meeting update
			return newAppObj;
		}
		return null;
    }

	public static void fillAppObject(ContentType calendarContentType, JSONObject newApp, DataObject newAppObj)
			throws JSONException {
		ContentTypeField[] fields = calendarContentType.getFields();
		for (ContentTypeField contentTypeField : fields) {
			String fieldName = contentTypeField.getFieldName();
			DataType<?> fieldType = contentTypeField.getFieldType();
			if (newApp.has(fieldName))
				newAppObj.setFieldContent(fieldName, fieldType.extractFromJSONObject(newAppObj.getSession(), newApp,
						fieldName));
		}
	}

	private static JSONObject getChangeFromITipAnswer(JSONObject iTipAnswer) throws JSONException {
		if (!iTipAnswer.has("changes"))
			return null;
		JSONArray changes = iTipAnswer.getJSONArray("changes");
		if (changes.length() == 0)
			return null;
		return changes.getJSONObject(0);
	}

	private static ContentType getCalendarContentType(Session session) throws DatabaseAccessException, USMSQLException {
		ContentType[] contentTypes = session.getContentTypes();
		ContentType calendarContentType = null;
		for (ContentType contentType : contentTypes) {
			if (contentType.getCode() == DefaultContentTypes.CALENDAR_CODE)
				calendarContentType = contentType;
		}
		return calendarContentType;
	}

}
