/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2013 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Pattern;

/**
 * {@link Definitions}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class Definitions {

    private static final String DEBIAN_CHANGELOG_FIRSTLINE_REGEX = "^([\\w-]+)\\s\\(([\\d\\.]+-\\d+)\\)\\s([\\p{Alpha};= ]+)";
    public static final Pattern DEBIAN_CHANGELOG_FIRSTLINE_PATTERN = Pattern.compile(DEBIAN_CHANGELOG_FIRSTLINE_REGEX + '$');

    private static final String DEBIAN_CHANGELOG_REGEX = DEBIAN_CHANGELOG_FIRSTLINE_REGEX + "[\\p{Space}\\*]+(.*)\\p{Space}+--\\s(.+?)\\s\\s(.*)\\n$";
    public static final Pattern DEBIAN_CHANGELOG_PATTERN = Pattern.compile(DEBIAN_CHANGELOG_REGEX, Pattern.MULTILINE);

    public static final DateFormat DEBIAN_DF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    public static final DateFormat SPECFILE_DF = new SimpleDateFormat("EEE MMM dd yyyy", Locale.ENGLISH);

    private static final String SPEC_CHANGELOG_REGEX = "^\\* ([\\p{Alpha}]{3} [\\p{Alpha}]{3} [\\d]{2} [\\d]{4}) ([\\w ]* <[\\w\\.@-]*>)\\n(.*)$";
    public static final Pattern SPEC_CHANGELOG_PATTERN = Pattern.compile(SPEC_CHANGELOG_REGEX, Pattern.MULTILINE);

    private static final String VERSION_REGEX = "^([0-9]+)\\.([0-9]+)\\.([0-9]+)";
    public static final Pattern VERSION_PATTERN = Pattern.compile(VERSION_REGEX + "$");

    private static final String VERSION_AND_REVISION_REGEX = VERSION_REGEX + "-([0-9]+)$";
    public static final Pattern VERSION_AND_REVISION_PATTERN = Pattern.compile(VERSION_AND_REVISION_REGEX);

    private static final String REVISION_REGEX = "^[0-9\\.]+-([0-9]+)$";
    public static final Pattern REVISION_PATTERN = Pattern.compile(REVISION_REGEX);

    private Definitions() {
        super();
    }
}
