/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

function createContent() {
    var link = newnode("div", { marginTop: "2em", marginBottom: "1.5em" }, 0, [
        newnode("img", { verticalAlign: "middle", paddingRight: "7px" },
            { src: getFullImgSrc("img/infostore/infostore_save.gif") }),
        newnode("a", 0, { href: "#" }, [addTranslated(
            _("Download Updater"))])]);
    addDOMEvent(link, "click", function(e) {
        stopEvent(e);
        $("dlIframe").src =
            AjaxRoot + "/updater/installer/oxupdater-install.exe?session=" + session;
    });
    
    var node = newnode("div", 0, 0, [link,
         newnode("div", 0, 0, [addTranslated(
             _("When activating this option an installation wizard will be launched."))]),
         newnode("div", 0, 0, [addTranslated(
             _("Follow the instructions and install the updater."))]),
         newnode("div", 0, 0, [addTranslated(
             _("Installs latest versions of Windows® client software. The Updater automatically informs about new updates."))]),
         newnode("div", 0, 0, [addTranslated(
             _("You can download the updates from within the updater."))])
    ]);
    
    if (getProduct("com.openexchange.outlook.updater.oxtender2") === true) {
        jQuery(node).append(
            newnode("div", { height: "1em" }, 0, []),
            newnode("div", { fontWeight: "bold" }, 0, [addTranslated(
                _("Connector for Microsoft Outlook®"))]),
            newnode("div", 0, 0, [addTranslated(
                _("Synchronization of E-Mails, Calendar, Contacts and Tasks, along with Public, Shared and System Folders to Microsoft Outlook® clients."))])
        );
    }
    
    if (getProduct("com.openexchange.oxnotifier") === true) {
        jQuery(node).append(
            newnode("div", { height: "1em" }, 0, []),
            newnode("div", { fontWeight: "bold" }, 0, [ addTranslated(
                _("Notifier"))]),
            newnode("div", 0, 0, [addTranslated(
                _("Informs about the current status of E-Mails and appointments without having to display the user interface or another Windows® client."))])
        );
    }
    return node;
}

var isProductAvailable = function () {
    var products = ox.api.config.get(["modules", "com.openexchange.oxupdater","products"], []),
        available = false;
    check: for (var i=0; i < products.length; i++) {
        var prod = products[i];
        for (var a in prod) {
            if (prod[a] === true) {
                available = true;
                break check;
            };
        };
    }
    return available && ox.api.config.get(["modules", "com.openexchange.oxupdater", "module"], false) === true;
};

var getProduct = function (key) {
    var products = ox.api.config.get(["modules", "com.openexchange.oxupdater","products"], []);
    for (var i=0; i < products.length; i++) {
        var prod = products[i];
        for (var a in prod) {
            if (a === key) {
                return prod[a];
            };
        };
    }
    return null;
};

if (configGetKey("modules")["com.openexchange.wizard"] && isProductAvailable() === true) {
    
    // load CSS file
    loadCSSFile(PATH + "/style.css");
    
    var tab = {
        name: "oxupdater",
        enabled: false,
        visible: true,
        position: 0,

        headerImage: newnode("img", 0, {
            className: "oxupdater-header-wizard_d com-openexchange-oxupdater wizardHeaderImage-disabled",
            src: getFullImgSrc("img/dummy.gif")
        }),

        welcome_node: newnode("tr", 0 , 0, [
            newnode("td", { paddingTop: "5px", paddingleft: "5px" }, 0, [
                newnode("img", 0, {
                    className: "oxupdater-header-wizard_mini wizzardGridBox com-openexchange-oxupdater wizardMiniIcon",
                    src: getFullImgSrc("img/dummy.gif")
                })
            ]),
            newnode("td", { paddingTop: "5px" }, 0, [
                addTranslated(_("Download Updater"))
            ])
        ]),
        
        content: createContent(),

        draw: function(wizard) {
            $("popup.wizzard.next").value = _("Next");
            $("popup.wizzard.back").value = _("Previous");
            
            var title = $("popup.wizzard.header").getElementsByTagName("span")[0];
            removeChildNodes(title);
            if (!this.title) {
                this.title = addTranslated(_("Download Updater"));
            }
            title.appendChild(this.title);
            
            var header = document.getElementById("wizzardHeaderTitle");
            removeChildNodes(header);
            header.appendChild(addTranslated(_("Updater")));
            
            jQuery(this.headerImage)
                .removeClass("oxupdater-header-wizard_d wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("oxupdater-header-wizard_a wizardHeaderImage-active");

            var base = document.getElementById("wizzardConten");
            removeChildNodes(base);
            base.appendChild(this.content);
        },
        next: function(callback) {
            jQuery(this.headerImage)
                .removeClass("oxupdater-header-wizard_d wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("oxupdater-header-wizard_a wizardHeaderImage");
            callback();
        },
        previous: function(callback) {
            jQuery(this.headerImage)
                .removeClass("oxupdater-header-wizard_a wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("oxupdater-header-wizard_d wizardHeaderImage-disabled");
            callback();
        }
    };
    temporary.services.provide("com.openexchange.wizard", tab);
}

var node;

// register global event (allows better external access)
register("Feature_MicrosoftOutlook", function () {
    if (ox.upsell.matrix.hasFeature("olox") === false || node == undefined) {
        corewindow.triggerEvent("Feature_Not_Available", "modules/outlook.updater", window);
    } else {
        ox.UIController.configJump(node.id);
    }
});

var coou = "com.openexchange.oxupdater";
var menuID = "com.openexchange.synchronization.menu";
var menu = new MenuNodes.Section("com.openexchange.synchronization",
    _("Synchronization"), -1);
var button = new MenuNodes.Button(_("Microsoft Outlook"));
button.icon = "img/infostore/infostore_save.gif";
button.disabledIcon = "img/infostore/infostore_save_d.gif";
button.click = function() { triggerEvent("Feature_MicrosoftOutlook"); };
menu.add(button);
if (getProduct("com.openexchange.outlook.updater.oxtender2") !== true) {
    button.button.options.mousedown = function() {
        corewindow.triggerEvent("Feature_Not_Available", "modules/outlook.updater", window);
    };
    // button disabled
    button.setEnabled(false);
}
menu.show("portal");

if (isProductAvailable() === true) {
    node = new ox.Configuration.LeafNode("configuration/outlook.updater", _("Updater"));
    var page = new ox.Configuration.Page(node, _("Updater"), false);
    page.viewModified = function() { return false; };
    var widget = new ox.UI.Widget();
    widget.content = createContent();
    widget.addContent = function() { this.parent.addRow(this.content); };
    page.addWidget(widget);
}
