/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2009 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

// DEVELOPMENT IN PROGRESS // SUBJECT TO PERMANENT CHANGE!

ox.gui.GenericWidget = ox.gui.Widget.extend({
/** @lends ox.gui.Widget.prototype */
    
    /** 
     * The abstract generic widget class
     * @constructs
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
    
        // call super class constructor
        this._super(id);
        
        this.defaultValue = "";
        this.value = "";
        this.name = "";
    },

    getClass: function() { return "ox.gui.GenericWidget"; },
    
    nodeCreate: function() {
        ox.gui.Widget.prototype.nodeCreate.call(this, "div");
    },
    
    paintVisible: function() {
        this.dom.node.style.display = "inline";
    },
    
    paintEnabled: function() {
        if (this.dom.node.firstChild) {
            this.dom.node.firstChild.disabled = false;
        }
    },

    paintDisabled: function() {
        if (this.dom.node.firstChild) {
            this.dom.node.firstChild.disabled = true;
        }
    },
    
    getName: function(name) {
        return this.name;
    },
    
    setName: function(name) {
        this.name = name;
        return this;
    },
    
    hasValue: function() {
        return true; 
    },
    
    getValue: function() {
        return this.value;
    },
    
    getDefaultValue: function() {
        return this.defaultValue;
    },
    
    setValue: function(value) {
        this.value = value;
        return this;
    },
    
    setDefaultValue: function(value) {
        this.defaultValue = this.value = value;
        return this;
    }
});

ox.gui.TextArea = ox.gui.GenericWidget.extend({
/** @lends ox.gui.GenericWidget.prototype */
    
    /** 
     * A basic text area widget
     * @constructs
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
        this._super(id);
    },
    
    getClass: function() { return "ox.gui.TextArea"; },
    
    nodeCreate: function() {
        ox.gui.Widget.prototype.nodeCreate.call(this, "div");
        $(this.dom.node).css({
            border: "2px solid #fc0"
        });
        this.dom.field = $("<textarea/>").css({
            width: "100%",
            height: "100%",
            border: "0px none",
            padding: "0px",
            margin: "0px"
        }).appendTo(this.dom.node);
    },
    
    paintEnabled: function() {
        this.dom.node.disabled = false;
    },

    paintDisabled: function() {
        this.dom.node.disabled = true;
    },
    
    paint: function() {
        this.dom.node.nodeValue = this.value;
        if (!this.isEnabled()) {
            this.paintDisabled();
        }
    },
    
    getValue: function() {
        return $(this.dom.field).val();
    },

    setValue: function(value) {
        $(this.dom.field).val(value);
    }
});

ox.gui.Text = ox.gui.GenericWidget.extend({
/** @lends ox.gui.GenericWidget.prototype */
    
    /** 
     * A basic text element
     * @constructs
     * @param {String} ref An optional unique id for the widget ("for").
     */
    construct: function(text) {
        // call super class constructor
        this._super();
        this.text = text || "";
    },
    
    getClass: function() { return "ox.gui.Text"; },
    
    paint: function() {
        $(this.dom.node).text(this.text);
    }
});

ox.gui.Label = ox.gui.GenericWidget.extend({
/** @lends ox.gui.GenericWidget.prototype */
    
    /** 
     * A basic label
     * @constructs
     * @param {String} ref An optional unique id for the widget ("for").
     */
    construct: function(text, ref) {
        // call super class constructor
        this._super();
        this.text = text || "";
        this.ref = ref || "";
    },
    
    getClass: function() { return "ox.gui.Label"; },
    
    paint: function() {
        var label = newnode("label", 0, { "for": this.ref }, [newtext(this.text)]);
        this.dom.node.appendChild(label);
    }
});

ox.gui.TextBox = ox.gui.GenericWidget.extend({
/** @lends ox.gui.GenericWidget.prototype */
    
    /** 
     * A basic text field widget
     * @constructs
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
    
        // call super class constructor
        this._super(id);
        this.dom.box = null;
    },
    
    getClass: function() { return "ox.gui.TextBox"; },
    
    paint: function() {
        this.dom.box = newnode("input", 0, {
            className: "textBox", type: "text",
            name: this.name, value: this.value
        });
        this.dom.node.appendChild(this.dom.box);
        if (!this.isEnabled()) {
            this.paintDisabled();
        }
    },
    
    getValue: function () {
        return $(this.dom.box).val();
    }
});

ox.gui.PasswordBox = ox.gui.TextBox.extend({
/** @lends ox.gui.TextField.prototype */
    
    /** 
     * A basic password field widget
     * @constructs
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
    
        // call super class constructor
        this._super(id);
    },
    
    getClass: function() { return "ox.gui.PasswordBox"; },
    
    paint: function() {
        var box = newnode("input", 0, { 
            className: "textBox", type: "password",
            name: this.name, value: this.value
        });
        this.dom.node.appendChild(box);
        if (!this.isEnabled()) {
            this.paintDisabled();
        }
    }
});

ox.gui.ListBox = ox.gui.GenericWidget.extend({
/** @lends ox.gui.GenericWidget.prototype */
    
    /** 
     * A basic list box widget
     * @constructs
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
    
        // call super class constructor
        this._super(id);
        this.dom.box = null;
        this.options = [];
    },
    
    getClass: function() { return "ox.gui.ListBox"; },
    
    addOption: function(value, text) {
        this.options.push({ "value": value, "text": text });
        return this;
    },
    
    paint: function() {
        this.dom.box = newnode("select", 0, { size: "1", name: this.name, value: this.value });
        // add options
        for (var i = 0; i < this.options.length; i++) {
            var option = this.options[i];
            this.dom.box.appendChild(
                newnode("option", 0, {
                    "value": option.value, "selected": option.value == this.value ? "selected" : ""
                }, [newtext(option.text)])
            );
        }
        this.dom.node.appendChild(this.dom.box);
        if (!this.isEnabled()) {
            this.paintDisabled();
        }
    },
    
    getValue: function () {
        return $(this.dom.box).val();
    },
    
    focus: function () {
        this.dom.box.focus();
    }
});

ox.gui.ComboBox = ox.gui.GenericWidget.extend({
/** @lends ox.gui.GenericWidget.prototype */
    
    /** 
     * A basic list box widget
     * @constructs
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
    
        // call super class constructor
        this._super(id);
        
        this.options = [];
        this.focusIndex = 0;
    },
    
    nodeInit: function() {
        ox.gui.GenericWidget.prototype.nodeInit.call(this);
    },
    
    getClass: function() { return "ox.gui.ComboBox"; },
    
    addOption: function(value, text) {
        this.options.push({ "value": value, "text": text });
        return this;
    },
    
    paint: function() {
        
        // text box
        this.dom.box = newnode("input", 0, { 
            className: "comboBox", type: "text", name: this.name, value: this.value
        });
        this.dom.node.appendChild(this.dom.box);
        
        // selector
        var selector = newnode("div", { 
            backgroundImage: "url(" + ox.desktop.themePath + "/arrow_down.gif" + ")"
        }, {
            className: "comboBoxSelector"
        }, [newtext("\u00a0")]);
        this.dom.node.appendChild(selector);
        
        // options
        this.optionsDiv = newnode("div", 0, {
            className: "comboBoxOptions"
        });
        document.body.appendChild(this.optionsDiv);
        
        var selection = new ox.gui.Selection();
        
        var conti = newnode("div", { backgroundColor: "white" });
        this.dom.node.appendChild(conti);
        conti.tabIndex = 0;
        conti.className = "autoFocus";
        
        for(var i=0; i<10; i++) {
            var div = newnode("div", {  }, { 
            }, [newtext("DIV #"+i)]);
            div.oxID = "DIV#"+i;
            conti.appendChild(div);
        }
        
        selection.observe(conti);
        
        var mousedown = function() {
            if (this.isEnabled()) {
                var box = $(this.dom.box);
                $(selector).addClass("mousedown");
                box.addClass("mousedown");
                this.addListener("dom:mouseup", document, mouseup);
                this.addListener("dom:mousedown", document, outerMouseDown);
                // show options
                var offset = box.offset();
                var t = offset.top + box.outerHeight();
                var w = box.width();
                $(this.optionsDiv).css({
                    top: t + "px", left: offset.left + "px", width: w
                });
                $(this.optionsDiv).toggle();
            }
            return false;
        };
        var mouseup = function() {
            $(selector).removeClass("mousedown");
            $(this.dom.box).removeClass("mousedown");
            this.removeListener("dom:mouseup", document, mouseup);
        };
        var outerMouseDown = function() {
            $(this.optionsDiv).fadeOut("fast");
        };
        
        this.addListener("dom:mousedown", selector, mousedown);
        
        if (!this.isEnabled()) {
            this.paintDisabled();
        }
    },
    
    resize: function() {
        $(this.optionsDiv).hide();
    }
});