/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 *
 */

var contactsSelection2 = new Selection2();
var contactsCardsRequest;
var contactsCardsRequest2;
var contactsFolderPath;

var contactJson = new JSONX();
var tmpDetailRequest=null, contactsSearchObject = null;
/********************************** register Modules *****************************************************************/

var contacts_phonelist_first=true;

/* Array for printing*/
var aPrintDetailContact = new Array();

var gridattContactDetail;
registerPrintView("contacts/phonelist");
registerPrintView("contacts/detail/overview");

function setFlagInContactView(tag){
	if(activemodule=="contacts") {
	   objContactFunctions.contactAddTag(tag);
	}
}

registerView("contacts",
	function () {
    },
	function() {
		register("OX_Add_Flag", setFlagInContactView);
		ox.widgets.searchField.active().searchMenu.setFields(
            ["first_name", "last_name", "display_name", "email1", "email2",
                "email3", "company", "street_business", "city_business",
                "department", "categories"],
            ["First name"/*i18n*/, "Last name"/*i18n*/, "Display name"/*i18n*/,
                "E-Mail"/*i18n*/, "E-Mail (private)"/*i18n*/,
                "E-Mail (other)"/*i18n*/, "Company" /*i18n*/,
                "Street" /*i18n*/, "City" /*i18n*/,
                "Department" /*i18n*/, "Categories"/*i18n*/],
            configGetKey("modules.contacts.gui.searchFields") ||
                { first_name: true, last_name: true, display_name: true,
                  email1: true, email2: true, email3: true, categories: true });
		ox.widgets.searchField.active().searchMenu.onChange = function() {
            if (config.modules.contacts.gui === "null" ||
                    config.modules.contacts.gui === "undefined"){
                delete config.modules.contacts.gui;
            }
            configSetKey("modules.contacts.gui.searchFields", this.checked);
            ox.JSON.put(AjaxRoot + "/config/modules/contacts/gui?session=" +
                        session, configGetKey("modules.contacts.gui"),
                        emptyFunction);
        };
	},
	function() {
	    contactsSearchObject = null;
	    ox.widgets.searchField.active().searchMenu.setFields();
		if(tmpDetailRequest) {
            OXCache.unregister(tmpDetailRequest.uniqueName);
            tmpDetailRequest=null;
        }
		unregister("OX_Add_Flag", setFlagInContactView);
		triggerEvent("Selected",[]);
	},
	function() {
	    triggerEvent('OX_Delete_Search');
	},
	null
);

registerView("contacts/phonelist",
    // show
	function() {
		showNode("contactsList");
	},
	// enter
	function() {
	    // refresh selection
		if (!contactGrid) {
		    initLiveGridOnLoad();
		}
		myLetterContactTab.buildTab("listeContactsLetterDiv");
		initLiveGridContacts();
		register("OX_Print",contacts_printList);
		register("OX_New_Search",searchContactByString);
		register("OX_Delete_Search",deleteSearchContactByString);
		// refresh selection (trigger when new view is set)
		setTimeout(function () {
		    triggerEvent("Selected", contactGrid.selection.getSelected());
		}, 0);
        if (corewindow.hasFocus) setFocus($("listeContacts"));
	},
	// leave
	function() {
		if(contactGrid) {
			contactGrid.disable();
		}
		unregister("OX_Print",contacts_printList);
		unregister("OX_New_Search",searchContactByString);
		unregister("OX_Delete_Search",deleteSearchContactByString);
        myLetterContactTab.unregisterTab();
		viewContactsBySearch.searchstring = "";
		triggerEvent('OX_Delete_Search');
		contactsFolderPath.clear();
	},
	// hide
	function() {
		hideNode("contactsList");
	},
	function() {
	    triggerEvent('OX_Delete_Search');
		myLetterContactTab.buildTab("listeContactsLetterDiv");
		initLiveGridContacts();
	}
);
registerView("contacts/cards",
    // show
	function() {
		showNode("contactCards");
	},
	// enter
	function() {
		myLetterContactTab.buildTab("cardContactsLetterDiv");
		if(configGetKey("gui.contacts.cardsToViewPerColumn") == "auto")
			resizeEvents.register("Resized",showContactCards);
		else
			showContactCards();
		register("OX_New_Search",searchContactByString);
		register("OX_Delete_Search",deleteSearchContactByString);

		objContactFunctions.refHover = new Hover($("tablecontactscards"),OXContactHover.getContent().node);
		objContactFunctions.refHover.setSize(OXContactHover.contentobject.node);
		if(configGetKey("gui.effects.hover.contacts") && objContactFunctions.refHover) {
			objContactFunctions.refHover.enable();
		}

		objContactFunctions.refHover.getTarget = function (node) {
            try {
                while (node) {
                    if (node.oxcontactobj) return node.parentNode ? node : null;
                    node = node.parentNode;
                }
            } catch (e) { /*see default implementation*/ }
        };
		objContactFunctions.refHover.onShow = function (node, manual) {
			OXContactHover.hover = OXContactHover.actualHover = this;
			OXContactHover.accordion.setHover(this);
			clearCardHoverFields();
			var splitid=node.oxcontactobj.split("-");
			OXContactHover.refillContent(splitid[1], splitid[0], function() {
				// trigger event
				var node = OXContactHover.getContent().node || null;
				var contact = OXContactHover.actualobject || null;
				if (node && contact) {
					triggerEvent("PAINT_CONTACT", { "view": "hover", "number": 0, "contact": contact, "node": node, "hover": objContactFunctions.refHover });
				}
			});
		};
		objContactFunctions.refHover.onHide = function (node) {
			clearCardHoverFields();
		};
		// refresh selection (trigger when new view is set)
        setTimeout(function () {
            triggerEvent("Selected", contactsSelection2.getSelected());
        }, 0);
	},
	// leave
	function() {
		if(contactsCardsRequest) {
		  OXCache.unregister(contactsCardsRequest.uniqueName);
		  contactsCardsRequest=null;
        }
        if(contactsCardsRequest2) {
          OXCache.unregister(contactsCardsRequest2.uniqueName);
          contactsCardsRequest2=null;
        }
		objContactFunctions.resetContactCardCache();
		unregister("OX_New_Search",searchContactByString);
		unregister("OX_Delete_Search",deleteSearchContactByString);
		viewContactsBySearch.searchstring = "";
		contactsFolderPath.clear();
		triggerEvent('OX_Delete_Search');
		if(configGetKey("gui.contacts.cardsToViewPerColumn") == "auto") {
			resizeEvents.unregister("Resized",showContactCards);
			removeDOMEvent(scrollerCbar, "scroll", scrollCardView);
		}
		myLetterContactTab.unregisterTab();
	},
	// hide
	function() {
		hideNode("contactCards");
		if(objContactFunctions.refHover)
			objContactFunctions.refHover.disable();
	},
	function() {
	    triggerEvent('OX_Delete_Search');
		contactsSelection2.reset();
		objContactFunctions.resetContactCardCache();
		scrollerCbar.scrollLeft = 0;
		myLetterContactTab.buildTab("cardContactsLetterDiv");
		showContactCards();
	}
);
registerView("contacts/detail",
	function() {
        // hide tab if property is set
        if ((ox.upsell.isVisible("infostore") && ox.upsell.isVisible("contacts-attachments")) === false) {
            $("panelContactDetail2").style.display = "none";
        }
		showNode("contactDetails");
		if(!objRoutingPlanner.active) {
			$("combo_private_address_mapIcon").style.display = "none";
			$("combo_business_address_mapIcon").style.display = "none";
		}
	},
	function() {
        register("OX_New_Search", contactsDetailSearch);
		register("OX_Refresh",reloadContactDetailView);
		showContactDetail();
	},
	function() {
		if(tmpDetailRequest) {
            OXCache.unregister(tmpDetailRequest.uniqueName);
            tmpDetailRequest=null;
        }
		closeMapsDivs();
		unregister("OX_Refresh",reloadContactDetailView);
        unregister("OX_New_Search", contactsDetailSearch);
	},
	function() {
	    triggerEvent('OX_Delete_Search');
		objContactFunctions.loadingContactDetail(false);
		objContactFunctions.clearDetailFields();
		hideNode("contactDetails");
		unregister("OX_Print",contacts_printDetail);
		if(oDistributionLiveGrid.dlGrid && oDistributionLiveGrid.dlGrid.storage) {
			oDistributionLiveGrid.dlGrid.disable();
		}
	}
);
registerView("contacts/detail/overview",
	function() {
		if(isADistributionList) {
			$("tabContactDetail0").style.display="block";
			$("panelContactDetail0").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";
		} else {
			$("tabContactDetail1").style.display="block";
			$("panelContactDetail1").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";
		}

	},
	null,
	null,
	function() {
		if(isADistributionList) {
			$("tabContactDetail0").style.display="none";
			$("panelContactDetail0").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";
		} else {
			$("tabContactDetail1").style.display="none";
			$("panelContactDetail1").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";
		}
	}
);
registerView("contacts/detail/attachment",
	function() {
		$("tabContactDetail2").style.display="block";
		$("panelContactDetail2").className="tabPanelHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";
	},
	function() {
		if(!bAttachmentGridCreatedContact)
		{
			createAttachmentGridContact();
			bAttachmentGridCreatedContact = true;
            ox.ToolBarController.processSelection("attachments", false,
                [], true);
		}
		else
		{
			oAttachmentGridContact.enableGrid();
            ox.ToolBarController.processSelection("attachments", false,
                oAttachmentGridContact.liveGrid.selection.getSelected(), true);
		}
		oAttachmentGridContact.getAttachments(contactDetailId,activefolder);
	},
	function() {
		if(bAttachmentGridCreatedContact) {
			oAttachmentGridContact.disableGrid();
			triggerEvent("SubSelected",[]);
		}
	},
	function() {
		$("tabContactDetail2").style.display="none";
		$("panelContactDetail2").className="tabPanel tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";
	}

);


function contacts_printList() {
	globalprint.printLiveGrid(contactGrid);
}

function contacts_printDetail() {
	var dP;
	if (isADistributionList) {
		dP = new Print("");
		dP.printLiveGrid(oDistributionLiveGrid.dlGrid, true);
	} else {
		objContactCardFunctions.printView();
		var title = aPrintDetailContact[0] && aPrintDetailContact[0].title ? aPrintDetailContact[0].title : "";
		dP = new Print(title);
		dP.printDetail(aPrintDetailContact);
	}
}


var bAttachmentGridCreatedContact = false;
function createAttachmentGridContact()
{
	var nId = contactDetailId;
	var nFolder = activefolder;
	oAttachmentGridContact = new attachmentGrid("contact_d_Attachments",nId,nFolder,7);
    triggerEvent("OX_Contacts_AttachmentGrid_Ready",oAttachmentGridContact);
}

function reloadContactDetailView() {
	setTimeout(
		function() {
			objContactFunctions.resetContactCardCache();
			showContactDetail(null);
		},200
	);
}

registerModule("contacts", _("Contacts"), 40);
registerModuleView("contacts", "Contacts", 5 , { x:2, y:1 });

register("OX_Contact_Edit", editContact);
register("OX_Contact_Duplicate", duplicateContact);



/********************************** Change Module *****************************************************************/



function ContactFunctions() {
	this.timestamp = lastUpdateOfContactsTimestamp;
	this.idsContactForSelected = new Array();
	this.lastView = "cards";
	this.currentContactTagProgress = false;
}

ContactFunctions.prototype = {
	contactAddTag: function(tag) {
		var Self = this;
		objContactFunctions.resetContactCardCache();
		this.getIDs();
		var obj = contactsSelection2.getSelected();
		if (currentpath[1] == "detail" && objContactCardFunctions) {
		  obj[0]["timestamp"] = objContactCardFunctions.currentDatailContactData.timestamp;
		}
		contact_tag_object.color_label = tag;
		OXContactMapping.setTag(tag, obj);
	},

	getCurrentSelection: function (cb) {

	    var collection = { objects: [], columns: ["display_name", "last_name", "distribution_list"] };

	    // trying to get selected object(s) out of various selections! crank!!
        if (contactsSelection2 && contactsSelection2.getSelected().length) {
            collection.objects = contactsSelection2.getSelected();
        } else if (contactGrid && contactGrid.selection.getSelected().length) {
            collection.objects = contactGrid.selection.getSelected();
        } else {
            collection.objects = [ OXContactMapping.createKeyFromObject(
                { "module" : "contacts" ,"folder_id" : contactDetailFolder, id : contactDetailId }
            )];
        }

        OXCache.newRequest(null, "contacts", collection, null, function (daten) {
            if (daten.objects.length) {
                ox.call(cb, daten.objects);
            }
        });
	},

	sendMail: function () {

	    this.getCurrentSelection(function (selection) {

	        var tmp = [], i = 0, $i = selection.length, j, $j, obj, list, mail;

	        function add(name, email) {
	            if (email) {
	                tmp.push([typeof name === 'string' ? '"' + name.replace(/"/g, '\\"') + '"' : undefined, email]);
	            }
	        }

	        for (; i < $i; i++) {
	            obj = selection[i];
	            // is list?
	            if ((list = obj.distribution_list)) {
	                for (j = 0, $j = list.length; j < $j; j++) {
	                    add(list[j].display_name, list[j].mail);
	                }
	            } else if ((mail = obj.email1 || obj.email2 || obj.email3)) {
	                add(obj.display_name, mail);
	            }
	        }

	        // open "new email" window
            ox.api.mail.compose({
                data: { to: tmp }
            });
	    });
	},

	sendAsVCard: function () {

	    this.getCurrentSelection(function (selection) {
            // collect contacts
            var contacts = [], i = 0, item;
            for (; i < selection.length; i++) {
                item = selection[i];
                // add contact as vCard
                contacts.push({
                    "objectType": "vCard",
                    "data": {
                        "args": [{"com.openexchange.groupware.contact.pairs": [{"folder": item.folder_id, "id": item.id}]}],
                        "identifier": "com.openexchange.contact"
                    },
                    "compositeID": { "folder": item.folder_id, "id": item.id },
                    "name": item.display_name || item.last_name || item.first_name || "contact"
                });
            }
            // open "new email" window
            ox.api.mail.compose({
            	data: {
            		attachedObjects: contacts
            	}
            });
        });
	},

	deleteContacts: function() {
		var selection=contactsSelection2.getSelected();

		function cbyes() {
		    OXContactMapping.deleteObjects(selection);
			objContactFunctions.resetContactCardCache();
			if (currentpath.join("/").match(/^contacts\/detail/))
			     triggerEvent("OX_Switch_View", configGetKey("gui.contacts.view"));
		}
		this.getIDs();
		var Self = this;
		OXCache.newRequest(null, "contacts",
		    { objects: selection, columns: ["mark_as_distributionlist"] }, null,
            function (data) {
		        var lists = 0, contacts = 0;
		        for (var i = 0; i < data.objects.length; i++) {
		            if (data.objects[i].mark_as_distributionlist) {
		                lists++;
		            } else {
		                contacts++;
		            }
		        }
		        var title = contacts ?
		            ngettext("Delete contact", "Delete contacts", contacts) :
	                ngettext("Delete distribution list",
	                         "Delete distribution lists", lists);
	            var msg = contacts && lists ?
                    _("Are you sure you want to delete the selected items?") :
                    contacts ?
                    ngettext("Are you sure you want to delete the selected contact?",
                             "Are you sure you want to delete the selected contacts?",
                             contacts) :
                    ngettext("Are you sure you want to delete the selected distribution list?",
                             "Are you sure you want to delete the selected distribution lists?",
                             lists);
                newConfirm(title, msg, AlertPopup.YESNO, null, null, cbyes,
                           null);
            });
	},
    getStorageCache : function(pattern, fullsearch) {
        if (this.searchHack) {
            pattern = this.searchHack.pattern;
            fullsearch = this.searchHack.fullsearch;
            this.searchHack = null;
        }
		var Self = this;
		var criteria= { "folder_id" : activefolder };
        var lang = ox.api.config.get("language").substring(0, 3);
        if (lang == "zh_") criteria.collation = "gbk";
		var search;
        if(pattern !== undefined) viewContactsBySearch.searchstring = pattern;
        if(fullsearch) {
            viewContactsBySearch.fullSearch = fullsearch;
            if(viewContactsBySearch.oldLetterDiv) {
                viewContactsBySearch.oldLetterDiv.className = "div_letter_single";
            }
        } else {
            viewContactsBySearch.fullSearch = false;
        }
        if (pattern) {
        //SEARCH
             search=new Object();
            //Lettersearch
            if(!fullsearch) {
                var myPattern;
                if(pattern == "#") { myPattern = "#"; }
                else if(pattern == "123") { myPattern = 1; }
                else { myPattern = pattern; }
                if (typeof pattern == "object") {
                    search.advancedSearch = pattern;
                    delete criteria.folder_id;
                } else {
                    search.startletter = true;
                    search.last_name = myPattern;
                }
            } else {
                var checked = ox.widgets.searchField.active().searchMenu.checked;
                for (var i in checked) if (checked[i]) search[i] = pattern;
                if (configGetKey("language") == "ja_JP") {
                    if (checked.first_name) search.yomiFirstName = pattern;
                    if (checked.last_name) search.yomiLastName = pattern;
                    if (checked.company) search.yomiCompany = pattern;
                }
                search.operator = "or";
            }
        }
		if(currentpath2[1]=="phonelist") {
			contactGrid.disablehover=!configGetKey("gui.effects.hover.contacts");
	        contactGrid.enable(criteria,search,false);
    	} else if(currentpath2[1]=="cards") {
			var collection={}
			collection.criteria = criteria;
			collection.search = search;
			collection.columns = ["mark_as_distributionlist"];
			var sort = lang == "zh_" || lang == "ja_" ? "last_name" : "sort";
            collection.order = [{ sort: sort, order: "asc" }];
			if(contactsCardsRequest2) {
                OXCache.unregister(contactsCardsRequest2.uniqueName);
                contactsCardsRequest2=null;
            }
            contactsCardsRequest2=OXCache.newRequest(null,"contacts",collection,
                displayCards, displayCards, false);
		}
        function displayCards(collection) {
            objContactFunctions.resetContactCardCache();
            contactsSelection2.setCollection(collection,contactsSelection2.getSelected().length ? undefined : 0);
            objContactFunctions.lastView = "cards";
            var widthN;
            window.setTimeout(function() {
                countContactCards = collection.objects.length;
                var height = (61 - $("contactCardScrollerdiv").offsetHeight) + "px";
                widthN = Math.ceil(countContactCards/cardsPerRowToView) * $("column_1").offsetWidth;
                if(widthN > 3) {
                    widthN = widthN -3; /* -3 is a IE7 fix with scrollbars*/
                }
                $("contactCardScrollerdiv").style.width = widthN + "px";
            })
            if(contactGrid && contactGrid.focus) {
                scrollerCbar.scrollLeft = ($("contactCardTable").clientWidth/4) * Math.floor(contactGrid.focus/cardsPerRowToView);
            } else { scrollerCbar.scrollLeft = 0; }
            scrollCardView();
            contact_HeaderUpdate(collection);
        }
	},
	renderWidthScrollbarDiv : function() {
		countContactCards = contactsSelection2.collection.objects.length;
		//var width = Math.ceil(countContactCards/cardsPerRowToView) * 25 + "%";
		var width = Math.ceil(countContactCards/cardsPerRowToView) * $("column_1").offsetWidth - 3 + "px"; /* -3 is a IE7 fix with scrollbars*/
		$("contactCardScrollerdiv").style.width = width;
	},
	getIDs : function() {
		objContactFunctions.idsContactForSelected = contactsSelection2.getSelected();
	},
	resetContactCardCache : function() {
		oldTopCardIndex = -1;
		objContactFunctions.contactCardDivs = [];
	},
	clearDetailFields : function() {
		removeChildNodes($("cont_detail_bot"));
		if ($("note")) removeChildNodes($("note"));

		for (idDetailFieldsToClear in objContactFunctions.detailFieldsToClear) {
			if ($(idDetailFieldsToClear).firstChild) {
				$(idDetailFieldsToClear).firstChild.data = " ";
			}
		}

		objContactFunctions.detailFieldsToClear = {};
	},
	loadingContactDetail : function(loading) {
		if(loading) {
			if(IE6) {
				var tmpWidth = $("contactDetailProcessDiv").parentNode.offsetWidth + "px";
				var tmpHight = $("contactDetailProcessDiv").parentNode.offsetHeight + "px";
				$("contactDetailProcessDiv").style.width = tmpWidth;
				$("contactDetailProcessDiv").style.height = tmpHight;
				$("contactDetailProcessDivAnimation").style.width = tmpWidth;
				$("contactDetailProcessDivAnimation").style.height = tmpHight;
			}
			$("contactDetailProcessDiv").style.display = "block";
			$("contactDetailProcessDivAnimation").style.display = "block";
		} else {
			$("contactDetailProcessDiv").style.display = "none";
			$("contactDetailProcessDivAnimation").style.display = "none";
		}
	},
	contactErrorHandler : function(result, status) {
		objContactFunctions.loadingContactDetail(false);
		triggerEvent("OX_New_Error",formatError(result));
	}
}
var objContactFunctions = new ContactFunctions();
objContactFunctions.contactCardDivs = new Array();
objContactFunctions.contactCardDivsHeader = new Array();
objContactFunctions.detailFieldsToClear = {};
objContactFunctions.contacthovercontent = null;
objContactFunctions.contactslider = null;
objContactFunctions.refHover = null;

function ContactCardFunctions() {
	this.currentDatailContactData = null;
}
ContactCardFunctions.prototype = {

	selectCard : function(cardDiv_n) {
		objCardDiv = objContactFunctions.contactCardDivs[cardDiv_n];//document.getElementById("card_" + cardDiv_n);
		if (objCardDiv) {
			contactDetailId = selectedObjCard[objCardDiv.id];
			if (objCardDiv) {
				objCardDiv.className = "cardDivMainHi border-color-PMG-selection-elements";
			}

			if (objContactFunctions.contactCardDivsHeader[cardDiv_n]) {
				objContactFunctions.contactCardDivsHeader[cardDiv_n].className = "cardDisplayNameHi border-color-PMG-selection-elements background-color-PMG-selection-elements";
				for (var i=0; i<objContactFunctions.contactCardDivsHeader[cardDiv_n].childNodes.length; i++) {
					if (objContactFunctions.contactCardDivsHeader[cardDiv_n].childNodes[i].id == "card_icons_0x") {
						objContactFunctions.contactCardDivsHeader[cardDiv_n].childNodes[i].className = "rightcarddiv background-color-PMG-selection-elements";
					}
				}
			}
		}
	},

	deSelectCard : function(cardDiv_n) {
		objCardDiv = objContactFunctions.contactCardDivs[cardDiv_n];//document.getElementById("card_" + cardDiv_n);
		if (objCardDiv) {
			if (objCardDiv) {
				objCardDiv.className = "cardDivMain border-color-content-default";
			}

			if (objContactFunctions.contactCardDivsHeader[cardDiv_n]) {
				objContactFunctions.contactCardDivsHeader[cardDiv_n].className = "cardDisplayName background-color-additional-content border-background-default";
				for (var i=0; i<objContactFunctions.contactCardDivsHeader[cardDiv_n].childNodes.length; i++) {
                    if (objContactFunctions.contactCardDivsHeader[cardDiv_n].childNodes[i].id == "card_icons_0x") {
                        objContactFunctions.contactCardDivsHeader[cardDiv_n].childNodes[i].className = "rightcarddiv background-color-additional-content";
                    }
                }
			}
		}
	},

	updateCardStyle : function(strgButton)
	{
		if(contactsSelection2.count == 0 && !strgButton) return;
		for (var i = 0, n = topCardIndex; i < cardsToView; i++, n++)
		{
			if (n >= contactsSelection2.collection.objects.length) break;
			contactsSelection2.get(n)? this.selectCard(n) : this.deSelectCard(n);
		}
	},
	printView: function() {
		aPrintDetailContact = [];

		var contactData = this.currentDatailContactData;

		aPrintDetailContact.push(Print.createTitle(contactData.display_name));
		aPrintDetailContact.push(Print.createLine("5px"));
		aPrintDetailContact.push(Print.createEmpty(true));

		if(contactData.title)
		aPrintDetailContact.push(Print.createContent(pgettext("salutation", "Title:"),contactData.title));

		if(contactData.first_name)
		aPrintDetailContact.push(Print.createContent(_("First name:"),contactData.first_name));

		if(contactData.second_name)
		aPrintDetailContact.push(Print.createContent(_("Middle name:"),contactData.second_name));

		if(contactData.suffix)
		aPrintDetailContact.push(Print.createContent(_("Suffix:"),contactData.suffix));

		if(contactData.last_name)
		aPrintDetailContact.push(Print.createContent(_("Last name:"),contactData.last_name));

		if(contactData.telephone_business1)
		aPrintDetailContact.push(Print.createContent(_("Phone:"),contactData.telephone_business1));

		if(contactData.telephone_business2)
		aPrintDetailContact.push(Print.createContent(_("Phone 2:"),contactData.telephone_business2));

		if(contactData.fax_business)
		aPrintDetailContact.push(Print.createContent(_("Fax:"),contactData.fax_business));

		if(contactData.telephone_company)
		aPrintDetailContact.push(Print.createContent(_("Phone (company):"),contactData.telephone_company));

		if(contactData.cellular_telephone1)
		aPrintDetailContact.push(Print.createContent(_("Cell phone:"),contactData.cellular_telephone1));

		if(contactData.email1)
		aPrintDetailContact.push(Print.createContent(_("E-Mail:"),contactData.email1));

		if(contactData.company)
		aPrintDetailContact.push(Print.createContent(_("Company:"),contactData.company));

		if(contactData.street_business)
		aPrintDetailContact.push(Print.createContent(_("Street:"),contactData.street_business));

		if(contactData.postal_code_business)
		aPrintDetailContact.push(Print.createContent(_("ZIP:"),contactData.postal_code_business));

		if(contactData.city_business)
		aPrintDetailContact.push(Print.createContent(_("City:"),contactData.city_business));

		if(contactData.state_business)
		aPrintDetailContact.push(Print.createContent(_("State:"),contactData.state_business));

		if(contactData.country_business)
		aPrintDetailContact.push(Print.createContent(_("Country:"),contactData.country_business));

		if(contactData.department)
		aPrintDetailContact.push(Print.createContent(_("Department:"),contactData.department));

		if(contactData.position)
		aPrintDetailContact.push(Print.createContent(_("Position:"),contactData.position));

		if(contactData.employee_type)
		aPrintDetailContact.push(Print.createContent(_("Job position:"),contactData.employee_type));

		if(contactData.room_number)
		aPrintDetailContact.push(Print.createContent(_("Room number:"),contactData.room_number));

		if(contactData.number_of_employees)
		aPrintDetailContact.push(Print.createContent(_("Employee ID:"),contactData.number_of_employees));

		if(contactData.url)
		aPrintDetailContact.push(Print.createContent(_("URL:"),contactData.url));

		if(contactData.instant_messenger1)
		aPrintDetailContact.push(Print.createContent(_("Instant Messenger:"),contactData.instant_messenger1));


		/* Tab Personal */

		aPrintDetailContact.push(Print.createEmpty());
		aPrintDetailContact.push(Print.createHeader(_("Private:")));

		if(contactData.nickname)
		aPrintDetailContact.push(Print.createContent(_("Nickname:"),contactData.nickname));

		if(contactData.spouse_name)
		aPrintDetailContact.push(Print.createContent(_("Spouse's name:"),contactData.spouse_name));

		if(contactData.profession)
		aPrintDetailContact.push(Print.createContent(_("Profession:"),contactData.profession));

		if(contactData.birthday)
		aPrintDetailContact.push(Print.createContent(_("Date of birth:"),formatDate(contactData.birthday, "date")));

		if(contactData.telephone_home1)
		aPrintDetailContact.push(Print.createContent(_("Phone (private):"),contactData.telephone_home1));

		if(contactData.telephone_home2)
		aPrintDetailContact.push(Print.createContent(_("Phone (private 2):"),contactData.telephone_home2));

		if(contactData.fax_home)
		aPrintDetailContact.push(Print.createContent(_("Fax (private):"),contactData.fax_home));

		if(contactData.cellular_telephone2)
		aPrintDetailContact.push(Print.createContent(_("Cell phone (private):"),contactData.cellular_telephone2));

		if(contactData.telephone_ip)
		aPrintDetailContact.push(Print.createContent(_("IP phone (private):"),contactData.telephone_ip));

		if(contactData.email2)
		aPrintDetailContact.push(Print.createContent(_("E-Mail (private):"),contactData.email2));

		if(contactData.telephone_pager)
		aPrintDetailContact.push(Print.createContent(_("Pager:"),contactData.telephone_pager));

		if(contactData.street_home)
		aPrintDetailContact.push(Print.createContent(_("Street:"),contactData.street_home));

		if(contactData.postal_code_home)
		aPrintDetailContact.push(Print.createContent(_("ZIP:"),contactData.postal_code_home));

		if(contactData.city_home)
		aPrintDetailContact.push(Print.createContent(_("City:"),contactData.city_home));

		if(contactData.state_home)
		aPrintDetailContact.push(Print.createContent(_("State:"),contactData.state_home));

		if(contactData.country_home)
		aPrintDetailContact.push(Print.createContent(_("Country:"),contactData.country_home));

		if(contactData.marital_status)
		aPrintDetailContact.push(Print.createContent(_("Marital status:"),contactData.marital_status));

		if(contactData.dnumber_of_children)
		aPrintDetailContact.push(Print.createContent(_("Children:"),contactData.number_of_children));

		if(contactData.anniversary)
		aPrintDetailContact.push(Print.createContent(_("Anniversary:"),formatDate(contactData.anniversary, "date")));

		if(contactData.instant_messenger2)
		aPrintDetailContact.push(Print.createContent(_("IM (private):"),contactData.instant_messenger2));

		if(contactData.note)
		aPrintDetailContact.push(Print.createContent(_("Comments:"),contactData.note));



		/* Tab Additional */

		aPrintDetailContact.push(Print.createEmpty());
		aPrintDetailContact.push(Print.createHeader(_("Additional:")));

		if(contactData.street_other)
		aPrintDetailContact.push(Print.createContent(_("Street (other):"),contactData.street_other));

		if(contactData.postal_code_other)
		aPrintDetailContact.push(Print.createContent(_("ZIP:"),contactData.postal_code_other));

		if(contactData.country_other)
		aPrintDetailContact.push(Print.createContent(_("City:"),contactData.country_other));

		if(contactData.state_other)
		aPrintDetailContact.push(Print.createContent(_("State (other):"),contactData.state_other));

		if(contactData.country_other)
		aPrintDetailContact.push(Print.createContent(_("Country (other):"),contactData.country_other));

		if(contactData.telephone_other)
		aPrintDetailContact.push(Print.createContent(_("Phone (other):"),contactData.telephone_other));

		if(contactData.fax_other)
		aPrintDetailContact.push(Print.createContent(_("Fax (other):"),contactData.fax_other));

		if(contactData.email3)
		aPrintDetailContact.push(Print.createContent(_("E-Mail (other):"),contactData.email3));

		if(contactData.telephone_car)
		aPrintDetailContact.push(Print.createContent(_("Phone (car):"),contactData.telephone_car));

		if(contactData.telephone_ttytdd)
		aPrintDetailContact.push(Print.createContent(_("TTY/TDD:"),contactData.telephone_ttytdd));

		if(contactData.sales_volume)
		aPrintDetailContact.push(Print.createContent(_("Sales Volume:"),contactData.sales_volume));

		if(contactData.tax_id)
		aPrintDetailContact.push(Print.createContent(_("TAX ID:"),contactData.tax_id));

		if(contactData.commercial_register)
		aPrintDetailContact.push(Print.createContent(_("Commercial Register:"),contactData.commercial_register));

		if(contactData.branches)
		aPrintDetailContact.push(Print.createContent(_("Branches:"),contactData.branches));

		if(contactData.manager_name)
		aPrintDetailContact.push(Print.createContent(_("Manager:"),contactData.manager_name));

		if(contactData.assistant_name)
		aPrintDetailContact.push(Print.createContent(_("Assistant:"),contactData.assistant_name));

		if(contactData.telephone_telex)
		aPrintDetailContact.push(Print.createContent(_("Telex:"),contactData.telephone_telex));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield01));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield02));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield03));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield04));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield05));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield06));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield07));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield08));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield09));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield10));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield11));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield12));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield13));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield14));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield15));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield16));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield17));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield18));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield19));

		if(contactData.userfield01)
		aPrintDetailContact.push(Print.createContent(_("Optional Fields:"),contactData.userfield20));

		if(contactData.contains_image1 && contactData.contains_image1 > 0) {
			aPrintDetailContact.push(Print.createPicture($('imageContactDetailTd').firstChild.src));
		}
		else {
			aPrintDetailContact.push(Print.createPicture(getFullImgSrc("img/contacts/dummypicture.gif")));
		}
	},
	getHeadline : function(data) {
		if(!data) return "";
        var firstname = trimStr(data.first_name);
        var lastname = trimStr(data.last_name);
        if (lastname.length !== 0) {
            if (firstname.length !== 0) {
                //#. Format string for the 'lastname, firstname' display name default
                //#. %1$s is the first name
                //#. %2$s is the last name
                //#, c-format
                return format(_("%2$s, %1$s"), firstname, lastname);
            } else {
                return lastname;
            }
        } else {
            return trimStr(data.display_name)
                || trimStr(data.company) || trimStr(data.email1)
                || trimStr(data.email2);
        }
	}
}

var objContactCardFunctions = new ContactCardFunctions();

register("OX_Contact_Delete", function () {
    objContactFunctions.deleteContacts();
});

register("OX_Contact_SendMail", function () {
    objContactFunctions.sendMail();
});

register("OX_Contact_SendVCard", function () {
    objContactFunctions.sendAsVCard();
});

/**
 * global vars
 */
var contactGrid = null;
var contactDetailId = "";
var lastUpdateOfContactsTimestamp = "";
var contact_tag_object = {};
var contactCardStorage = null;


/********************************** Contact Cards *****************************************************************/

/**
 * global vars for Card view
 */
var currentCardId = 0;
var contactCardRowId = 1;
var cbContainers = new Array();
var selectedObjCard = new Array();
var currentColumnToWrite = null;
var countContactCards = 0;
var contacCardWidth = "";
var scrollerCbar = "";
var countColumnCardstoView = 0;
var topCardIndex = 0;
var oldTopCardIndex = -1;
var activeCardIdHead = 0;
var firstViewOfContactGrid = 1;
var indexofContact = 0;
var cardsToView;
var cardsPerRowToView;
var isDistributionListSelected = 0;
var detailDistrListAdressBook = null;
var isADistributionList = false;
var aRegisteredCards = new Array();

/**
 * Events triggered by the contact view.
 * <dl><dt>Activated</dt><dd>One or more elements have been activated.
 * Parameters:
 * <ul><li>Array with object IDs of activated objects.</li></ul></dd>
 * <dt>Selected</dt><dd>The selection has changed. Parameters:
 * <ul><li>Number of selected elements.</li></ul></dd>
 * </dl>
 */
var cardEvents = new Events();

var cardsObject = {};

contactsSelection2.events.register("Selected", function(selectedCards) {
    triggerEvent('Selected', contactsSelection2.getSelected());
    setStatusDLSelection();
});

cardEvents.register("Activated", function(ids) {
		if(ids && ids.length > 0) {
			if(menuhasRight(ids,"WRITE")) {
				editContact();
			} else {
				triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
			}
		} else {
			objContactFunctions.resetContactCardCache();
			triggerEvent("OX_Before_Create_Contact");
		}
	}
);

cardEvents.register("Delete", function(ids){
		if(menucheckRight("DELETE"))
			objContactFunctions.deleteContacts();
		else
			triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
	});

/**
 * init function from the card view
 * get the date and call the function writeCards()
 */
function showContactCards()
{
	cardsPerRowToView = configGetKey("gui.contacts.cardsToViewPerColumn");

	$("cardtmpl").style.display = "";
	if(cardsPerRowToView == "auto") {
		cardsPerRowToView = Math.floor($('contactCardTable').offsetHeight / ($("cardtmpl").offsetHeight+2));
		$('tablecontactscards').style.height = (($("cardtmpl").offsetHeight+2) * cardsPerRowToView) + "px";
		if(cardsPerRowToView == 0) cardsPerRowToView = 1;
	}
	$("cardtmpl").style.display = "none";

	cardsToView = cardsPerRowToView*4, pattern = undefined;
	if (contactsSearchObject !== null) {
	    pattern = contactsSearchObject.pattern;
	}
    objContactFunctions.getStorageCache(pattern, pattern !== undefined ? true : undefined,
        ox.api.config.get("language").substring(0, 3) == "zh_" ? "gbk" : "");

	scrollerCbar = $("contactCardScrollerbar");

	addDOMEvent(scrollerCbar, "scroll", scrollCardView);

	// works under mac ox lion as well:
	jQuery('#contactCardTable').bind('mousewheel DOMMouseScroll', fnWheel)
	    .get(0).onselectstart = function () { return false; };
}

var scrollingProgress = false;

function scrollCardView(e)
{
	if(scrollingProgress) return;
	scrollingProgress = true;
	var columnCards1 = $("column_1");
	var columnCards2 = $("column_2");
	var columnCards3 = $("column_3");
	var columnCards4 = $("column_4");

	contacCardWidth = columnCards1.offsetWidth;
	if(!scrollerCbar.scrollLeft)
		topCardIndex = 0
	else
		topCardIndex = Math.max(0, Math.min(Math.ceil(countContactCards / cardsPerRowToView),
				                            Math.ceil(scrollerCbar.scrollLeft / contacCardWidth)
										   )
							    ) * cardsPerRowToView;

	countColumnCardstoView = 0;
	if(oldTopCardIndex==topCardIndex) {
		scrollingProgress = false;
		return;
	}
	oldTopCardIndex = topCardIndex;

	var aCardContent = new Array();
	var aColumnContent = new Array();

	var collection={};
	collection.objects=contactsSelection2.collection.objects.slice(topCardIndex,topCardIndex + cardsToView);
	collection.columns=["display_name", "first_name", "last_name","title",
        "street_business", "postal_code_business", "city_business",
        "state_business", "telephone_business1", "email1","color_label",
        "mark_as_distributionlist", "distribution_list", "private_flag",
        "cellular_telephone1", "cellular_telephone2", "telephone_business2",
        "telephone_company", "telephone_home1", "telephone_home2", "email2", "company"];
	OXCache.newRequest(null,"contacts",collection,
	null,function cb(data) {
		removeChildNodes(columnCards1);
        removeChildNodes(columnCards2);
        removeChildNodes(columnCards3);
        removeChildNodes(columnCards4);
        scrollingProgress = false;
        for(var i=0;i<data.objects.length;i++) {
           var objIndex=contactsSelection2.collection.map_objects.get(data.objects[i]);
           var index =objIndex-topCardIndex-1;
           aCardContent[index] = data.objects[i];
           aColumnContent[index] = currentColumnToWrite;
           countColumnCardstoView++;
           indexofContact++;
        }
        for (var j=0; j<aCardContent.length; j++) {
            if(j < cardsPerRowToView) { currentColumnToWrite = columnCards1; }
            else if(j < (cardsPerRowToView*2)) { currentColumnToWrite = columnCards2; }
            else if(j < (cardsPerRowToView*3)) { currentColumnToWrite = columnCards3; }
            else if(j < (cardsPerRowToView*4)) { currentColumnToWrite = columnCards4; }
            else { currentColumnToWrite = ""; }
            writeCards(j+topCardIndex, currentColumnToWrite, aCardContent[j]);
        }
        if (objContactCardFunctions) {
        	objContactCardFunctions.updateCardStyle();
        }
        // now fire event
        triggerEvent("Selected", contactsSelection2.getSelected());
    });
	return;
}


/**
 * Genarate a Contactrow for a Card
 * @param {id} element id from template
 * @param {String} label of the contact
 * @param {String} value of the contact
 * @param {int} currentCardId
 */
function cloneContactNodeById(origId, contactvalue,currentCardId, imgSrc)
{
	var cloneObj = $(origId).cloneNode(true);
	cloneObj.style.display = "block";
	newId =  'contact_'+ currentCardId+"_"+contactCardRowId;
	cloneObj.id = newId;
	contactCardRowId++;

	if(imgSrc) {
		cloneObj.appendChild(newnode("img", 0, {src: imgSrc,align:"absmiddle"}));
	}

	cloneObj.appendChild(newnode("span", 0, 0, [document.createTextNode((imgSrc) ? "\xa0"+contactvalue : contactvalue)]));

	return cloneObj;
}

function addressForCard(oDiv, daten)
{
	var sAddress = "";
	var sAddressLine2 = "";
	function get(name) {
	    return daten[name] && daten[name] != "null" ? daten[name] : "";
	}
    //#. Address format for 2 line display (card view).
	//#.
    //#. DO NOT TRANSLATE THE FIELD NAMES!
	//#.
	//#. Only change the order and punctuation.
    //#. \n separates multiple lines. Other punctuation appears as-is.
	//#. Available fields are: street, postal_code, city, state, country
    var format = String(_("street\npostal_code city")).replace(
        /([a-z_]+)([^a-z_]*)/g,
        function(match, key, rest) {
            var value = daten[key + "_business"];
            if (value && value != "null") return value + rest;
            return "";
        });
    var lines = format.split("\n"),
        i = 0, $i = lines.length, line;
    for (; i < $i; i++) {
        if ((line = lines[i])) {
            // remove tailing punctuation (cp. bug #17995)
            line = line.replace(/[,]\s*$/, "");
            oDiv.appendChild(newnode("div", 0, 0, [newtext(line)]));
        }
    }
}

function clearCardHoverFields() {
	removeChildNodes($("contactHovertmpl"));
	removeChildNodes($("contactHovertmpl2"));
	
	// unregister (dom) events
	for (var i in OXContactHover.references.events) {
	    var evt = OXContactHover.references.events[i];
	    if (evt[0] !== null) {
	        removeDOMEvent(evt[0], evt[1], evt[2]);
	        OXContactHover.references.events[i] = undefined;
	    }
	    evt = null;
	}
	OXContactHover.references.events = [];
}

register("Loaded",function() {
	contactsFolderPath = new FolderPath("contacts");

    // bind events
    // bind double click to open new contact window - only register once!
    jQuery($("contactsCard_main_content")).bind("dblclick", function (e) {
        triggerEvent('OX_Before_Create_Contact');
        return false;
    });
    // stop double click on scrollbars
    jQuery([ $("cardContactsLetterDiv"), $("contactCardScrollerbar") ]).bind("dblclick", function (e) {
        return false;
    });
});


function writeCards(currentCardId, columnForDisplyCards, oCurrentContent)
{
	//clone objekt, set visible and get Data
	if(!objContactFunctions.contactCardDivs[currentCardId]) {
		var cardtmpl = $("cardtmpl");
		var div = objContactFunctions.contactCardDivs[currentCardId] = cardtmpl.cloneNode(true);

		//set the new generated id
		newId = "card_"+currentCardId;
		div.id = newId;
		div.style.display = "block";

		var Self = cardsObject;

        function ctxtMenuHandler(i) {
            return function(e) {
                stopEvent(e);
                globalContextMenus.contacts.display(e.clientX, e.clientY,
                                                    contactsSelection2);
            };
        }

        var clickprocessed = false;

        function mouseDownHandler(i) {
            return function(e) {
                clickprocessed = false;
                if (!contactsSelection2.get(i)) {
                    clickprocessed = true;
                    contactsSelection2.click(i, e);
                    setStatusDLSelection();
                    objContactCardFunctions.updateCardStyle(Mac ? e.metaKey
                                                                : e.ctrlKey);
                }
            };
        }

		function mouseClickHandler(i) {
			return function(e) {
                if (clickprocessed) return;
                contactsSelection2.click(i, e);
                setStatusDLSelection();
                objContactCardFunctions.updateCardStyle(Mac ? e.metaKey
                                                            : e.ctrlKey);
                stopEvent(e);
			};
		}

		function dblClickCardHandler (e) {
			Self.focus = e.data;
			cardEvents.trigger("Activated", contactsSelection2.getSelected());
			return false;
		}

		var keydown = false;
		function keyHandler(e) {
			if (keydown)
				keydown = false;
			else
				return keyHandlerImpl(e);
		}
		function keyHandlerDown(e) {
			keydown = true;
			return keyHandlerImpl(e);
		}


		function keyHandlerImpl(e) {
			switch (e.keyCode || e.which) {
				case 13:  // enter
					cardEvents.trigger("Activated", contactsSelection2.getSelected());
					break;
				case 108: // numpad delete
					cardEvents.trigger("Delete", contactsSelection2.getSelected());
					break;
			}
			stopEvent(e);
			return false;
		}

		var data = oCurrentContent;
		if (!data) return;
		selectedObjCard[newId] = data.id;

		var nameHeadline = objContactCardFunctions.getHeadline(data);

        var child = getElement(div.firstChild);
		newId = 'displayname_'+ currentCardId;
		child.id = newId;
		objContactFunctions.contactCardDivsHeader[currentCardId] = child;
        child.appendChild(newnode("img", 0, {
            src: getFullImgSrc(data.mark_as_distributionlist
                ? "img/menu/distributionlist.gif"
                : "img/folder/contacts.gif"),
            className: "cardHeaderContactTypeIcons",
            align: "absmiddle"
        }));
        newId = 'displayname_label_'+ currentCardId;
        child.id = newId;
        // "\u00a0" = non-breaking space; fixed missing names in safari
        child.appendChild(document.createTextNode("\u00a0" + nameHeadline));

        var grandchild = getElement(child.firstChild);
        if (data.color_label) {
            grandchild.appendChild(newnode("img", 0, {
                src: getFullImgSrc("img/menu/tag_"+ data.color_label +".gif"),
                className: "cardHeaderIcons",
                align: "absmiddle"
            }));
        }
        if (data.private_flag) {
            grandchild.appendChild(newnode("img", 0, {
                src: getFullImgSrc("img/private_flag.gif"),
                className: "cardHeaderIcons",
                align: "absmiddle"
            }));
        }

        child = getElement(child.nextSibling);
		newId = 'address_'+ currentCardId;
		child.id = newId;
		addressForCard(child, data);

		//if there is a communication object append it

        var phone = trimStr(data.telephone_business1)
                 || trimStr(data.cellular_telephone1)
                 || trimStr(data.telephone_business2)
                 || trimStr(data.telephone_company)
                 || trimStr(data.telephone_home1)
                 || trimStr(data.cellular_telephone2)
                 || trimStr(data.telephone_home2);
        if (phone) {
            var contactObj = cloneContactNodeById("contact_0_0x",
                phone, currentCardId);
            div.appendChild(contactObj);
        }

		if (   trimStr(data.first_name) || trimStr(data.last_name)
            || trimStr(data.display_name))
        {
            var email = trimStr(data.email1) || trimStr(data.email2);
            if(email) {
    			var contactObj = cloneContactNodeById("contact_0_0x",
                    email, currentCardId);
    			div.appendChild(contactObj);
    		}
        }

		if (data.distribution_list) {
			for (var t = 0; t < 4 && t < data.distribution_list.length; t++) {
			    if (!data.distribution_list[t].mail) continue;
				var contactObj = cloneContactNodeById("contact_0_0x",
                    (t == 3 && data.distribution_list.length != 4) ? "\xa0\xa0..."
                        : data.distribution_list[t].mail,
                    currentCardId,
                    (t == 3 && data.distribution_list.length != 4) ? false
                        : getFullImgSrc("img/hover/email_kl.gif"));
				div.appendChild(contactObj);
			}
		}

		contactCardRowId = 1;

		function disabled(e) {
			var iconNode=$("cww_node_dd");
			if(iconNode == undefined) {
				iconNode = newnode("img", { position:"absolute", left:(e.clientX + iconOffset)+"px", top:(e.clientY + iconOffset)+"px"},
			    {src: getFullImgSrc("img/dnd_disabled.gif"), alt: ""});
				iconNode.id="cww_node_dd";
				body.appendChild(iconNode);
				addTMPId(iconNode)
			}
			iconNode.style.left = (e.clientX + iconOffset) + "px";
			iconNode.style.top = (e.clientY + iconOffset)+ "px";
			stopEvent(e);
			return false;
		}
		function disabledremove(e) {
			if($2("cww_node_dd")) {
				$2("cww_node_dd").parentNode.removeChild($2("cww_node_dd"));
			}
		}


		registerSource(div, "contacts", function () {
		    // get selection
			var selection = clone(contactsSelection2.getSelected());
			if (selection.length === 1) {
			    selection[0].livegridfield = data.display_name;
			} else if (selection.length === 0) {
			    selection = [{ id: data["id"], folder_id: data.folder_id,
                    livegridfield: data.display_name, module: "contacts" }];
			}

			// get abilities (resides in toolbar controller; should be move to API later)
			var ability = ox.ToolBarController.getAbility(selection);
			// cannot delete?
			if (ability["delete"] === false & ability.unknown !== true) {
			    return false;
			} else {
    			// go!
    			objMoveCopy.begin("contacts", selection);
    			return objMoveCopy;
			}
		}, null, null, contactdefaultdisabled, defaultdisabledremove);

		div.oxcontactobj=data["folder_id"]+"-"+data["id"];
		addDOMEvent(div, "click", mouseClickHandler(currentCardId));
		// bind double click via jQuery (due to bug #14560)
		jQuery(div).bind("dblclick", currentCardId, dblClickCardHandler);
		addDOMEvent(div, "keypress", keyHandler);
		addDOMEvent(div, "keydown", keyHandlerDown);
		addDOMEvent(div, "contextmenu", ctxtMenuHandler(currentCardId));
        addDOMEvent(div, "mousedown", mouseDownHandler(currentCardId));
		if(columnForDisplyCards)
			columnForDisplyCards.appendChild(div);

		// trigger event
		triggerEvent("PAINT_CONTACT", { "view": "card", "number": currentCardId, "contact": oCurrentContent, "node": div });

	} else {
		if(columnForDisplyCards)
		columnForDisplyCards.appendChild(objContactFunctions.contactCardDivs[currentCardId]);
	}
}


function showDetailCard(cardDiv_n)
{
		objCardDiv = $("card_" + cardDiv_n);
		if($(objCardDiv.id))
			$(objCardDiv.id).className = "cardDivMainHi border-color-PMG-selection-elements";

		if($(activeCardIdHead)){
			$(activeCardIdHead).className = "cardDisplayNameHi border-color-PMG-selection-elements background-color-PMG-selection-elements";
		}

		contactDetailId = selectedObjCard[objCardDiv.id];
		activeCardId = objCardDiv.id;
		triggerEvent('OX_Contact_Change_View','DETAIL');
}

/**
 * EventHandler for wheel
*/

function fnWheel(e) {
    if (!e.isDefaultPrevented()) {
        e.preventDefault();
        var a = e;
        if (!e.detail || !e.wheelDelta) {
        	a = e.originalEvent;
        }
        // update scrollbar
        scrollerCbar.scrollLeft += contacCardWidth * (a.wheelDelta >= 0 || a.detail < 0 ? -1 : +1);
        a = null;
    }
}

/********************************** Edit Cards *****************************************************************/

function setStatusDLSelection() {

	isDistributionListSelected = 0;
    if (contactsSelection2 && contactsSelection2.getSelected().length == 1) {
        contactDetailId = contactsSelection2.getSelected()[0]["id"];
        if (OXCache.cachedObjects.get(contactsSelection2.getSelected()[0])["mark_as_distributionlist"]) {
           isDistributionListSelected = 1;
        }
    }
}

function editContact() {

	// can write?
	if(menucheckRight("WRITE")) {
		// have contact?
		if(typeof contactDetailId == 'object') {
			contactDetailId = contactDetailId.id;
		}
		// contact or distribution list?
		if(isDistributionListSelected == 1) {
			// edit as distribution list
			ox.api.contact.editDistributionList({
				params: {
					id: contactDetailId,
					folder: activefolder,
					currentView: objContactFunctions.lastView
				},
				id: {id:contactDetailId, folder: activefolder}
			});
			//openContactPopup("modul=edit&id="+contactDetailId+"&folder="+activefolder+"&session="+session+ "&currentView="+objContactFunctions.lastView, 'newDistributionList.html', {id:contactDetailId, folder: activefolder});
		} else {
			// edit as contact
			ox.api.contact.edit({
				params: {
					id: contactDetailId,
					folder: activefolder,
					currentView: objContactFunctions.lastView
				},
				id: {id:contactDetailId, folder: activefolder}
			});
			//openContactPopup("modul=edit&id="+contactDetailId+"&folder="+activefolder+"&session="+session+ "&currentView="+objContactFunctions.lastView, 'newContact.html', {id:contactDetailId, folder: activefolder});
		}
	} else {
		// no write permission
		triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
	}
}


/********************************** duplicate Cards *****************************************************************/

function duplicateContact()
{
	if(typeof contactDetailId == 'object') {
		contactDetailId = contactDetailId.id;
	}

	// contact or distribution list?
	var fn = isDistributionListSelected == 1 ? ox.api.contact.duplicateDistributionList : ox.api.contact.duplicate;
	// open dialog
	fn({
		params: {
			id: contactDetailId,
			folder: activefolder,
			currentView: objContactFunctions.lastView
		},
		id: {id:contactDetailId, folder: activefolder}
	});
//		openContactPopup("modul=duplicate&id="+contactDetailId+"&folder="+activefolder+"&session="+session+ "&currentView="+objContactFunctions.lastView, 'newDistributionList.html');
//	} else {
//		// open as contract
//		openContactPopup("modul=duplicate&id="+contactDetailId+"&folder="+activefolder+"&session="+session+ "&currentView="+objContactFunctions.lastView, 'newContact.html');
//	}
}

function DistributionLiveGrid() {
	this.oDistrList 		= {};
	this.oDistrList.data 	= new Array();
	this.tmpIdsForSave 		= new Array();
	this.dlStorage = new Storage(0, [],'',0,0,function(x) {return x.folder + "." + x.id; },function(x){return {id:x[0],folder:x[1]};});
	this.dlGrid = null;
	this.oStorageId = {};
	this.tmpId = 1000;
	this.list = null;
}

DistributionLiveGrid.prototype = {
	makeObject : function(dataField) {
		this.oDistrList 		= {};
		this.oDistrList.data 	= [];

		if(dataField) {
			for(i=0; i<dataField.length;i++){
				this.oStorageId.id = this.tmpId;
				this.oStorageId.folder = activefolder;
				this.oDistrList.data[i]    = 	new Array();
				this.oDistrList.data[i][0] =	this.oStorageId; //ID
				this.oDistrList.data[i][1] =	dataField[i].display_name; //DISPLAYNAME
				this.oDistrList.data[i][2] =	dataField[i].mail; //Mail
				this.tmpId++;
			}
		}
	},
	appendToStorage : function() {

		this.dlStorage = new Storage(0, [],'',0,0,function(x) {return x.folder + "." + x.id; },function(x){return {id:x[2],folder:x[1]};});
		this.dlStorage.append(this.oDistrList.data);

		if(!this.dlGrid)
			this.makeBigGrid();
		var Self = this;
		window.setTimeout(
			function() {
				Self.enableDlGrid();
				objContactFunctions.loadingContactDetail(false);
			},0
		);


	},
	makeBigGrid: function() {
		this.list = $("contact_d_DL");
		this.listHeader = $("contact_d_DLHeader");
		if (this.dlGrid)
		{
			removeChildNodes(list);
			this.dlGrid = null;
		}

		this.dlGrid = new LiveGrid([
			{
				text: "Name", /*i18n*/
				sortable: true,
				i18n: true,
				width: "50%",
				set: LiveGrid.defaultSet,
				clear: clearLgridField,
				index:1
			}, {
				text: "E-Mail", /*i18n*/
				sortable: true,
				i18n: true,
				set: LiveGrid.defaultSet,
				clear: clearLgridField,
				index:2
			}
		], new Selection());

		this.listHeader.appendChild(this.dlGrid.getHeader());
		this.dlGrid.getTable(this.list);


	},
	enableDlGrid : function() {
		if(this.dlGrid) this.dlGrid.enable(this.dlStorage);
	}
}

oDistributionLiveGrid = new DistributionLiveGrid();

/********************************** Contact Detail *****************************************************************/
register("OX_Contact_Switch_Detail", function (param) {
	   menuswitchContactDetail(param);
	});

function showContactDetail(cb_function) {
	function showDetailInside(daten) {
		if (cb_function)
		  cb_function();

		objContactCardFunctions.currentDatailContactData = daten;
		// required to force panel changes
		triggerEvent("Selected", [ daten ]);
	   //TODO
		//lastUpdateOfContactsTimestamp = daten.last_modified;
	   $('headDisplayname').firstChild.nodeValue = daten["display_name"] || daten["company"] || _("Detail");
	   $('contact_d_count_attachment').firstChild.nodeValue = daten["number_of_attachments"] || "0";
		$("tagImgContactDetail").src = getFullImgSrc("img/menu/tag_"+(daten["color_label"] || 0) + ".gif");
	   $("privateflagImgContactDetail").src = getFullImgSrc("img/" + (daten.private_flag ? "private_flag" : "dummy") + ".gif");

		writeBottomString(daten,"cont_detail_bot");
	     if (daten["mark_as_distributionlist"]) {
			isADistributionList = true;
			isDistributionListSelected = 1;
			$("panelContactDetail2").style.display="none";
			$("tabContactDetail0").style.display="block";
			$("panelContactDetail0").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";
			$("tabContactDetail1").style.display="none";
			$("panelContactDetail1").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";
			$("panelContactDetail0").style.display="block";
			$("panelContactDetail1").style.display="none";
			oDistributionLiveGrid.makeObject(daten["distribution_list"]);
			oDistributionLiveGrid.appendToStorage();
	     } else {
			var oMyAddresses = new BuildAddresses(daten);
			var myAddresse = {};
			var businessAddrArray = [];
			var privateAddrArray = [];
			var otherAddrArray = [];
			var mapLinks = [];
			businessAddrArray   = oMyAddresses.buildAddress("business");
			privateAddrArray    = oMyAddresses.buildAddress("home");
			otherAddrArray  = oMyAddresses.buildAddress("other");
			myAddresse["addrBusinessDiv"]   = businessAddrArray[0];
			myAddresse["addrPrivateDiv"]    = privateAddrArray[0]
			myAddresse["addrOtherDiv"]  = otherAddrArray[0];
			myAddresse["addrBusinessDiv2"]  = businessAddrArray[1];
			myAddresse["addrPrivateDiv2"]   = privateAddrArray[1]
			myAddresse["addrOtherDiv2"] = otherAddrArray[1];
			mapLinks[0] = businessAddrArray[2];
			mapLinks[1] = privateAddrArray[2];
			mapLinks[2] = otherAddrArray[2];
			isADistributionList = false;
			isDistributionListSelected = 0;
			// show attachments
			// hide tab if property is set
	        if (ox.upsell.isVisible("infostore") && ox.upsell.isVisible("contacts-attachments")) {
	            $("panelContactDetail2").style.display="block";
	        }
			$("tabContactDetail1").style.display="block";
			$("panelContactDetail1").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";
			$("tabContactDetail0").style.display="none";
			$("panelContactDetail0").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";
			$("panelContactDetail1").style.display="block";
			$("panelContactDetail0").style.display="none";
            for (idfield in daten) {
			    if($(idfield) && $(idfield).firstChild && daten[idfield] != null) {
		        	$(idfield).firstChild.data = daten[idfield] || "";
			        /* store here to clear later before new view */
			        objContactFunctions.detailFieldsToClear[idfield] = daten[idfield];
			    }
			    //the same fields are in tab abstract and in tab personal or business
			    if(idfield == "display_name" || idfield == "company" || idfield == "title" || idfield == "department" || idfield == "first_name" || idfield == "second_name" || idfield == "last_name" || idfield == "suffix" || idfield == "position" || idfield == "telephone_business1" || idfield == "email1" || idfield == "telephone_home1" || idfield == "fax_business" || idfield == "fax_home" || idfield == "userfield01")
			    {
			        if($("abstact_"+idfield) && daten[idfield] != null) {
			            $("abstact_"+idfield).firstChild.data = daten[idfield] || "";
			            //store here to clear later before new view
			            objContactFunctions.detailFieldsToClear["abstact_"+idfield] = daten[idfield] || "";
			        }
			    }
			    if (idfield == "note" && daten[idfield]) {
			    	removeChildNodes($(idfield));
			    	var nText = daten[idfield] ? daten[idfield].split("\n") : "";
                    for (var i in nText) {
                        $(idfield).appendChild(document.createTextNode(nText[i]));
                        $(idfield).appendChild(newnode("br"));
                    }
                    nText = null;
			    }
            }
            // contact picture?
            if ( daten.contains_image1 > 0 && daten.image1_url ) {
		        $('imageContactDetailTd').className = "";
		        if(!$('imageContactDetailTd').firstChild) {
		        	// TODO Why? (appears unnecessary)
		        	$('imageContactDetailTd').appendChild(document.createElement("img"));
		        }
		        $('imageContactDetailTd').firstChild.src = daten.image1_url + "&width=90&height=90&random=" + (daten.image_last_modified||0);
		    } else {
		    	// dummy picture
		        if(!$('imageContactDetailTd').firstChild) {
		        	// TODO Why? (appears unnecessary)
		        	$('imageContactDetailTd').appendChild(document.createElement("img"));
		        }
		        $('imageContactDetailTd').className = "contactDummyImage border-color-default";
		        $('imageContactDetailTd').firstChild.className="border-color-content-default";
		        $('imageContactDetailTd').firstChild.src = getFullImgSrc('img/contacts/dummypicture.gif');
		    }
            var cat = (daten.categories || "");
            if (cat.length) {
                ox.categories.ui.drawCategoriesList(ox.categories.getByString(cat),
              		  $("contact_categories"));
            } else {
          	  removeChildNodes($("contact_categories"));
            }

            var fields = ["telephone_business1", "telephone_business2",
                "telephone_home1", "telephone_home2", "cellular_telephone1",
                "cellular_telephone2", "telephone_company", "telephone_other",
                "telephone_car", "fax_business", "fax_home", "fax_other",
                "manager_name", "assistant_name", "telephone_assistant"];
            var labels = ["Phone"/*i18n*/,
                "Phone 2"/*i18n*/, "Phone (private)"/*i18n*/,
                "Phone (private 2)"/*i18n*/, "Cell phone"/*i18n*/,
                "Cell phone (private)"/*i18n*/, "Phone (company)"/*i18n*/,
                "Phone (other)"/*i18n*/, "Phone (car)"/*i18n*/,
                "Fax"/*i18n*/, "Fax (private)"/*i18n*/,
                "Fax (other)"/*i18n*/, "Manager"/*i18n*/, "Assistant"/*i18n*/,
                "Phone (assistant)"/*i18n*/];
            function fillComboBox(id1, id2, selected) {
                var combobox = new ComboBox3(window, id1, "100%", selected,
                                             false, null, 5);
                combobox.targetDiv = $(id2);
                combobox.viewValue = true;
                for (var i = 0; i < fields.length; i++) {
                    combobox.addElement(_(labels[i]), daten[fields[i]] || "");
                }
                combobox.getDomNode();
            }
			fillComboBox("combo_telephone_business1",
			             "abstact_telephone_business1", 0);
			fillComboBox("combo_privat_tel", "abstact_telephone_home1", 2);
			fillComboBox("combo_fax_home", "abstact_fax_home", 10);
			fillComboBox("combo_mobile_tel", "cellular_telephone1", 4);

			var myCombobox5 = new ComboBox3(window, "combo_email1", "100%", 0, false, "cb_abstact_email1", null);
			myCombobox5.targetDiv = $('abstact_email1');
			myCombobox5.viewValue = true;
			myCombobox5.addElement(_("E-Mail"), daten['email1'] || "");
			myCombobox5.addElement(_("E-Mail (private)"), daten['email2'] || "");
			myCombobox5.addElement(_("E-Mail (other)"), daten['email3'] || "");
			myCombobox5.getDomNode();

			if((daten['email1'])) {
			    myCombobox5.setSelectedIndex(0);
			    triggerEvent("cb_abstact_email1", daten['email1']);
			} else if((daten['email2'])) {
			    myCombobox5.setSelectedIndex(1);
			    triggerEvent("cb_abstact_email1", daten['email2']);
			}

			var myCombobox = new ComboBox3(window, "combo_instant_messenger1", "100%", 0, false, null, null);
			myCombobox.targetDiv = $('instant_messenger1');
			myCombobox.viewValue = true;
			myCombobox.addElement(_("IM"), daten['instant_messenger1'] || "");
			myCombobox.addElement(_("IM (private)"), daten['instant_messenger2'] || "");
			myCombobox.getDomNode();

			var myCombobox7 = new ComboBox3(window, "combo_telephone_ip", "100%", 0, false, null, null);
			myCombobox7.targetDiv = $('telephone_ip');
			myCombobox7.viewValue = true;
			myCombobox7.addElement(_("IP phone (private)"), daten['telephone_ip'] || "");
			myCombobox7.addElement(_("Pager"), daten['telephone_pager'] || "");
			myCombobox7.addElement(_("Telex"), daten['telephone_telex'] || "");
			myCombobox7.addElement(_("TTY/TDD"), daten['telephone_ttytdd'] || "");
			myCombobox7.addElement(_("URL"), daten['url'] || "");
			myCombobox7.addElement(_("TAX ID"), daten['tax_id'] || "");
			myCombobox7.addElement(_("Commercial Register"), daten['commercial_register'] || "");
			myCombobox7.addElement(_("Sales Volume"), daten['sales_volume'] || "");
			myCombobox7.getDomNode();

			var myCombobox7_b = new ComboBox3(window, "combo_birthday_status", "100%", 0, false, null, null);
			myCombobox7_b.targetDiv = $('birthday_status');
			myCombobox7_b.viewValue = true;
			if(daten['birthday'] == 0) daten['birthday'] = 1; // 0 -> fix for 01.01.1970
			myCombobox7_b.addElement(_("Date of birth"), daten['birthday'] ? formatDate(daten['birthday'], "date") : "");
			myCombobox7_b.addElement(_("Marital status"), daten['marital_status'] || "");
			myCombobox7_b.addElement(_("Spouse's name"), daten['spouse_name'] || "");
			myCombobox7_b.addElement(_("Anniversary"), daten['anniversary'] ? formatDate(daten['anniversary'], "date") : "");
			if(daten['anniversary'] == 0) daten['anniversary'] = 1; // 0 -> fix for 01.01.1970
			myCombobox7_b.addElement(_("Children"), daten['number_of_children'] || "");
			myCombobox7_b.getDomNode();
			myCombobox7_b.setSelectedIndex(0);

			var myCombobox8 = new ComboBox3.impl(window, $ALL("combo_private_address"), "100%", 0, false, null, function(key) {
					triggerEvent("routePlaner_set_end_address", key, [myCombobox8, mapLinks, 0]);
				});
			myCombobox8.targetDiv = $('private_address');
			myCombobox8.valueIsHTML = true;
			myCombobox8.viewValue = true;
			myCombobox8.addElement(_("Address"), myAddresse.addrBusinessDiv);
			myCombobox8.addElement(_("Address (private)"), myAddresse.addrPrivateDiv);
			myCombobox8.addElement(_("Address (other)"), myAddresse.addrOtherDiv);
			myCombobox8.getDomNode();
			myCombobox8.setSelectedIndex(0);

			var myCombobox9 = new ComboBox3.impl(window, $ALL("combo_business_address"), "100%", 1, false, null, function(key) {
					triggerEvent("routePlaner_set_end_address", key, [myCombobox9, mapLinks, 1]);
				});
			myCombobox9.targetDiv = $('business_address');
			myCombobox9.valueIsHTML = true;
			myCombobox9.viewValue = true;
			myCombobox9.addElement(_("Address"), myAddresse.addrBusinessDiv2);
			myCombobox9.addElement(_("Address (private)"), myAddresse.addrPrivateDiv2);
			myCombobox9.addElement(_("Address (other)"), myAddresse.addrOtherDiv2);
			myCombobox9.getDomNode();
			myCombobox9.setSelectedIndex(1);

			/* Dynamic fields */

			var optinalCombobox = new Array();

			for(var t = 1; t < 7; t++) {
			    optinalCombobox[t] = new ComboBox3(window, "combo_dynamic"+t, "100%", t-1, false, null, 4);
			    optinalCombobox[t].targetDiv = $('userfield0'+t);
			    optinalCombobox[t].viewValue = true;
			    for(i=1; i<=20; i++) {
				    if(i<10) { k = "0" + i; }
			        else { k = i; }
			        indexforData = 'userfield'+k;
			        //#. %d is the number of the optional dynamic field (1-20).
			        //#, c-format
			        optinalCombobox[t].addElement(format(_("Optional %d"),i), daten[indexforData] || "");
			    }
			    optinalCombobox[t].getDomNode();
			}
		    objContactFunctions.loadingContactDetail(false);
		}
		register("OX_Print",contacts_printDetail);
		triggerEvent("PAINT_CONTACT", { view: "detail", contact: daten });
	}

	objContactFunctions.loadingContactDetail(true);
	var contactDetailFolder = "";
	if(typeof contactDetailId == 'object') {
		//IF SEEMS TO BE NOT NECESSARY
		contactDetailId = contactDetailId.id;
		if(contactDetailId.folder) {
			contactDetailFolder = contactDetailId.folder;
		} else {
			contactDetailFolder = activefolder;
		}

	} else {
		contactDetailFolder = activefolder;
	}
    /******************************** Tabs *****************************************************************/
	var contacTabsList 		= 	new Array('tabContactDetail0','tabContactDetail1','tabContactDetail2');
	var contactPanelsList 	= 	new Array('panelContactDetail0','panelContactDetail1','panelContactDetail2');

	contacteventList		=	new Array( 	['OX_Contact_Switch_Detail','overview'],
											['OX_Contact_Switch_Detail','overview'],
		  									['OX_Contact_Switch_Detail','attachment']
										);
	//register tabs
	setTabLists(contacTabsList, contactPanelsList, contacteventList);
	///////////////////////////////////

	var collection={};
    collection.objects=[OXContactMapping.createKeyFromObject({"module" : "contacts" ,"folder_id" : contactDetailFolder, id : contactDetailId})];
    collection.columns=null; //ALL FIELDS
    if(tmpDetailRequest) {
        OXCache.unregister(tmpDetailRequest.uniqueName);
        tmpDetailRequest=null;
    }
    tmpDetailRequest=OXCache.newRequest(null,"contacts",collection,function cbModified(daten) {
        if(daten) {
			if(daten && daten.objects.length) {
                showDetailInside(daten.objects[0]);
            } else {
                triggerEvent("OX_Switch_View", configGetKey("gui.contacts.view"));
            }
        }
    },function cb(daten) {
		if(daten && daten.objects.length) {
			showDetailInside(daten.objects[0]);
		}
		else { triggerEvent("OX_Switch_View", configGetKey("gui.contacts.view")); }
    });
}

register("cb_abstact_email1", setMaillink);
register("sendMailToContact", sendMailToContactMail);


/*
  Array for Addresses
 * contactAdressToSearch[0] : selectec left Address in the contact Detail view
 * contactAdressToSearch[1] : selectec right Address in the contact Detail view
 * contactAdressToSearch[2] : default Address from the user
 * */

var contactAdressToSearch = [];


function closeMapsDivs() {
	$('contactPreviewMapDiv').style.display = 'none';
}

var mailFromRecipientContact = "";

function setMaillink(param) {
	mailFromRecipientContact = param;
}

function oDetailFieldInformation(e) {
	this.width 	= (document.all) ? document.body.clientWidth : innerWidth;
    this.height = (document.all) ? document.body.clientHeight : innerHeight;
	this.left 	= ((e.clientX + 210) > this.width)? e.clientX - 210 + "px" : e.clientX + 10 + "px";
	this.top 	= e.clientY + document.body.scrollTop - 50 + "px";

	$("divInfoForFields").style.left = this.left;
	$("divInfoForFields").style.top = this.top;
	$("divInfoForFields").style.display = "block";
}

function sendMailToContactMail(mailAdress) {
	var mailRecipientAdress = "";
	if(mailAdress)
		mailRecipientAdress = mailAdress;
	else if(mailFromRecipientContact != "") {
		mailRecipientAdress = mailFromRecipientContact;
	}

	if (mailRecipientAdress != "") {
		ox.api.mail.compose({
			data: {
				to: [[mailRecipientAdress]]
			}
		});
	}
}


function BuildAddresses(dataFields) {
	this.dataFields = dataFields;
	this.addrDiv1 = {};
	this.addrDiv2 = {};
	this.addrDiv = newnode("div");
}

BuildAddresses.prototype = {
	buildAddress: function (suffix) {
		var urlToAddress = {};
		var indexUrl = 0;

		var streetField = "street_" + suffix;
		if (this.dataFields[streetField] && this.dataFields[streetField] != 'null') {
			urlToAddress.street = this.dataFields[streetField];
		}

		var postalField = "postal_code_" + suffix;
		var cityField = "city_" + suffix;
		if ((this.dataFields[postalField] && this.dataFields[postalField] != 'null') || (this.dataFields[cityField] && this.dataFields[cityField] != 'null')) {
				if(this.dataFields[postalField] && this.dataFields[postalField] != 'null') {
					urlToAddress.zip = this.dataFields[postalField];
				}
				if(this.dataFields[cityField] && this.dataFields[cityField] != 'null') {
					urlToAddress.city = this.dataFields[cityField];
				}
		}

		var countryField = "country_" + suffix;
		if (this.dataFields[countryField] && this.dataFields[countryField] != 'null') {
			urlToAddress.country = this.dataFields[countryField];
		}

        //#. Address format for 4 line display.
        //#.
		//#. DO NOT TRANSLATE THE FIELD NAMES!
        //#.
		//#. Only change the order and punctuation.
        //#. \n separates multiple lines. Other punctuation appears as-is.
        //#. Available fields are: street, postal_code, city, state, country
		var format = String(_("street\npostal_code city\nstate\ncountry"));
        var dataFields = this.dataFields;
        format = format.replace(/([a-z_]+)([^a-z_]*)/g,
            function(match, key, rest) {
                var value = dataFields[key + "_" + suffix];
                if (value && value != "null") return value + rest;
                return "";
            });
        var lines = format.split("\n"),
            i = 0, $i = lines.length, line;
        for (; i < $i; i++) {
            if ((line = lines[i])) {
                // remove tailing punctuation (cp. bug #17995)
                line = line.replace(/[,]\s*$/, "");
                this.addrDiv.appendChild(newnode("div", 0, 0, [newtext(line)]));
            }
        }

		if(!this.addrDiv.firstChild) {
			this.addrDiv1[suffix] = "";
			this.addrDiv2[suffix] = "";
		} else {
			this.addrDiv1[suffix] = this.addrDiv.cloneNode(true);
			this.addrDiv2[suffix] = this.addrDiv.cloneNode(true);
		}
		removeChildNodes(this.addrDiv);
		return [this.addrDiv1[suffix], this.addrDiv2[suffix],urlToAddress];

	}
}

var initLiveGrid = 0;
var intervalContactGrid = null;
var clearLgridField = LiveGrid.makeClear("");

function initLiveGridOnLoad()
{
	var list = $("listeContacts");
	var listHeader = $("listeContactsHeader");
	if (contactGrid)
	{
		removeChildNodes(list);
		contactGrid = null;
	}

	function getNameSort() {
	    var lang = ox.api.config.get("language").substring(0, 3);
        return lang == "zh_" || lang == "ja_" ? "last_name" : "sort";
	}

	var nameColumn;
	temporary.lists.contacts = temporary.MakeList({
	    updated: function() { contactGrid.recreate(); },
	    columns: [
            {
                text: "",
                sortable: false,
                name : ["mark_as_distributionlist"],
                width: "24px",
                style: { padding: 0, textAlign: "center" },
                set: function(div,text) {
                    var divIcons = "";
                    if (div) {
                        if (text) {
                            addDOMEvent(div.parentNode, "mousedown", function() { setStatusDLSelection(); });
                            divIcons = "<img src='"+getFullImgSrc("img/menu/distributionlist.gif")+"' alt='Distribution List' align='absmiddle' />";
                        } else {
                            addDOMEvent(div.parentNode, "mousedown", function() { setStatusDLSelection(); });
                            divIcons = "<img src='"+getFullImgSrc("img/folder/contacts.gif")+"' alt='Contact' align='absmiddle' />";
                        }

                    }
                    div.innerHTML = divIcons;
                },
                clear: function(div) {
                    if (!div.firstChild)
                        div.appendChild(document.createElement("img"));
                    div.firstChild.src = getFullImgSrc("img/mail/noattachment.gif");
                }
            }, {
                text: "",
                name : ["private_flag"],
                sortable: false,
                width: "22px",
                style: { padding: 0, textAlign: "center" },
                set: function(div, text) {
                    if (div.firstChild)
                        div.firstChild.src = !text ? getFullImgSrc("img/dummy.gif") : getFullImgSrc("img/private_flag.gif");
                    else
                        div.appendChild(newnode("img", 0,
                            { src: !text ? getFullImgSrc("img/dummy.gif") : getFullImgSrc("img/private_flag.gif"), alt: "", width: "16", height: "16", align: "absmiddle"}));
                },
                clear: function(div) {
                    if (!div.firstChild)
                        div.appendChild(newnode("img", 0,
                                { src: getFullImgSrc("img/dummy.gif"), alt: "", width: "16", height: "16", align: "absmiddle"}));
                    div.firstChild.src = getFullImgSrc("img/mail/noattachment.gif");
                }
            },
            nameColumn = {
                text: "Name", /*i18n*/
                sortable: true,
                i18n: true,
                name : ["display_name","first_name","last_name", "company",
                        "email1", "email2"],
                sort : getNameSort(),
                set: function (div, text) {
                    var nameHeadline = objContactCardFunctions.getHeadline(text,true);
                    if (div.firstChild)
                        div.firstChild.data = nameHeadline;
                    else
                        div.appendChild(document.createTextNode(nameHeadline));
                },
                clear: clearLgridField
            }, {
                text: "Company", /*i18n*/
                name:["company"],
                sort:"company",
                sortable: true,
                i18n: true,
                width: "14%",
                set: LiveGrid.defaultSet,
                clear: clearLgridField
            }, {
                text: "City", /*i18n*/
                name:["city_business"],
                sort:"city_business",
                sortable: true,
                i18n: true,
                width: "14%",
                set: LiveGrid.defaultSet,
                clear: clearLgridField
            }, {
                text: "Phone", /*i18n*/
                name: ["telephone_business1"],
                sort: "telephone_business1",
                sortable: true,
                i18n: true,
                width: "18%",
                set: LiveGrid.defaultSet,
                clear: clearLgridField
            }, {
                text: "Cell phone", /*i18n*/
                sortable: true,
                i18n: true,
                name : ["cellular_telephone1"],
                sort : "cellular_telephone1",
                width: "18%",
                set: LiveGrid.defaultSet,
                clear: clearLgridField
            }, {
                text: "&#160;",
                sortable: true,
                name : ["color_label"],
                sort : "color_label",
                width: "3em",
                set: function(div,text) {
                    var divIcons = "";
                    if (div) {
                        divIcons = "<img src='"+getFullImgSrc("img/menu/tag_" + (text || 0) + ".gif")+"' alt='tag' />";
                        div.innerHTML = divIcons;
                    }
                },
                clear: clearLgridField
            }
        ]
	});

	register("LanguageChanged", function() {
	    nameColumn.sort = getNameSort();
	    temporary.lists.contacts.updated();
	});

	contactGrid = new LiveGrid2(temporary.lists.contacts.columns,
	    contactsSelection2, "contacts");

    contactGrid.contextmenu = globalContextMenus.contacts;

	//contactGrid.sort = initLiveGridContacts;

	listHeader.appendChild(contactGrid.getHeader());
	contactGrid.getTable(list);

	contactGrid.events.register("Changed", contact_HeaderUpdate);

	contactGrid.events.register("Selected",
		function(ids) {
			setStatusDLSelection();
		}
	);

	function setStatusDLSelection_db() {
		triggerEvent("Selected", contactGrid.selection.getSelected());
	}

	contactGrid.events.register("Activated", function(ids) {
			if(ids && ids.length > 0) {
				if(menuhasRight(ids,"WRITE")) {
					editContact();
				} else {
					triggerEvent("OX_New_Error", 4, _("You do not have write permission for this object."));
				}
			} else {
				objContactFunctions.resetContactCardCache();
				triggerEvent("OX_Before_Create_Contact");
			}
		}
	);

	contactGrid.events.register("Delete", function(ids){
			if(menucheckRight("DELETE"))
				objContactFunctions.deleteContacts();
		});


	var hover = contactGrid.addHover(OXContactHover.getContent().node,
	    function(id, manual) {
		OXContactHover.actualHover=hover;
		OXContactHover.refillContent(id.id,id.folder_id, function() {
            // trigger event
            var node = OXContactHover.getContent().node || null;
            var contact = OXContactHover.actualobject || null;
            if (node && contact) {
                triggerEvent("PAINT_CONTACT", { view: "hover", number: 0,
                    contact: contact, node: node, hover: hover });
            }
		});
	});
	hover.setSize(OXContactHover.contentobject.node);

}




/********************************** Phonelist *****************************************************************/

function initLiveGridContacts()
{
    var pattern = undefined;
    if (contactsSearchObject !== null) {
        pattern = contactsSearchObject.pattern;
    }
	objContactFunctions.getStorageCache(pattern, pattern !== undefined ? true : undefined);
}

/********************************** New Contact *****************************************************************/
function createNewContact (module, folder) {
	if (module == "contacts") {
		ox.api.contact.compose({
			params: {
				currentView: objContactFunctions.lastView,
				folder: folder
			}
		});
		//openContactPopup('modul=new&currentView='+objContactFunctions.lastView+"&folder="+folder,'newContact.html');
	}
	else if ( module == "distributionlist") {
		ox.api.contact.composeDistributionList({
			params: {
				currentView: objContactFunctions.lastView,
				folder: folder
			}
		});
		//openContactPopup('modul=new&currentView='+objContactFunctions.lastView+"&folder="+folder, 'newDistributionList.html');
	}
}
/********************************** open Popup *****************************************************************/

function closeContactPopUp(popContact, newFolderId)
{
	window.setTimeout(function () {
	    popContact.windowController.close(true);
	}, 50);
	if (currentpath2[0] == 'contacts' && currentpath2[1] == 'detail') {
	    triggerEvent("OX_Switch_View","contacts/detail/overview");
		if (newFolderId != activefolder) {
			if(contactDetailId.folder) {
				contactDetailId.folder = newFolderId;
			}
			triggerEvent("Selected", [{id:contactDetailId, folder:newFolderId}]);
			ox.api.ui.setFolder(newFolderId,reloadContactDetailView);
		} else {
			reloadContactDetailView();
		}
	}
}
/********************************** Show Contacts by ABC ********************************/

function ContactsBySearch() {
	this.fullSearch = false;
	this.searchstring = "";
	this.letterDiv = null;
	this.oldLetterDiv = null;
}

ContactsBySearch.prototype = {
	setLetterStyle: function(letterDiv) {
		if (letterDiv) {
			this.letterDiv = letterDiv;
		}
		if (this.oldLetterDiv) {
			this.oldLetterDiv.className = "div_letter_single";
		} else {
			// @first Click to letterTab, set hightlight of letter "All" to false
			myLetterContactTab.letterParentDiv.lastChild.className = "div_letter_single";
		}
		this.letterDiv.className = "letterSelected border-color-design font-style-lable font-size-small background-color-content";
		this.oldLetterDiv = this.letterDiv;
	}
};

var viewContactsBySearch = new ContactsBySearch();

function LetterContactTab() {
    this.letterDiv = null;
    this.tabDiv = null;

    var latin = [{ text: "123", search: [
        ["and", ["or", ["isnull", { field: "last_name" }],
                      ["<", { field: "last_name" }, "A"],
                      [">=", { field: "last_name" }, "\u03b1"]],
                ["or", ["isnull", { field: "display_name" }],
                      ["<", { field: "display_name" }, "A"],
                      [">=", { field: "display_name" }, "\u03b1"]]
        ]
    ] }];
    for (var i = 65; i <= 89; i++) { // 'A' to 'Y'
        latin.push({ text: String.fromCharCode(i), search: [
            ["or",["and", [">=", { field: "last_name" }, String.fromCharCode(i)],
                          ["<", { field: "last_name" }, String.fromCharCode(i + 1)]],
                  ["and", [">=", { field: "display_name" }, String.fromCharCode(i)],
                          ["<", { field: "display_name" }, String.fromCharCode(i + 1)]]
            ]
        ] });
    }
    latin.push({ text: "Z", search: [
        ["or", ["and", [">=", { field: "last_name" }, "Z"],
                       ["<", { field: "last_name" }, "\u03b1"]],
               ["and", [">=", { field: "display_name" }, "Z"],
                       ["<", { field: "display_name" }, "\u03b1"]]
        ]
    ] });

    var ja_long = [{ text: "123", search: [
        ["or", ["isnull", { field: "yomiLastName" }],
               ["<", { field: "yomiLastName" }, "A"],
               ["and", [">=", { field: "yomiLastName" }, "\u03b1"],
                       ["<", { field: "yomiLastName" }, "\u30a2"]],
               [">", { field: "yomiLastName" }, "\u30f3"]],
        ["or", ["isnull", { field: "last_name" }],
               ["<", { field: "last_name" }, "A"],
               ["and", [">=", { field: "last_name" }, "\u03b1"],
                       ["<", { field: "last_name" }, "\u30a2"]],
               [">", { field: "last_name" }, "\u30f3"]]
    ] }];
    for (var i = 65; i <= 89; i++) { // 'A' to 'Y'
        ja_long.push({ text: String.fromCharCode(i), search: [["or",
            ["and", [">=", { field: "yomiLastName" }, String.fromCharCode(i)],
                    ["<", { field: "yomiLastName" }, String.fromCharCode(i+1)]],
            ["and", [">=", { field: "last_name" }, String.fromCharCode(i)],
                    ["<", { field: "last_name" }, String.fromCharCode(i + 1)]]
        ]] });
    }
    ja_long.push({ text: "Z", search: [["or",
        ["and", [">=", { field: "yomiLastName" }, "Z"],
                ["<", { field: "yomiLastName" }, "\u03b1"]],
        ["and", [">=", { field: "last_name" }, "Z"],
                ["<", { field: "last_name" }, "\u03b1"]]
    ]] });
    var kanaRanges = ["\u3042", "\u304b", "\u3055", "\u305f", "\u306a",
                      "\u306f", "\u307e", "\u3084", "\u3089", "\u308f"];
    for (var i = 0; i < kanaRanges.length - 1; i++) {
        var from = kanaRanges[i];
        var to = kanaRanges[i + 1];
        if (typeof to != "string") to = to[0];
        ja_long.push({ text: from, search: [["or",
            ["and", [">=", { field: "last_name" }, from],
                    ["<", { field: "last_name" }, to]],
            ["and", [">=", { field: "yomiLastName" }, from],
                    ["<", { field: "yomiLastName" }, to]]
        ]] });
    }
    ja_long.push({ text: "\u30ef", search: [["or",
        ["and", [">=", { field: "last_name" }, "\u30ef"],
                ["<=", { field: "last_name" }, "\u30f3"]],
        ["and", [">=", { field: "yomiLastName" }, "\u30ef"],
                ["<=", { field: "yomiLastName" }, "\u30f3"]]
    ]] });

    var ja_short = [ja_long[0], { text: "ABC", search: [["or",
        ["and", [">=", { field: "yomiLastName" }, "A"],
                ["<", { field: "yomiLastName" }, "\u03b1"]],
        ["and", [">=", { field: "last_name" }, "A"],
                ["<", { field: "last_name" }, "\u03b1"]]
    ]] }];
    for (var i = 27; i < ja_long.length; i++) ja_short.push(ja_long[i]);

    var self = this;
    var letters = { ja_JP: function() {
        var height = 2 + (2 + Math.round(pxPerEm * 0.9)) * ja_long.length;
        return self.tabDiv.clientHeight >= height ? ja_long : ja_short;
    } };

    letters.zh_CN = [{ text: "123", search: [["or",
        ["isnull", { field: "last_name" }],
        ["<", { field: "last_name" }, "A"],
        ["and", [">", { field: "last_name" }, "Z"],
                ["<", { field: "last_name" }, "\u5416"]],
        [">", { field: "last_name" }, "\u309e"]
    ]] }];

    var chineseRanges = ["\u5416", "\u516b", "\u5693", "\u5491", "\u59b8",     // A-E
        "\u53d1", "\u7324", "\u598e", "\u4e0c", "\u4e0c", "\u5494", "\u5783",  // F-L
        "\u5638", "\u62cf", "\u685b", "\u5991", "\u4e03", "\u4ebd", "\u4ee8",  // M-S
        "\u4ed6", "\u5c72", "\u5c72", "\u5c72", "\u5915", "\u4e2b", "\u5e00"]; // T-Z
    function chr(c) { return String.fromCharCode(65 + c); } // 65 = A
    for (var i = 0; i < chineseRanges.length - 1; i++) {
        if (chineseRanges[i] == chineseRanges[i + 1]) {
            letters.zh_CN.push({ text: chr(i), search: [
                [">=", { field: "last_name" }, chr(i)],
                ["<", { field: "last_name" }, chr(i + 1)]
            ] });
        } else {
            letters.zh_CN.push({ text: chr(i), search: [["or",
                ["and", [">=", { field: "last_name" }, chr(i)],
                        ["<", { field: "last_name" }, chr(i + 1)]],
                ["and", [">=", { field: "last_name" }, chineseRanges[i]],
                        ["<", { field: "last_name" }, chineseRanges[i + 1]]]
            ]] });
        }
    }
    letters.zh_CN.push({ text: "Z", search: [["or",
        ["and", [">=", { field: "last_name" }, "Z"],
                ["<", { field: "last_name" }, "\u03b1"]],
        ["and", [">=", { field: "last_name" }, "\u5e00"],
                ["<=", { field: "last_name" }, "\u309e"]]
    ]] });

    letters.zh_TW = letters.zh_CN;

    var Self = this;
    updateLetters();
    register("LanguageChanged", updateLetters);
    function updateLetters() {
        Self.letters = letters[configGetKey("language")] || latin;
    }
}

LetterContactTab.prototype = {
	buildTab : function(tabDivId) {
        var Self = this;

		/**************** activate/deactivate panel for contact search by characters *******************/

		if (configContainsKey("modules.contacts.characterSearch") && configGetKey("modules.contacts.characterSearch") == false ||
				configContainsKey("minimumSearchCharacters") && configGetKey("minimumSearchCharacters") >= 1){
			var temp_scrollerCbar = $("contactCardScrollerbar");
			if (temp_scrollerCbar){ temp_scrollerCbar.style.marginRight="0"; }
			var temp_contactCardTable = $("contactCardTable");
			if (temp_contactCardTable){ temp_contactCardTable.style.marginRight="0"; }
			var temp_listeContacts = $("listeContacts");
			if (temp_listeContacts){ temp_listeContacts.style.marginRight="0"; }
			var temp_cardContactsLetterDiv = $("cardContactsLetterDiv");
			if (temp_cardContactsLetterDiv){ temp_cardContactsLetterDiv.style.width="0"; }
			var temp_listeContactsLetterDiv = $("listeContactsLetterDiv");
			if (temp_listeContactsLetterDiv){ temp_listeContactsLetterDiv.style.width="0"; }
			var temp_listeContactsHeader = $("listeContactsHeader");
			if (temp_listeContactsHeader){ temp_listeContactsHeader.style.marginRight="0"; }
			this.unregisterTab();
		} else {
			this.letterParentDiv = document.createElement("div");
			this.letterParentDiv.className="background-color-additional-content";
			if(tabDivId) this.tabDiv = $(tabDivId);
			this.clearBeforeCreateNew();
			var letters = Self.letters;
			if (typeof letters == "function") letters = letters();
			for(var i = 0; i < letters.length; i++) {
                createLetter(noI18n(letters[i].text),
                    ["and", ["=", { field: "folder_id" }, activefolder]].
                        concat(letters[i].search));
			}
			createLetter(_("All"), "");
			Self.tabDiv.appendChild(Self.letterParentDiv);
			this.unregisterTab();
            this.resize_cb = function() {
                if (   typeof Self.letters == "function"
                    && Self.letters() != letters)
                {
                    Self.buildTab(tabDivId);
                }
            };
            resizeEvents.register("Resized", this.resize_cb);
		}

        function createLetter(text, search) {
            Self.letterDiv = document.createElement("div");

            if (   search == viewContactsBySearch.searchstring
                && !viewContactsBySearch.fullSearch)
            {
                Self.letterDiv.className="letterSelected border-color-design font-style-lable font-size-small background-color-content";
                viewContactsBySearch.oldLetterDiv = Self.letterDiv;
            } else {
                Self.letterDiv.className="div_letter_single";
            }
            var textNodeLetter = newtext(expectI18n(text));
            Self.letterDiv.appendChild(textNodeLetter);
            var myTempDiv = Self.letterDiv;
            addDOMEvent(Self.letterDiv, "click", function() {
                objContactFunctions.getStorageCache(search);
                viewContactsBySearch.setLetterStyle(myTempDiv);
            });
            Self.letterParentDiv.appendChild(Self.letterDiv);
        }
	},
    unregisterTab: function() {
        if (this.resize_cb) {
            resizeEvents.unregister("Resized", this.resize_cb);
            this.resize_cb = null;
        }
    },
	clearBeforeCreateNew : function() {
		if(this.tabDiv && this.tabDiv.hasChildNodes()) {
			this.tabDiv.removeChild(this.tabDiv.firstChild);
		}
		viewContactsBySearch.oldLetterDiv=null;
	}
};

function contact_HeaderUpdate(data) {
    if (viewContactsBySearch.fullSearch) {
        contactsFolderPath.drawSearch("contacts",
            viewContactsBySearch.searchstring);
    } else {
        contactsFolderPath.additionalNode = document.createTextNode(" (" +
            data.objects.length + ")");
        contactsFolderPath.drawDOMNode(currentpath2[1] == "phonelist" ?
            "contactsListHeaderOwner" : "contactsCardsHeaderOwner",
            activefolder);
    }
}

var myLetterContactTab = new LetterContactTab();
function searchContactByString(sModule,sPattern) {
    contactsSearchObject = { module: sModule, pattern: sPattern };
	objContactFunctions.getStorageCache(sPattern, true);
}

function contactsDetailSearch(module, pattern) {
    contactsSearchObject = { module: module, pattern: pattern };
    objContactFunctions.searchHack = { pattern: pattern, fullsearch: true };
    switchtoView(menulastviews[module]);
}

function deleteSearchContactByString() {
    contactsSearchObject = null;
    // reset storage
	if (viewContactsBySearch.fullSearch) {
	    viewContactsBySearch.fullSearch = false;
		objContactFunctions.getStorageCache();
	}
}

fileloaded();