/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ApplicationProperty {
    APPLICATION_NAME("application_name", "string"),
    CALLBACK_URL("callback_url", "string"),
    POST_INSTALL_URL("post_install_url", "string"),
    EDIT_URL("edit_url", "string"),
    DASHBOARD_URL("dashboard_url", "string"),
    UNINSTALL_URL("uninstall_url", "string"),
    IP_LIST("ip_list", "string"),
    EMAIL("email", "string"),
    DESCRIPTION("description", "string"),
    USE_IFRAME("use_iframe", "bool"),
    DESKTOP("desktop", "bool"),
    IS_MOBILE("is_mobile", "bool"),
    DEFAULT_FBML("default_fbml", "string"),
    DEFAULT_COLUMN("default_column", "bool"),
    MESSAGE_URL("message_url", "string"),
    MESSAGE_ACTION("message_action", "string"),
    ABOUT_URL("about_url", "string"),
    PRIVATE_INSTALL("private_install", "bool"),
    INSTALLABLE("installable", "bool"),
    PRIVACY_URL("privacy_url", "string"),
    HELP_URL("help_url", "string"),
    SEE_ALL_URL("see_all_url", "string"),
    TOS_URL("tos_url", "string"),
    DEV_MODE("dev_mode", "bool"),
    PRELOAD_FQL("preload_fql", "string"),
    CANVAS_NAME("canvas_name", "string"),
    ICON_URL("icon_url", "string"),
    LOGO_URL("logo_url", "string");

    protected static final Map<String, ApplicationProperty> PROP_TABLE;
    private String name;
    private String type;

    private ApplicationProperty(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public static ApplicationProperty getPropertyForString(String propName) {
        return PROP_TABLE.get(propName);
    }

    public static ApplicationProperty getProperty(String name) {
        return ApplicationProperty.getPropertyForString(name);
    }

    public String propertyName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isBooleanProperty() {
        return "bool".equals(this.type);
    }

    public boolean isStringProperty() {
        return "string".equals(this.type);
    }

    public boolean isName(String name) {
        return this.toString().equals(name);
    }

    static {
        PROP_TABLE = new HashMap<String, ApplicationProperty>();
        for (ApplicationProperty prop : ApplicationProperty.values()) {
            PROP_TABLE.put(prop.getName(), prop);
        }
    }
}

