/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.util.Arrays;
import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSSamlAssertionValidator;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

public class STSTokenValidator
implements Validator {
    private STSSamlAssertionValidator samlValidator = new STSSamlAssertionValidator();
    private boolean alwaysValidateToSts;

    public STSTokenValidator() {
    }

    public STSTokenValidator(boolean alwaysValidateToSts) {
        this.alwaysValidateToSts = alwaysValidateToSts;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (this.isValidatedLocally(credential, data)) {
            return credential;
        }
        return this.validateWithSTS(credential, (SoapMessage)data.getMsgContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential validateWithSTS(Credential credential, Message message) throws WSSecurityException {
        try {
            STSClient c;
            SecurityToken transformedToken;
            SecurityToken token = new SecurityToken();
            Element tokenElement = null;
            int hash = 0;
            if (credential.getAssertion() != null) {
                AssertionWrapper assertion = credential.getAssertion();
                byte[] signatureValue = assertion.getSignatureValue();
                if (signatureValue != null && signatureValue.length > 0) {
                    hash = Arrays.hashCode(signatureValue);
                }
                tokenElement = credential.getAssertion().getElement();
            } else if (credential.getUsernametoken() != null) {
                tokenElement = credential.getUsernametoken().getElement();
                hash = credential.getUsernametoken().hashCode();
            } else if (credential.getBinarySecurityToken() != null) {
                tokenElement = credential.getBinarySecurityToken().getElement();
                hash = credential.getBinarySecurityToken().hashCode();
            } else if (credential.getSecurityContextToken() != null) {
                tokenElement = credential.getSecurityContextToken().getElement();
                hash = credential.getSecurityContextToken().hashCode();
            }
            token.setToken(tokenElement);
            TokenStore tokenStore = STSTokenValidator.getTokenStore(message);
            if (tokenStore != null && hash != 0 && (transformedToken = this.getTransformedToken(tokenStore, hash)) != null) {
                AssertionWrapper assertion = new AssertionWrapper(transformedToken.getToken());
                credential.setTransformedToken(assertion);
                return credential;
            }
            token.setTokenHash(hash);
            STSClient sTSClient = c = STSUtils.getClient(message, "sts");
            synchronized (sTSClient) {
                System.setProperty("noprint", "true");
                List<SecurityToken> tokens = c.validateSecurityToken(token);
                SecurityToken returnedToken = tokens.get(0);
                if (returnedToken != token) {
                    AssertionWrapper assertion = new AssertionWrapper(returnedToken.getToken());
                    credential.setTransformedToken(assertion);
                    if (hash != 0) {
                        tokenStore.add(returnedToken);
                        token.setTransformedTokenIdentifier(returnedToken.getId());
                        tokenStore.add(Integer.toString(hash), token);
                    }
                }
                return credential;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "invalidSAMLsecurity", null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TokenStore getTokenStore(Message message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)message.getContextualProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            }
            if (tokenStore == null) {
                TokenStoreFactory tokenStoreFactory = TokenStoreFactory.newInstance();
                String cacheKey = "org.apache.cxf.ws.security.tokenstore.TokenStore";
                if (info.getName() != null) {
                    cacheKey = cacheKey + "-" + info.getName().toString().hashCode();
                }
                tokenStore = tokenStoreFactory.newTokenStore(cacheKey, message);
                info.setProperty("org.apache.cxf.ws.security.tokenstore.TokenStore", tokenStore);
            }
            return tokenStore;
        }
    }

    protected boolean isValidatedLocally(Credential credential, RequestData data) throws WSSecurityException {
        if (!this.alwaysValidateToSts && credential.getAssertion() != null) {
            try {
                this.samlValidator.validate(credential, data);
                return this.samlValidator.isTrustVerificationSucceeded();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, (Throwable)e);
            }
        }
        return false;
    }

    private SecurityToken getTransformedToken(TokenStore tokenStore, int hash) {
        String transformedTokenId;
        SecurityToken recoveredToken = tokenStore.getToken(Integer.toString(hash));
        if (recoveredToken != null && recoveredToken.getTokenHash() == hash && (transformedTokenId = recoveredToken.getTransformedTokenIdentifier()) != null) {
            return tokenStore.getToken(transformedTokenId);
        }
        return null;
    }
}

