/*
 * Copyright 2007 Yusuke Yamamoto
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package twitter4j.api;

import twitter4j.Query;

/**
 * @author Joern Huxhorn - jhuxhorn at googlemail.com
 */
public interface SearchMethodsAsync {
    /**
     * Returns tweets that match a specified query.
     * <br>This method calls http://search.twitter.com/search.json
     *
     * @param query - the search condition
     * @see <a href="http://dev.twitter.com/doc/get/search">GET search | dev.twitter.com</a>
     * @see <a href="http://search.twitter.com/operators">Twitter API / Search Operators</a>
     * @since Twitter4J 1.1.7
     */
    void search(Query query);
}
