/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 jOpenDocument, by ILM Informatique. All rights reserved.
 * 
 * The contents of this file are subject to the terms of the GNU
 * General Public License Version 3 only ("GPL").  
 * You may not use this file except in compliance with the License. 
 * You can obtain a copy of the License at http://www.gnu.org/licenses/gpl-3.0.html
 * See the License for the specific language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each file.
 * 
 */

package org.jopendocument.model.style;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Element;

/**
 * 
 */
public class StyleProperties {

    protected String chartConnectBars;
    protected String chartDataLabelNumber;
    protected String chartDataLabelSymbol;
    protected String chartDataLabelText;
    protected String chartDeep;
    protected String chartDisplayLabel;
    protected String chartErrorCategory;
    protected String chartErrorLowerIndicator;
    protected String chartErrorLowerLimit;
    protected String chartErrorMargin;
    protected String chartErrorPercentage;
    protected String chartErrorUpperIndicator;
    protected String chartErrorUpperLimit;
    protected String chartGapWidth;
    protected String chartIntervalMajor;
    protected String chartIntervalMinor;
    protected String chartLabelArrangement;
    protected String chartLines;
    protected String chartLinesUsed;
    protected String chartLinkDataStyleToSource;
    protected String chartLogarithmic;
    protected String chartMaximum;
    protected String chartMeanValue;
    protected String chartMinimum;
    protected String chartOrigin;
    protected String chartOverlap;
    protected String chartPercentage;
    protected String chartPieOffset;
    protected String chartRegressionType;
    protected String chartScaleText;
    protected String chartSeriesSource;
    protected String chartSolidType;
    protected String chartSplineOrder;
    protected String chartSplineResolution;
    protected String chartSplines;
    protected String chartStacked;
    protected String chartStockUpdownBars;
    protected String chartStockWithVolume;
    protected String chartSymbol;
    protected String chartSymbolHeight;
    protected String chartSymbolImageName;
    protected String chartSymbolWidth;
    protected String chartTextOverlap;
    protected String chartThreeDimensional;
    protected String chartTickMarksMajorInner;
    protected String chartTickMarksMajorOuter;
    protected String chartTickMarksMinorInner;
    protected String chartTickMarksMinorOuter;
    protected String chartVertical;
    protected String chartVisible;
    protected List<Object> content;
    protected String dr3DAmbientColor;
    protected String dr3DBackfaceCulling;
    protected String dr3DBackScale;
    protected String dr3DCloseBack;
    protected String dr3DCloseFront;
    protected String dr3DDepth;
    protected String dr3DDiffuseColor;
    protected String dr3DEdgeRounding;
    protected String dr3DEdgeRoundingMode;
    protected String dr3DEmissiveColor;
    protected String dr3DEndAngle;
    protected String dr3DHorizontalSegments;
    protected String dr3DLightingMode;
    protected String dr3DNormalsDirection;
    protected String dr3DNormalsKind;
    protected String dr3DShadow;
    protected String dr3DShininess;
    protected String dr3DSpecularColor;
    protected String dr3DTextureFilter;
    protected String dr3DTextureGenerationModeX;
    protected String dr3DTextureGenerationModeY;
    protected String dr3DTextureKind;
    protected String dr3DTextureMode;
    protected String dr3DVerticalSegments;
    protected String drawAutoGrowHeight;
    protected String drawAutoGrowWidth;
    protected String drawBackgroundSize;
    protected String drawBlue;
    protected String drawCaptionAngle;
    protected String drawCaptionAngleType;
    protected String drawCaptionEscape;
    protected String drawCaptionEscapeDirection;
    protected String drawCaptionFitLineLength;
    protected String drawCaptionGap;
    protected String drawCaptionLineLength;
    protected String drawCaptionType;
    protected String drawColorInversion;
    protected String drawColorMode;
    protected String drawContrast;
    protected String drawDecimalPlaces;
    protected String drawEndGuide;
    protected String drawEndLineSpacingHorizontal;
    protected String drawEndLineSpacingVertical;
    protected String drawFill;
    protected String drawFillColor;
    protected String drawFillGradientName;
    protected String drawFillHatchName;
    protected String drawFillHatchSolid;
    protected String drawFillImageHeight;
    protected String drawFillImageName;
    protected String drawFillImageRefPoint;
    protected String drawFillImageRefPointX;
    protected String drawFillImageRefPointY;
    protected String drawFillImageWidth;
    protected String drawFitToContour;
    protected String drawFitToSize;
    protected String drawFontworkAdjust;
    protected String drawFontworkDistance;
    protected String drawFontworkForm;
    protected String drawFontworkHideForm;
    protected String drawFontworkMirror;
    protected String drawFontworkOutline;
    protected String drawFontworkShadow;
    protected String drawFontworkShadowColor;
    protected String drawFontworkShadowOffsetX;
    protected String drawFontworkShadowOffsetY;
    protected String drawFontworkShadowTransparence;
    protected String drawFontworkStart;
    protected String drawFontworkStyle;
    protected String drawFrameDisplayBorder;
    protected String drawFrameDisplayScrollbar;
    protected String drawFrameMarginHorizontal;
    protected String drawFrameMarginVertical;
    protected String drawGamma;
    protected String drawGradientStepCount;
    protected String drawGreen;
    protected String drawGuideDistance;
    protected String drawGuideOverhang;
    protected String drawLineDistance;
    protected String drawLuminance;
    protected String drawMarkerEnd;
    protected String drawMarkerEndCenter;
    protected String drawMarkerEndWidth;
    protected String drawMarkerStart;
    protected String drawMarkerStartCenter;
    protected String drawMarkerStartWidth;
    protected String drawMeasureAlign;
    protected String drawMeasureVerticalAlign;
    protected String drawMirror;
    protected String drawMoveProtect;
    protected String drawParallel;
    protected String drawPlacing;
    protected String drawRed;
    protected String drawShadow;
    protected String drawShadowColor;
    protected String drawShadowOffsetX;
    protected String drawShadowOffsetY;
    protected String drawShadowTransparency;
    protected String drawShowUnit;
    protected String drawSizeProtect;
    protected String drawStartGuide;
    protected String drawStartLineSpacingHorizontal;
    protected String drawStartLineSpacingVertical;
    protected String drawStroke;
    protected String drawStrokeDash;
    protected String drawSymbolColor;
    protected String drawTextareaHorizontalAlign;
    protected String drawTextareaVerticalAlign;
    protected String drawTileRepeatOffset;
    protected String drawTransparency;
    protected String drawTransparencyName;
    protected String drawUnit;
    protected String drawVisibleAreaHeight;
    protected String drawVisibleAreaLeft;
    protected String drawVisibleAreaTop;
    protected String drawVisibleAreaWidth;
    protected String drawWritingMode;
    protected String foBackgroundColor;
    protected String foBorder;
    protected String foBorderBottom;
    protected String foBorderLeft;
    protected String foBorderRight;
    protected String foBorderTop;
    protected String foBreakAfter;
    protected String foBreakBefore;
    protected String foClip;
    protected String foColor;
    protected String foCountry;
    protected String foDirection;
    protected String foFontFamily;
    protected String foFontSize;
    protected String foFontStyle;
    protected String foFontVariant;
    protected String foFontWeight;
    protected String foHeight;
    protected String foHyphenate;
    protected String foHyphenateKeep;
    protected String foHyphenationLadderCount;
    protected String foHyphenationPushCharCount;
    protected String foHyphenationRemainCharCount;
    protected String foKeepTogether;
    protected String foKeepWithNext;
    protected String foLanguage;
    protected String foLetterSpacing;
    protected String foLineHeight;
    protected String foMarginBottom;
    protected String foMarginLeft;
    protected String foMarginRight;
    protected String foMarginTop;
    protected String foMaxHeight;
    protected String foMaxWidth;
    protected String foMinHeight;
    protected String foMinWidth;
    protected String foOrphans;
    protected String foPadding;
    protected String foPaddingBottom;
    protected String foPaddingLeft;
    protected String foPaddingRight;
    protected String foPaddingTop;
    protected String foPageHeight;
    protected String foPageWidth;
    protected String foScoreSpaces;
    protected String foTextAlign;
    protected String foTextAlignLast;
    protected String foTextIndent;
    protected String foTextShadow;
    protected String foTextTransform;
    protected String foVerticalAlign;
    protected String foWidows;
    protected String foWidth;
    protected String foWrapOption;
    protected String presentationBackgroundObjectsVisible;
    protected String presentationBackgroundVisible;
    protected String presentationDuration;
    protected String presentationTransitionSpeed;
    protected String presentationTransitionStyle;
    protected String presentationTransitionType;
    protected String presentationVisibility;
    protected String styleAutoTextIndent;
    protected String styleBackgroundTransparency;
    protected String styleBorderLineWidth;
    protected String styleBorderLineWidthBottom;
    protected String styleBorderLineWidthLeft;
    protected String styleBorderLineWidthRight;
    protected String styleBorderLineWidthTop;
    protected String styleBreakInside;
    protected String styleCellProtect;
    protected String styleColumnWidth;
    protected String styleCountryAsian;
    protected String styleCountryComplex;
    protected String styleDecimalPlaces;
    protected String styleDynamicSpacing;
    protected String styleEditable;
    protected String styleFirstPageNumber;
    protected String styleFontCharset;
    protected String styleFontCharsetAsian;
    protected String styleFontCharsetComplex;
    protected String styleFontFamilyAsian;
    protected String styleFontFamilyComplex;
    protected String styleFontFamilyGeneric;
    protected String styleFontFamilyGenericAsian;
    protected String styleFontFamilyGenericComplex;
    protected String styleFontIndependentLineSpacing;
    protected String styleFontName;
    protected String styleFontNameAsian;
    protected String styleFontNameComplex;
    protected String styleFontPitch;
    protected String styleFontPitchAsian;
    protected String styleFontPitchComplex;
    protected String styleFontRelief;
    protected String styleFontSizeAsian;
    protected String styleFontSizeComplex;
    protected String styleFontSizeRel;
    protected String styleFontSizeRelAsian;
    protected String styleFontSizeRelComplex;
    protected String styleFontStyleAsian;
    protected String styleFontStyleComplex;
    protected String styleFontStyleName;
    protected String styleFontStyleNameAsian;
    protected String styleFontStyleNameComplex;
    protected String styleFontWeightAsian;
    protected String styleFontWeightComplex;
    protected String styleFootnoteMaxHeight;
    protected String styleGlyphOrientationVertical;
    protected String styleHorizontalPos;
    protected String styleHorizontalRel;
    protected String styleJoinBorder;
    protected String styleJustifySingleWord;
    protected String styleLanguageAsian;
    protected String styleLanguageComplex;
    protected String styleLayoutGridBaseHeight;
    protected String styleLayoutGridColor;
    protected String styleLayoutGridDisplay;
    protected String styleLayoutGridLines;
    protected String styleLayoutGridMode;
    protected String styleLayoutGridPrint;
    protected String styleLayoutGridRubyBelow;
    protected String styleLayoutGridRubyHeight;
    protected String styleLetterKerning;
    protected String styleLineBreak;
    protected String styleLineHeightAtLeast;
    protected String styleLineSpacing;
    protected String styleListStyleName;
    protected String styleMayBreakBetweenRows;
    protected String styleMinRowHeight;
    protected String styleMirror;
    protected String styleNumberWrappedParagraphs;
    protected String styleNumFormat;
    protected String styleNumLetterSync;
    protected String styleNumPrefix;
    protected String styleNumSuffix;
    protected String stylePageNumber;
    protected String stylePaperTrayName;
    protected String stylePrint;
    protected String stylePrintContent;
    protected String stylePrintOrientation;
    protected String stylePrintPageOrder;
    protected String styleProtect;
    protected String stylePunctuationWrap;
    protected String styleRegisterTrue;
    protected String styleRegisterTruthRefStyleName;
    protected String styleRelColumnWidth;
    protected String styleRelWidth;
    protected String styleRepeat;
    protected String styleRotationAlign;
    protected String styleRotationAngle;
    protected String styleRowHeight;
    protected String styleRubyAlign;
    protected String styleRubyPosition;
    protected String styleRunThrough;
    protected String styleScaleTo;
    protected String styleScaleToPages;
    protected String styleShadow;
    protected String styleSnapToLayoutGrid;
    protected String styleTableCentering;
    protected String styleTabStopDistance;
    protected String styleTextAlign;
    protected String styleTextAlignSource;
    protected String styleTextAutospace;
    protected String styleTextBackgroundColor;
    protected String styleTextBlinking;
    protected String styleTextCombine;
    protected String styleTextCombineEndChar;
    protected String styleTextCombineStartChar;
    protected String styleTextCrossingOut;
    protected String styleTextEmphasize;
    protected String styleTextOutline;
    protected String styleTextPosition;
    protected String styleTextRotationAngle;
    protected String styleTextRotationScale;
    protected String styleTextScale;
    protected String styleTextUnderline;
    protected String styleTextUnderlineColor;
    protected String styleUseOptimalColumnWidth;
    protected String styleUseOptimalRowHeight;
    protected String styleUseWindowFontColor;
    protected String styleVerticalAlign;
    protected String styleVerticalPos;
    protected String styleVerticalRel;
    protected String styleWidth;
    protected String styleWrap;
    protected String styleWrapContour;
    protected String styleWrapContourMode;
    protected String styleWritingMode;
    protected String svgHeight;
    protected String svgStrokeColor;
    protected String svgStrokeLinejoin;
    protected String svgStrokeOpacity;
    protected String svgStrokeWidth;
    protected String svgWidth;
    protected String svgX;
    protected String svgY;
    protected String tableAlign;
    protected String tableBorderModel;
    protected String tableDisplay;
    protected String tablePageStyleName;
    protected String textAnchorPageNumber;
    protected String textAnchorType;
    protected String textAnimation;
    protected String textAnimationDelay;
    protected String textAnimationDirection;
    protected String textAnimationRepeat;
    protected String textAnimationStartInside;
    protected String textAnimationSteps;
    protected String textAnimationStopInside;
    protected String textDisplay;
    protected String textDontBalanceTextColumns;
    protected String textEnableNumbering;
    protected String textLineBreak;
    protected String textLineNumber;
    protected String textMinLabelDistance;
    protected String textMinLabelWidth;
    protected String textNumberLines;
    protected String textRotationAngle;
    protected String textSpaceBefore;

    /**
     * Gets the value of the chartConnectBars property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartConnectBars() {
        if (this.chartConnectBars == null) {
            return "false";
        } else {
            return this.chartConnectBars;
        }
    }

    /**
     * Gets the value of the chartDataLabelNumber property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartDataLabelNumber() {
        if (this.chartDataLabelNumber == null) {
            return "none";
        } else {
            return this.chartDataLabelNumber;
        }
    }

    /**
     * Gets the value of the chartDataLabelSymbol property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartDataLabelSymbol() {
        if (this.chartDataLabelSymbol == null) {
            return "false";
        } else {
            return this.chartDataLabelSymbol;
        }
    }

    /**
     * Gets the value of the chartDataLabelText property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartDataLabelText() {
        if (this.chartDataLabelText == null) {
            return "false";
        } else {
            return this.chartDataLabelText;
        }
    }

    /**
     * Gets the value of the chartDeep property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartDeep() {
        if (this.chartDeep == null) {
            return "false";
        } else {
            return this.chartDeep;
        }
    }

    /**
     * Gets the value of the chartDisplayLabel property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartDisplayLabel() {
        if (this.chartDisplayLabel == null) {
            return "true";
        } else {
            return this.chartDisplayLabel;
        }
    }

    /**
     * Gets the value of the chartErrorCategory property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorCategory() {
        if (this.chartErrorCategory == null) {
            return "none";
        } else {
            return this.chartErrorCategory;
        }
    }

    /**
     * Gets the value of the chartErrorLowerIndicator property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorLowerIndicator() {
        return this.chartErrorLowerIndicator;
    }

    /**
     * Gets the value of the chartErrorLowerLimit property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorLowerLimit() {
        return this.chartErrorLowerLimit;
    }

    /**
     * Gets the value of the chartErrorMargin property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorMargin() {
        return this.chartErrorMargin;
    }

    /**
     * Gets the value of the chartErrorPercentage property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorPercentage() {
        return this.chartErrorPercentage;
    }

    /**
     * Gets the value of the chartErrorUpperIndicator property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorUpperIndicator() {
        return this.chartErrorUpperIndicator;
    }

    /**
     * Gets the value of the chartErrorUpperLimit property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartErrorUpperLimit() {
        return this.chartErrorUpperLimit;
    }

    /**
     * Gets the value of the chartGapWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartGapWidth() {
        return this.chartGapWidth;
    }

    /**
     * Gets the value of the chartIntervalMajor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartIntervalMajor() {
        return this.chartIntervalMajor;
    }

    /**
     * Gets the value of the chartIntervalMinor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartIntervalMinor() {
        return this.chartIntervalMinor;
    }

    /**
     * Gets the value of the chartLabelArrangement property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartLabelArrangement() {
        if (this.chartLabelArrangement == null) {
            return "side-by-side";
        } else {
            return this.chartLabelArrangement;
        }
    }

    /**
     * Gets the value of the chartLines property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartLines() {
        if (this.chartLines == null) {
            return "false";
        } else {
            return this.chartLines;
        }
    }

    /**
     * Gets the value of the chartLinesUsed property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartLinesUsed() {
        if (this.chartLinesUsed == null) {
            return "0";
        } else {
            return this.chartLinesUsed;
        }
    }

    /**
     * Gets the value of the chartLinkDataStyleToSource property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartLinkDataStyleToSource() {
        if (this.chartLinkDataStyleToSource == null) {
            return "true";
        } else {
            return this.chartLinkDataStyleToSource;
        }
    }

    /**
     * Gets the value of the chartLogarithmic property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartLogarithmic() {
        if (this.chartLogarithmic == null) {
            return "false";
        } else {
            return this.chartLogarithmic;
        }
    }

    /**
     * Gets the value of the chartMaximum property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartMaximum() {
        return this.chartMaximum;
    }

    /**
     * Gets the value of the chartMeanValue property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartMeanValue() {
        return this.chartMeanValue;
    }

    /**
     * Gets the value of the chartMinimum property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartMinimum() {
        return this.chartMinimum;
    }

    /**
     * Gets the value of the chartOrigin property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartOrigin() {
        return this.chartOrigin;
    }

    /**
     * Gets the value of the chartOverlap property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartOverlap() {
        return this.chartOverlap;
    }

    /**
     * Gets the value of the chartPercentage property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartPercentage() {
        if (this.chartPercentage == null) {
            return "false";
        } else {
            return this.chartPercentage;
        }
    }

    /**
     * Gets the value of the chartPieOffset property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartPieOffset() {
        if (this.chartPieOffset == null) {
            return "0";
        } else {
            return this.chartPieOffset;
        }
    }

    /**
     * Gets the value of the chartRegressionType property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartRegressionType() {
        if (this.chartRegressionType == null) {
            return "none";
        } else {
            return this.chartRegressionType;
        }
    }

    /**
     * Gets the value of the chartScaleText property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartScaleText() {
        if (this.chartScaleText == null) {
            return "true";
        } else {
            return this.chartScaleText;
        }
    }

    /**
     * Gets the value of the chartSeriesSource property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSeriesSource() {
        if (this.chartSeriesSource == null) {
            return "columns";
        } else {
            return this.chartSeriesSource;
        }
    }

    /**
     * Gets the value of the chartSolidType property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSolidType() {
        if (this.chartSolidType == null) {
            return "cuboid";
        } else {
            return this.chartSolidType;
        }
    }

    /**
     * Gets the value of the chartSplineOrder property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSplineOrder() {
        if (this.chartSplineOrder == null) {
            return "2";
        } else {
            return this.chartSplineOrder;
        }
    }

    /**
     * Gets the value of the chartSplineResolution property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSplineResolution() {
        if (this.chartSplineResolution == null) {
            return "20";
        } else {
            return this.chartSplineResolution;
        }
    }

    /**
     * Gets the value of the chartSplines property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSplines() {
        if (this.chartSplines == null) {
            return "0";
        } else {
            return this.chartSplines;
        }
    }

    /**
     * Gets the value of the chartStacked property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartStacked() {
        if (this.chartStacked == null) {
            return "false";
        } else {
            return this.chartStacked;
        }
    }

    /**
     * Gets the value of the chartStockUpdownBars property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartStockUpdownBars() {
        if (this.chartStockUpdownBars == null) {
            return "false";
        } else {
            return this.chartStockUpdownBars;
        }
    }

    /**
     * Gets the value of the chartStockWithVolume property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartStockWithVolume() {
        if (this.chartStockWithVolume == null) {
            return "false";
        } else {
            return this.chartStockWithVolume;
        }
    }

    /**
     * Gets the value of the chartSymbol property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSymbol() {
        if (this.chartSymbol == null) {
            return "-1";
        } else {
            return this.chartSymbol;
        }
    }

    /**
     * Gets the value of the chartSymbolHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSymbolHeight() {
        return this.chartSymbolHeight;
    }

    /**
     * Gets the value of the chartSymbolImageName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSymbolImageName() {
        return this.chartSymbolImageName;
    }

    /**
     * Gets the value of the chartSymbolWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartSymbolWidth() {
        return this.chartSymbolWidth;
    }

    /**
     * Gets the value of the chartTextOverlap property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartTextOverlap() {
        if (this.chartTextOverlap == null) {
            return "false";
        } else {
            return this.chartTextOverlap;
        }
    }

    /**
     * Gets the value of the chartThreeDimensional property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartThreeDimensional() {
        if (this.chartThreeDimensional == null) {
            return "false";
        } else {
            return this.chartThreeDimensional;
        }
    }

    /**
     * Gets the value of the chartTickMarksMajorInner property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartTickMarksMajorInner() {
        if (this.chartTickMarksMajorInner == null) {
            return "false";
        } else {
            return this.chartTickMarksMajorInner;
        }
    }

    /**
     * Gets the value of the chartTickMarksMajorOuter property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartTickMarksMajorOuter() {
        if (this.chartTickMarksMajorOuter == null) {
            return "true";
        } else {
            return this.chartTickMarksMajorOuter;
        }
    }

    /**
     * Gets the value of the chartTickMarksMinorInner property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartTickMarksMinorInner() {
        if (this.chartTickMarksMinorInner == null) {
            return "false";
        } else {
            return this.chartTickMarksMinorInner;
        }
    }

    /**
     * Gets the value of the chartTickMarksMinorOuter property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartTickMarksMinorOuter() {
        if (this.chartTickMarksMinorOuter == null) {
            return "false";
        } else {
            return this.chartTickMarksMinorOuter;
        }
    }

    /**
     * Gets the value of the chartVertical property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartVertical() {
        if (this.chartVertical == null) {
            return "false";
        } else {
            return this.chartVertical;
        }
    }

    /**
     * Gets the value of the chartVisible property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getChartVisible() {
        if (this.chartVisible == null) {
            return "true";
        } else {
            return this.chartVisible;
        }
    }

    /**
     * Gets the value of the content property.
     * 
     * <p>
     * This accessor method returns a reference to the live list, not a snapshot. Therefore any
     * modification you make to the returned list will be present inside the JAXB object. This is
     * why there is not a <CODE>set</CODE> method for the content property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Element } {@link String }
     * 
     * 
     */
    public List<Object> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<Object>();
        }
        return this.content;
    }

    /**
     * Gets the value of the dr3DAmbientColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DAmbientColor() {
        return this.dr3DAmbientColor;
    }

    /**
     * Gets the value of the dr3DBackfaceCulling property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DBackfaceCulling() {
        return this.dr3DBackfaceCulling;
    }

    /**
     * Gets the value of the dr3DBackScale property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DBackScale() {
        return this.dr3DBackScale;
    }

    /**
     * Gets the value of the dr3DCloseBack property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DCloseBack() {
        return this.dr3DCloseBack;
    }

    /**
     * Gets the value of the dr3DCloseFront property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DCloseFront() {
        return this.dr3DCloseFront;
    }

    /**
     * Gets the value of the dr3DDepth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DDepth() {
        return this.dr3DDepth;
    }

    /**
     * Gets the value of the dr3DDiffuseColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DDiffuseColor() {
        return this.dr3DDiffuseColor;
    }

    /**
     * Gets the value of the dr3DEdgeRounding property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DEdgeRounding() {
        return this.dr3DEdgeRounding;
    }

    /**
     * Gets the value of the dr3DEdgeRoundingMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DEdgeRoundingMode() {
        return this.dr3DEdgeRoundingMode;
    }

    /**
     * Gets the value of the dr3DEmissiveColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DEmissiveColor() {
        return this.dr3DEmissiveColor;
    }

    /**
     * Gets the value of the dr3DEndAngle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DEndAngle() {
        return this.dr3DEndAngle;
    }

    /**
     * Gets the value of the dr3DHorizontalSegments property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DHorizontalSegments() {
        return this.dr3DHorizontalSegments;
    }

    /**
     * Gets the value of the dr3DLightingMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DLightingMode() {
        return this.dr3DLightingMode;
    }

    /**
     * Gets the value of the dr3DNormalsDirection property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DNormalsDirection() {
        return this.dr3DNormalsDirection;
    }

    /**
     * Gets the value of the dr3DNormalsKind property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DNormalsKind() {
        return this.dr3DNormalsKind;
    }

    /**
     * Gets the value of the dr3DShadow property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DShadow() {
        return this.dr3DShadow;
    }

    /**
     * Gets the value of the dr3DShininess property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DShininess() {
        return this.dr3DShininess;
    }

    /**
     * Gets the value of the dr3DSpecularColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DSpecularColor() {
        return this.dr3DSpecularColor;
    }

    /**
     * Gets the value of the dr3DTextureFilter property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DTextureFilter() {
        return this.dr3DTextureFilter;
    }

    /**
     * Gets the value of the dr3DTextureGenerationModeX property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DTextureGenerationModeX() {
        return this.dr3DTextureGenerationModeX;
    }

    /**
     * Gets the value of the dr3DTextureGenerationModeY property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DTextureGenerationModeY() {
        return this.dr3DTextureGenerationModeY;
    }

    /**
     * Gets the value of the dr3DTextureKind property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DTextureKind() {
        return this.dr3DTextureKind;
    }

    /**
     * Gets the value of the dr3DTextureMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DTextureMode() {
        return this.dr3DTextureMode;
    }

    /**
     * Gets the value of the dr3DVerticalSegments property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDr3DVerticalSegments() {
        return this.dr3DVerticalSegments;
    }

    /**
     * Gets the value of the drawAutoGrowHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawAutoGrowHeight() {
        return this.drawAutoGrowHeight;
    }

    /**
     * Gets the value of the drawAutoGrowWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawAutoGrowWidth() {
        return this.drawAutoGrowWidth;
    }

    /**
     * Gets the value of the drawBackgroundSize property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawBackgroundSize() {
        return this.drawBackgroundSize;
    }

    /**
     * Gets the value of the drawBlue property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawBlue() {
        return this.drawBlue;
    }

    /**
     * Gets the value of the drawCaptionAngle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionAngle() {
        return this.drawCaptionAngle;
    }

    /**
     * Gets the value of the drawCaptionAngleType property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionAngleType() {
        return this.drawCaptionAngleType;
    }

    /**
     * Gets the value of the drawCaptionEscape property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionEscape() {
        return this.drawCaptionEscape;
    }

    /**
     * Gets the value of the drawCaptionEscapeDirection property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionEscapeDirection() {
        return this.drawCaptionEscapeDirection;
    }

    /**
     * Gets the value of the drawCaptionFitLineLength property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionFitLineLength() {
        return this.drawCaptionFitLineLength;
    }

    /**
     * Gets the value of the drawCaptionGap property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionGap() {
        return this.drawCaptionGap;
    }

    /**
     * Gets the value of the drawCaptionLineLength property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionLineLength() {
        return this.drawCaptionLineLength;
    }

    /**
     * Gets the value of the drawCaptionType property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawCaptionType() {
        return this.drawCaptionType;
    }

    /**
     * Gets the value of the drawColorInversion property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawColorInversion() {
        return this.drawColorInversion;
    }

    /**
     * Gets the value of the drawColorMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawColorMode() {
        return this.drawColorMode;
    }

    /**
     * Gets the value of the drawContrast property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawContrast() {
        return this.drawContrast;
    }

    /**
     * Gets the value of the drawDecimalPlaces property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawDecimalPlaces() {
        return this.drawDecimalPlaces;
    }

    /**
     * Gets the value of the drawEndGuide property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawEndGuide() {
        return this.drawEndGuide;
    }

    /**
     * Gets the value of the drawEndLineSpacingHorizontal property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawEndLineSpacingHorizontal() {
        return this.drawEndLineSpacingHorizontal;
    }

    /**
     * Gets the value of the drawEndLineSpacingVertical property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawEndLineSpacingVertical() {
        return this.drawEndLineSpacingVertical;
    }

    /**
     * Gets the value of the drawFill property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFill() {
        return this.drawFill;
    }

    /**
     * Gets the value of the drawFillColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillColor() {
        return this.drawFillColor;
    }

    /**
     * Gets the value of the drawFillGradientName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillGradientName() {
        return this.drawFillGradientName;
    }

    /**
     * Gets the value of the drawFillHatchName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillHatchName() {
        return this.drawFillHatchName;
    }

    /**
     * Gets the value of the drawFillHatchSolid property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillHatchSolid() {
        return this.drawFillHatchSolid;
    }

    /**
     * Gets the value of the drawFillImageHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillImageHeight() {
        return this.drawFillImageHeight;
    }

    /**
     * Gets the value of the drawFillImageName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillImageName() {
        return this.drawFillImageName;
    }

    /**
     * Gets the value of the drawFillImageRefPoint property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillImageRefPoint() {
        return this.drawFillImageRefPoint;
    }

    /**
     * Gets the value of the drawFillImageRefPointX property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillImageRefPointX() {
        return this.drawFillImageRefPointX;
    }

    /**
     * Gets the value of the drawFillImageRefPointY property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillImageRefPointY() {
        return this.drawFillImageRefPointY;
    }

    /**
     * Gets the value of the drawFillImageWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFillImageWidth() {
        return this.drawFillImageWidth;
    }

    /**
     * Gets the value of the drawFitToContour property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFitToContour() {
        return this.drawFitToContour;
    }

    /**
     * Gets the value of the drawFitToSize property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFitToSize() {
        return this.drawFitToSize;
    }

    /**
     * Gets the value of the drawFontworkAdjust property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkAdjust() {
        return this.drawFontworkAdjust;
    }

    /**
     * Gets the value of the drawFontworkDistance property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkDistance() {
        return this.drawFontworkDistance;
    }

    /**
     * Gets the value of the drawFontworkForm property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkForm() {
        return this.drawFontworkForm;
    }

    /**
     * Gets the value of the drawFontworkHideForm property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkHideForm() {
        return this.drawFontworkHideForm;
    }

    /**
     * Gets the value of the drawFontworkMirror property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkMirror() {
        return this.drawFontworkMirror;
    }

    /**
     * Gets the value of the drawFontworkOutline property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkOutline() {
        return this.drawFontworkOutline;
    }

    /**
     * Gets the value of the drawFontworkShadow property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkShadow() {
        return this.drawFontworkShadow;
    }

    /**
     * Gets the value of the drawFontworkShadowColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkShadowColor() {
        return this.drawFontworkShadowColor;
    }

    /**
     * Gets the value of the drawFontworkShadowOffsetX property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkShadowOffsetX() {
        return this.drawFontworkShadowOffsetX;
    }

    /**
     * Gets the value of the drawFontworkShadowOffsetY property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkShadowOffsetY() {
        return this.drawFontworkShadowOffsetY;
    }

    /**
     * Gets the value of the drawFontworkShadowTransparence property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkShadowTransparence() {
        return this.drawFontworkShadowTransparence;
    }

    /**
     * Gets the value of the drawFontworkStart property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkStart() {
        return this.drawFontworkStart;
    }

    /**
     * Gets the value of the drawFontworkStyle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFontworkStyle() {
        return this.drawFontworkStyle;
    }

    /**
     * Gets the value of the drawFrameDisplayBorder property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFrameDisplayBorder() {
        return this.drawFrameDisplayBorder;
    }

    /**
     * Gets the value of the drawFrameDisplayScrollbar property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFrameDisplayScrollbar() {
        return this.drawFrameDisplayScrollbar;
    }

    /**
     * Gets the value of the drawFrameMarginHorizontal property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFrameMarginHorizontal() {
        return this.drawFrameMarginHorizontal;
    }

    /**
     * Gets the value of the drawFrameMarginVertical property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawFrameMarginVertical() {
        return this.drawFrameMarginVertical;
    }

    /**
     * Gets the value of the drawGamma property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawGamma() {
        return this.drawGamma;
    }

    /**
     * Gets the value of the drawGradientStepCount property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawGradientStepCount() {
        return this.drawGradientStepCount;
    }

    /**
     * Gets the value of the drawGreen property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawGreen() {
        return this.drawGreen;
    }

    /**
     * Gets the value of the drawGuideDistance property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawGuideDistance() {
        return this.drawGuideDistance;
    }

    /**
     * Gets the value of the drawGuideOverhang property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawGuideOverhang() {
        return this.drawGuideOverhang;
    }

    /**
     * Gets the value of the drawLineDistance property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawLineDistance() {
        return this.drawLineDistance;
    }

    /**
     * Gets the value of the drawLuminance property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawLuminance() {
        return this.drawLuminance;
    }

    /**
     * Gets the value of the drawMarkerEnd property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMarkerEnd() {
        return this.drawMarkerEnd;
    }

    /**
     * Gets the value of the drawMarkerEndCenter property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMarkerEndCenter() {
        return this.drawMarkerEndCenter;
    }

    /**
     * Gets the value of the drawMarkerEndWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMarkerEndWidth() {
        return this.drawMarkerEndWidth;
    }

    /**
     * Gets the value of the drawMarkerStart property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMarkerStart() {
        return this.drawMarkerStart;
    }

    /**
     * Gets the value of the drawMarkerStartCenter property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMarkerStartCenter() {
        return this.drawMarkerStartCenter;
    }

    /**
     * Gets the value of the drawMarkerStartWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMarkerStartWidth() {
        return this.drawMarkerStartWidth;
    }

    /**
     * Gets the value of the drawMeasureAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMeasureAlign() {
        return this.drawMeasureAlign;
    }

    /**
     * Gets the value of the drawMeasureVerticalAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMeasureVerticalAlign() {
        return this.drawMeasureVerticalAlign;
    }

    /**
     * Gets the value of the drawMirror property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMirror() {
        return this.drawMirror;
    }

    /**
     * Gets the value of the drawMoveProtect property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawMoveProtect() {
        return this.drawMoveProtect;
    }

    /**
     * Gets the value of the drawParallel property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawParallel() {
        return this.drawParallel;
    }

    /**
     * Gets the value of the drawPlacing property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawPlacing() {
        return this.drawPlacing;
    }

    /**
     * Gets the value of the drawRed property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawRed() {
        return this.drawRed;
    }

    /**
     * Gets the value of the drawShadow property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawShadow() {
        return this.drawShadow;
    }

    /**
     * Gets the value of the drawShadowColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawShadowColor() {
        return this.drawShadowColor;
    }

    /**
     * Gets the value of the drawShadowOffsetX property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawShadowOffsetX() {
        return this.drawShadowOffsetX;
    }

    /**
     * Gets the value of the drawShadowOffsetY property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawShadowOffsetY() {
        return this.drawShadowOffsetY;
    }

    /**
     * Gets the value of the drawShadowTransparency property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawShadowTransparency() {
        return this.drawShadowTransparency;
    }

    /**
     * Gets the value of the drawShowUnit property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawShowUnit() {
        return this.drawShowUnit;
    }

    /**
     * Gets the value of the drawSizeProtect property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawSizeProtect() {
        return this.drawSizeProtect;
    }

    /**
     * Gets the value of the drawStartGuide property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawStartGuide() {
        return this.drawStartGuide;
    }

    /**
     * Gets the value of the drawStartLineSpacingHorizontal property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawStartLineSpacingHorizontal() {
        return this.drawStartLineSpacingHorizontal;
    }

    /**
     * Gets the value of the drawStartLineSpacingVertical property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawStartLineSpacingVertical() {
        return this.drawStartLineSpacingVertical;
    }

    /**
     * Gets the value of the drawStroke property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawStroke() {
        return this.drawStroke;
    }

    /**
     * Gets the value of the drawStrokeDash property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawStrokeDash() {
        return this.drawStrokeDash;
    }

    /**
     * Gets the value of the drawSymbolColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawSymbolColor() {
        return this.drawSymbolColor;
    }

    /**
     * Gets the value of the drawTextareaHorizontalAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawTextareaHorizontalAlign() {
        return this.drawTextareaHorizontalAlign;
    }

    /**
     * Gets the value of the drawTextareaVerticalAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawTextareaVerticalAlign() {
        return this.drawTextareaVerticalAlign;
    }

    /**
     * Gets the value of the drawTileRepeatOffset property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawTileRepeatOffset() {
        return this.drawTileRepeatOffset;
    }

    /**
     * Gets the value of the drawTransparency property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawTransparency() {
        return this.drawTransparency;
    }

    /**
     * Gets the value of the drawTransparencyName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawTransparencyName() {
        return this.drawTransparencyName;
    }

    /**
     * Gets the value of the drawUnit property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawUnit() {
        return this.drawUnit;
    }

    /**
     * Gets the value of the drawVisibleAreaHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawVisibleAreaHeight() {
        return this.drawVisibleAreaHeight;
    }

    /**
     * Gets the value of the drawVisibleAreaLeft property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawVisibleAreaLeft() {
        return this.drawVisibleAreaLeft;
    }

    /**
     * Gets the value of the drawVisibleAreaTop property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawVisibleAreaTop() {
        return this.drawVisibleAreaTop;
    }

    /**
     * Gets the value of the drawVisibleAreaWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawVisibleAreaWidth() {
        return this.drawVisibleAreaWidth;
    }

    /**
     * Gets the value of the drawWritingMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getDrawWritingMode() {
        if (this.drawWritingMode == null) {
            return "lr-tb";
        } else {
            return this.drawWritingMode;
        }
    }

    /**
     * Gets the value of the foBackgroundColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBackgroundColor() {
        return this.foBackgroundColor;
    }

    /**
     * Gets the value of the foBorder property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBorder() {
        return this.foBorder;
    }

    /**
     * Gets the value of the foBorderBottom property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBorderBottom() {
        return this.foBorderBottom;
    }

    /**
     * Gets the value of the foBorderLeft property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBorderLeft() {
        return this.foBorderLeft;
    }

    /**
     * Gets the value of the foBorderRight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBorderRight() {
        return this.foBorderRight;
    }

    /**
     * Gets the value of the foBorderTop property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBorderTop() {
        return this.foBorderTop;
    }

    /**
     * Gets the value of the foBreakAfter property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBreakAfter() {
        return this.foBreakAfter;
    }

    /**
     * Gets the value of the foBreakBefore property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoBreakBefore() {
        return this.foBreakBefore;
    }

    /**
     * Gets the value of the foClip property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoClip() {
        return this.foClip;
    }

    /**
     * Gets the value of the foColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoColor() {
        return this.foColor;
    }

    /**
     * Gets the value of the foCountry property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoCountry() {
        return this.foCountry;
    }

    /**
     * Gets the value of the foDirection property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoDirection() {
        return this.foDirection;
    }

    /**
     * Gets the value of the foFontFamily property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoFontFamily() {
        return this.foFontFamily;
    }

    /**
     * Gets the value of the foFontSize property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoFontSize() {
        return this.foFontSize;
    }

    /**
     * Gets the value of the foFontStyle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoFontStyle() {
        return this.foFontStyle;
    }

    /**
     * Gets the value of the foFontVariant property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoFontVariant() {
        return this.foFontVariant;
    }

    /**
     * Gets the value of the foFontWeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoFontWeight() {
        return this.foFontWeight;
    }

    /**
     * Gets the value of the foHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoHeight() {
        return this.foHeight;
    }

    /**
     * Gets the value of the foHyphenate property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoHyphenate() {
        return this.foHyphenate;
    }

    /**
     * Gets the value of the foHyphenateKeep property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoHyphenateKeep() {
        return this.foHyphenateKeep;
    }

    /**
     * Gets the value of the foHyphenationLadderCount property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoHyphenationLadderCount() {
        return this.foHyphenationLadderCount;
    }

    /**
     * Gets the value of the foHyphenationPushCharCount property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoHyphenationPushCharCount() {
        return this.foHyphenationPushCharCount;
    }

    /**
     * Gets the value of the foHyphenationRemainCharCount property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoHyphenationRemainCharCount() {
        return this.foHyphenationRemainCharCount;
    }

    /**
     * Gets the value of the foKeepTogether property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoKeepTogether() {
        return this.foKeepTogether;
    }

    /**
     * Gets the value of the foKeepWithNext property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoKeepWithNext() {
        return this.foKeepWithNext;
    }

    /**
     * Gets the value of the foLanguage property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoLanguage() {
        return this.foLanguage;
    }

    /**
     * Gets the value of the foLetterSpacing property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoLetterSpacing() {
        return this.foLetterSpacing;
    }

    /**
     * Gets the value of the foLineHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoLineHeight() {
        return this.foLineHeight;
    }

    /**
     * Gets the value of the foMarginBottom property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMarginBottom() {
        return this.foMarginBottom;
    }

    /**
     * Gets the value of the foMarginLeft property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMarginLeft() {
        return this.foMarginLeft;
    }

    /**
     * Gets the value of the foMarginRight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMarginRight() {
        return this.foMarginRight;
    }

    /**
     * Gets the value of the foMarginTop property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMarginTop() {
        return this.foMarginTop;
    }

    /**
     * Gets the value of the foMaxHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMaxHeight() {
        return this.foMaxHeight;
    }

    /**
     * Gets the value of the foMaxWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMaxWidth() {
        return this.foMaxWidth;
    }

    /**
     * Gets the value of the foMinHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMinHeight() {
        return this.foMinHeight;
    }

    /**
     * Gets the value of the foMinWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoMinWidth() {
        return this.foMinWidth;
    }

    /**
     * Gets the value of the foOrphans property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoOrphans() {
        return this.foOrphans;
    }

    /**
     * Gets the value of the foPadding property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPadding() {
        return this.foPadding;
    }

    /**
     * Gets the value of the foPaddingBottom property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPaddingBottom() {
        return this.foPaddingBottom;
    }

    /**
     * Gets the value of the foPaddingLeft property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPaddingLeft() {
        return this.foPaddingLeft;
    }

    /**
     * Gets the value of the foPaddingRight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPaddingRight() {
        return this.foPaddingRight;
    }

    /**
     * Gets the value of the foPaddingTop property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPaddingTop() {
        return this.foPaddingTop;
    }

    /**
     * Gets the value of the foPageHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPageHeight() {
        return this.foPageHeight;
    }

    /**
     * Gets the value of the foPageWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoPageWidth() {
        return this.foPageWidth;
    }

    /**
     * Gets the value of the foScoreSpaces property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoScoreSpaces() {
        return this.foScoreSpaces;
    }

    /**
     * Gets the value of the foTextAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoTextAlign() {
        return this.foTextAlign;
    }

    /**
     * Gets the value of the foTextAlignLast property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoTextAlignLast() {
        return this.foTextAlignLast;
    }

    /**
     * Gets the value of the foTextIndent property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoTextIndent() {
        return this.foTextIndent;
    }

    /**
     * Gets the value of the foTextShadow property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoTextShadow() {
        return this.foTextShadow;
    }

    /**
     * Gets the value of the foTextTransform property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoTextTransform() {
        return this.foTextTransform;
    }

    /**
     * Gets the value of the foVerticalAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoVerticalAlign() {
        return this.foVerticalAlign;
    }

    /**
     * Gets the value of the foWidows property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoWidows() {
        return this.foWidows;
    }

    /**
     * Gets the value of the foWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoWidth() {
        return this.foWidth;
    }

    /**
     * Gets the value of the foWrapOption property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getFoWrapOption() {
        return this.foWrapOption;
    }

    /**
     * Gets the value of the presentationBackgroundObjectsVisible property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationBackgroundObjectsVisible() {
        return this.presentationBackgroundObjectsVisible;
    }

    /**
     * Gets the value of the presentationBackgroundVisible property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationBackgroundVisible() {
        return this.presentationBackgroundVisible;
    }

    /**
     * Gets the value of the presentationDuration property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationDuration() {
        return this.presentationDuration;
    }

    /**
     * Gets the value of the presentationTransitionSpeed property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationTransitionSpeed() {
        return this.presentationTransitionSpeed;
    }

    /**
     * Gets the value of the presentationTransitionStyle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationTransitionStyle() {
        return this.presentationTransitionStyle;
    }

    /**
     * Gets the value of the presentationTransitionType property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationTransitionType() {
        return this.presentationTransitionType;
    }

    /**
     * Gets the value of the presentationVisibility property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getPresentationVisibility() {
        return this.presentationVisibility;
    }

    /**
     * Gets the value of the styleAutoTextIndent property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleAutoTextIndent() {
        return this.styleAutoTextIndent;
    }

    /**
     * Gets the value of the styleBackgroundTransparency property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBackgroundTransparency() {
        return this.styleBackgroundTransparency;
    }

    /**
     * Gets the value of the styleBorderLineWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBorderLineWidth() {
        return this.styleBorderLineWidth;
    }

    /**
     * Gets the value of the styleBorderLineWidthBottom property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBorderLineWidthBottom() {
        return this.styleBorderLineWidthBottom;
    }

    /**
     * Gets the value of the styleBorderLineWidthLeft property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBorderLineWidthLeft() {
        return this.styleBorderLineWidthLeft;
    }

    /**
     * Gets the value of the styleBorderLineWidthRight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBorderLineWidthRight() {
        return this.styleBorderLineWidthRight;
    }

    /**
     * Gets the value of the styleBorderLineWidthTop property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBorderLineWidthTop() {
        return this.styleBorderLineWidthTop;
    }

    /**
     * Gets the value of the styleBreakInside property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleBreakInside() {
        return this.styleBreakInside;
    }

    /**
     * Gets the value of the styleCellProtect property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleCellProtect() {
        return this.styleCellProtect;
    }

    /**
     * Gets the value of the styleColumnWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleColumnWidth() {
        return this.styleColumnWidth;
    }

    /**
     * Gets the value of the styleCountryAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleCountryAsian() {
        return this.styleCountryAsian;
    }

    /**
     * Gets the value of the styleCountryComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleCountryComplex() {
        return this.styleCountryComplex;
    }

    /**
     * Gets the value of the styleDecimalPlaces property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleDecimalPlaces() {
        return this.styleDecimalPlaces;
    }

    /**
     * Gets the value of the styleDynamicSpacing property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleDynamicSpacing() {
        return this.styleDynamicSpacing;
    }

    /**
     * Gets the value of the styleEditable property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleEditable() {
        return this.styleEditable;
    }

    /**
     * Gets the value of the styleFirstPageNumber property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFirstPageNumber() {
        return this.styleFirstPageNumber;
    }

    /**
     * Gets the value of the styleFontCharset property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontCharset() {
        return this.styleFontCharset;
    }

    /**
     * Gets the value of the styleFontCharsetAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontCharsetAsian() {
        return this.styleFontCharsetAsian;
    }

    /**
     * Gets the value of the styleFontCharsetComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontCharsetComplex() {
        return this.styleFontCharsetComplex;
    }

    /**
     * Gets the value of the styleFontFamilyAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontFamilyAsian() {
        return this.styleFontFamilyAsian;
    }

    /**
     * Gets the value of the styleFontFamilyComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontFamilyComplex() {
        return this.styleFontFamilyComplex;
    }

    /**
     * Gets the value of the styleFontFamilyGeneric property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontFamilyGeneric() {
        return this.styleFontFamilyGeneric;
    }

    /**
     * Gets the value of the styleFontFamilyGenericAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontFamilyGenericAsian() {
        return this.styleFontFamilyGenericAsian;
    }

    /**
     * Gets the value of the styleFontFamilyGenericComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontFamilyGenericComplex() {
        return this.styleFontFamilyGenericComplex;
    }

    /**
     * Gets the value of the styleFontIndependentLineSpacing property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontIndependentLineSpacing() {
        return this.styleFontIndependentLineSpacing;
    }

    /**
     * Gets the value of the styleFontName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontName() {
        return this.styleFontName;
    }

    /**
     * Gets the value of the styleFontNameAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontNameAsian() {
        return this.styleFontNameAsian;
    }

    /**
     * Gets the value of the styleFontNameComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontNameComplex() {
        return this.styleFontNameComplex;
    }

    /**
     * Gets the value of the styleFontPitch property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontPitch() {
        return this.styleFontPitch;
    }

    /**
     * Gets the value of the styleFontPitchAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontPitchAsian() {
        return this.styleFontPitchAsian;
    }

    /**
     * Gets the value of the styleFontPitchComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontPitchComplex() {
        return this.styleFontPitchComplex;
    }

    /**
     * Gets the value of the styleFontRelief property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontRelief() {
        return this.styleFontRelief;
    }

    /**
     * Gets the value of the styleFontSizeAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontSizeAsian() {
        return this.styleFontSizeAsian;
    }

    /**
     * Gets the value of the styleFontSizeComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontSizeComplex() {
        return this.styleFontSizeComplex;
    }

    /**
     * Gets the value of the styleFontSizeRel property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontSizeRel() {
        return this.styleFontSizeRel;
    }

    /**
     * Gets the value of the styleFontSizeRelAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontSizeRelAsian() {
        return this.styleFontSizeRelAsian;
    }

    /**
     * Gets the value of the styleFontSizeRelComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontSizeRelComplex() {
        return this.styleFontSizeRelComplex;
    }

    /**
     * Gets the value of the styleFontStyleAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontStyleAsian() {
        return this.styleFontStyleAsian;
    }

    /**
     * Gets the value of the styleFontStyleComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontStyleComplex() {
        return this.styleFontStyleComplex;
    }

    /**
     * Gets the value of the styleFontStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontStyleName() {
        return this.styleFontStyleName;
    }

    /**
     * Gets the value of the styleFontStyleNameAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontStyleNameAsian() {
        return this.styleFontStyleNameAsian;
    }

    /**
     * Gets the value of the styleFontStyleNameComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontStyleNameComplex() {
        return this.styleFontStyleNameComplex;
    }

    /**
     * Gets the value of the styleFontWeightAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontWeightAsian() {
        return this.styleFontWeightAsian;
    }

    /**
     * Gets the value of the styleFontWeightComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFontWeightComplex() {
        return this.styleFontWeightComplex;
    }

    /**
     * Gets the value of the styleFootnoteMaxHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleFootnoteMaxHeight() {
        return this.styleFootnoteMaxHeight;
    }

    /**
     * Gets the value of the styleGlyphOrientationVertical property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleGlyphOrientationVertical() {
        return this.styleGlyphOrientationVertical;
    }

    /**
     * Gets the value of the styleHorizontalPos property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleHorizontalPos() {
        return this.styleHorizontalPos;
    }

    /**
     * Gets the value of the styleHorizontalRel property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleHorizontalRel() {
        return this.styleHorizontalRel;
    }

    /**
     * Gets the value of the styleJoinBorder property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleJoinBorder() {
        return this.styleJoinBorder;
    }

    /**
     * Gets the value of the styleJustifySingleWord property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleJustifySingleWord() {
        return this.styleJustifySingleWord;
    }

    /**
     * Gets the value of the styleLanguageAsian property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLanguageAsian() {
        return this.styleLanguageAsian;
    }

    /**
     * Gets the value of the styleLanguageComplex property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLanguageComplex() {
        return this.styleLanguageComplex;
    }

    /**
     * Gets the value of the styleLayoutGridBaseHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridBaseHeight() {
        return this.styleLayoutGridBaseHeight;
    }

    /**
     * Gets the value of the styleLayoutGridColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridColor() {
        return this.styleLayoutGridColor;
    }

    /**
     * Gets the value of the styleLayoutGridDisplay property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridDisplay() {
        return this.styleLayoutGridDisplay;
    }

    /**
     * Gets the value of the styleLayoutGridLines property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridLines() {
        return this.styleLayoutGridLines;
    }

    /**
     * Gets the value of the styleLayoutGridMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridMode() {
        return this.styleLayoutGridMode;
    }

    /**
     * Gets the value of the styleLayoutGridPrint property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridPrint() {
        return this.styleLayoutGridPrint;
    }

    /**
     * Gets the value of the styleLayoutGridRubyBelow property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridRubyBelow() {
        return this.styleLayoutGridRubyBelow;
    }

    /**
     * Gets the value of the styleLayoutGridRubyHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLayoutGridRubyHeight() {
        return this.styleLayoutGridRubyHeight;
    }

    /**
     * Gets the value of the styleLetterKerning property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLetterKerning() {
        return this.styleLetterKerning;
    }

    /**
     * Gets the value of the styleLineBreak property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLineBreak() {
        return this.styleLineBreak;
    }

    /**
     * Gets the value of the styleLineHeightAtLeast property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLineHeightAtLeast() {
        return this.styleLineHeightAtLeast;
    }

    /**
     * Gets the value of the styleLineSpacing property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleLineSpacing() {
        return this.styleLineSpacing;
    }

    /**
     * Gets the value of the styleListStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleListStyleName() {
        return this.styleListStyleName;
    }

    /**
     * Gets the value of the styleMayBreakBetweenRows property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleMayBreakBetweenRows() {
        return this.styleMayBreakBetweenRows;
    }

    /**
     * Gets the value of the styleMinRowHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleMinRowHeight() {
        return this.styleMinRowHeight;
    }

    /**
     * Gets the value of the styleMirror property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleMirror() {
        return this.styleMirror;
    }

    /**
     * Gets the value of the styleNumberWrappedParagraphs property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleNumberWrappedParagraphs() {
        return this.styleNumberWrappedParagraphs;
    }

    /**
     * Gets the value of the styleNumFormat property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleNumFormat() {
        return this.styleNumFormat;
    }

    /**
     * Gets the value of the styleNumLetterSync property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleNumLetterSync() {
        return this.styleNumLetterSync;
    }

    /**
     * Gets the value of the styleNumPrefix property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleNumPrefix() {
        return this.styleNumPrefix;
    }

    /**
     * Gets the value of the styleNumSuffix property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleNumSuffix() {
        return this.styleNumSuffix;
    }

    /**
     * Gets the value of the stylePageNumber property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePageNumber() {
        return this.stylePageNumber;
    }

    /**
     * Gets the value of the stylePaperTrayName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePaperTrayName() {
        return this.stylePaperTrayName;
    }

    /**
     * Gets the value of the stylePrint property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePrint() {
        return this.stylePrint;
    }

    /**
     * Gets the value of the stylePrintContent property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePrintContent() {
        return this.stylePrintContent;
    }

    /**
     * Gets the value of the stylePrintOrientation property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePrintOrientation() {
        return this.stylePrintOrientation;
    }

    /**
     * Gets the value of the stylePrintPageOrder property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePrintPageOrder() {
        return this.stylePrintPageOrder;
    }

    /**
     * Gets the value of the styleProtect property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleProtect() {
        return this.styleProtect;
    }

    /**
     * Gets the value of the stylePunctuationWrap property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStylePunctuationWrap() {
        return this.stylePunctuationWrap;
    }

    /**
     * Gets the value of the styleRegisterTrue property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRegisterTrue() {
        return this.styleRegisterTrue;
    }

    /**
     * Gets the value of the styleRegisterTruthRefStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRegisterTruthRefStyleName() {
        return this.styleRegisterTruthRefStyleName;
    }

    /**
     * Gets the value of the styleRelColumnWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRelColumnWidth() {
        return this.styleRelColumnWidth;
    }

    /**
     * Gets the value of the styleRelWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRelWidth() {
        return this.styleRelWidth;
    }

    /**
     * Gets the value of the styleRepeat property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRepeat() {
        return this.styleRepeat;
    }

    /**
     * Gets the value of the styleRotationAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRotationAlign() {
        return this.styleRotationAlign;
    }

    /**
     * Gets the value of the styleRotationAngle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRotationAngle() {
        return this.styleRotationAngle;
    }

    /**
     * Gets the value of the styleRowHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRowHeight() {
        return this.styleRowHeight;
    }

    /**
     * Gets the value of the styleRubyAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRubyAlign() {
        return this.styleRubyAlign;
    }

    /**
     * Gets the value of the styleRubyPosition property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRubyPosition() {
        return this.styleRubyPosition;
    }

    /**
     * Gets the value of the styleRunThrough property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleRunThrough() {
        return this.styleRunThrough;
    }

    /**
     * Gets the value of the styleScaleTo property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleScaleTo() {
        return this.styleScaleTo;
    }

    /**
     * Gets the value of the styleScaleToPages property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleScaleToPages() {
        return this.styleScaleToPages;
    }

    /**
     * Gets the value of the styleShadow property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleShadow() {
        return this.styleShadow;
    }

    /**
     * Gets the value of the styleSnapToLayoutGrid property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleSnapToLayoutGrid() {
        return this.styleSnapToLayoutGrid;
    }

    /**
     * Gets the value of the styleTableCentering property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTableCentering() {
        return this.styleTableCentering;
    }

    /**
     * Gets the value of the styleTabStopDistance property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTabStopDistance() {
        return this.styleTabStopDistance;
    }

    /**
     * Gets the value of the styleTextAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextAlign() {
        return this.styleTextAlign;
    }

    /**
     * Gets the value of the styleTextAlignSource property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextAlignSource() {
        return this.styleTextAlignSource;
    }

    /**
     * Gets the value of the styleTextAutospace property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextAutospace() {
        return this.styleTextAutospace;
    }

    /**
     * Gets the value of the styleTextBackgroundColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextBackgroundColor() {
        return this.styleTextBackgroundColor;
    }

    /**
     * Gets the value of the styleTextBlinking property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextBlinking() {
        return this.styleTextBlinking;
    }

    /**
     * Gets the value of the styleTextCombine property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextCombine() {
        return this.styleTextCombine;
    }

    /**
     * Gets the value of the styleTextCombineEndChar property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextCombineEndChar() {
        return this.styleTextCombineEndChar;
    }

    /**
     * Gets the value of the styleTextCombineStartChar property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextCombineStartChar() {
        return this.styleTextCombineStartChar;
    }

    /**
     * Gets the value of the styleTextCrossingOut property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextCrossingOut() {
        return this.styleTextCrossingOut;
    }

    /**
     * Gets the value of the styleTextEmphasize property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextEmphasize() {
        return this.styleTextEmphasize;
    }

    /**
     * Gets the value of the styleTextOutline property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextOutline() {
        return this.styleTextOutline;
    }

    /**
     * Gets the value of the styleTextPosition property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextPosition() {
        return this.styleTextPosition;
    }

    /**
     * Gets the value of the styleTextRotationAngle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextRotationAngle() {
        return this.styleTextRotationAngle;
    }

    /**
     * Gets the value of the styleTextRotationScale property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextRotationScale() {
        return this.styleTextRotationScale;
    }

    /**
     * Gets the value of the styleTextScale property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextScale() {
        return this.styleTextScale;
    }

    /**
     * Gets the value of the styleTextUnderline property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextUnderline() {
        return this.styleTextUnderline;
    }

    /**
     * Gets the value of the styleTextUnderlineColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleTextUnderlineColor() {
        return this.styleTextUnderlineColor;
    }

    /**
     * Gets the value of the styleUseOptimalColumnWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleUseOptimalColumnWidth() {
        return this.styleUseOptimalColumnWidth;
    }

    /**
     * Gets the value of the styleUseOptimalRowHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleUseOptimalRowHeight() {
        return this.styleUseOptimalRowHeight;
    }

    /**
     * Gets the value of the styleUseWindowFontColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleUseWindowFontColor() {
        return this.styleUseWindowFontColor;
    }

    /**
     * Gets the value of the styleVerticalAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleVerticalAlign() {
        return this.styleVerticalAlign;
    }

    /**
     * Gets the value of the styleVerticalPos property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleVerticalPos() {
        return this.styleVerticalPos;
    }

    /**
     * Gets the value of the styleVerticalRel property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleVerticalRel() {
        return this.styleVerticalRel;
    }

    /**
     * Gets the value of the styleWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleWidth() {
        return this.styleWidth;
    }

    /**
     * Gets the value of the styleWrap property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleWrap() {
        return this.styleWrap;
    }

    /**
     * Gets the value of the styleWrapContour property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleWrapContour() {
        return this.styleWrapContour;
    }

    /**
     * Gets the value of the styleWrapContourMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleWrapContourMode() {
        return this.styleWrapContourMode;
    }

    /**
     * Gets the value of the styleWritingMode property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getStyleWritingMode() {
        if (this.styleWritingMode == null) {
            return "lr-tb";
        } else {
            return this.styleWritingMode;
        }
    }

    /**
     * Gets the value of the svgHeight property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgHeight() {
        return this.svgHeight;
    }

    /**
     * Gets the value of the svgStrokeColor property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgStrokeColor() {
        return this.svgStrokeColor;
    }

    /**
     * Gets the value of the svgStrokeLinejoin property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgStrokeLinejoin() {
        return this.svgStrokeLinejoin;
    }

    /**
     * Gets the value of the svgStrokeOpacity property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgStrokeOpacity() {
        return this.svgStrokeOpacity;
    }

    /**
     * Gets the value of the svgStrokeWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgStrokeWidth() {
        return this.svgStrokeWidth;
    }

    /**
     * Gets the value of the svgWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgWidth() {
        return this.svgWidth;
    }

    /**
     * Gets the value of the svgX property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgX() {
        return this.svgX;
    }

    /**
     * Gets the value of the svgY property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getSvgY() {
        return this.svgY;
    }

    /**
     * Gets the value of the tableAlign property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableAlign() {
        return this.tableAlign;
    }

    /**
     * Gets the value of the tableBorderModel property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableBorderModel() {
        return this.tableBorderModel;
    }

    /**
     * Gets the value of the tableDisplay property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTableDisplay() {
        return this.tableDisplay;
    }

    /**
     * Gets the value of the tablePageStyleName property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTablePageStyleName() {
        return this.tablePageStyleName;
    }

    /**
     * Gets the value of the textAnchorPageNumber property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnchorPageNumber() {
        return this.textAnchorPageNumber;
    }

    /**
     * Gets the value of the textAnchorType property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnchorType() {
        return this.textAnchorType;
    }

    /**
     * Gets the value of the textAnimation property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimation() {
        return this.textAnimation;
    }

    /**
     * Gets the value of the textAnimationDelay property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimationDelay() {
        return this.textAnimationDelay;
    }

    /**
     * Gets the value of the textAnimationDirection property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimationDirection() {
        return this.textAnimationDirection;
    }

    /**
     * Gets the value of the textAnimationRepeat property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimationRepeat() {
        return this.textAnimationRepeat;
    }

    /**
     * Gets the value of the textAnimationStartInside property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimationStartInside() {
        return this.textAnimationStartInside;
    }

    /**
     * Gets the value of the textAnimationSteps property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimationSteps() {
        return this.textAnimationSteps;
    }

    /**
     * Gets the value of the textAnimationStopInside property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextAnimationStopInside() {
        return this.textAnimationStopInside;
    }

    /**
     * Gets the value of the textDisplay property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextDisplay() {
        return this.textDisplay;
    }

    /**
     * Gets the value of the textDontBalanceTextColumns property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextDontBalanceTextColumns() {
        return this.textDontBalanceTextColumns;
    }

    /**
     * Gets the value of the textEnableNumbering property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextEnableNumbering() {
        return this.textEnableNumbering;
    }

    /**
     * Gets the value of the textLineBreak property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextLineBreak() {
        if (this.textLineBreak == null) {
            return "true";
        } else {
            return this.textLineBreak;
        }
    }

    /**
     * Gets the value of the textLineNumber property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextLineNumber() {
        return this.textLineNumber;
    }

    /**
     * Gets the value of the textMinLabelDistance property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextMinLabelDistance() {
        return this.textMinLabelDistance;
    }

    /**
     * Gets the value of the textMinLabelWidth property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextMinLabelWidth() {
        return this.textMinLabelWidth;
    }

    /**
     * Gets the value of the textNumberLines property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextNumberLines() {
        if (this.textNumberLines == null) {
            return "false";
        } else {
            return this.textNumberLines;
        }
    }

    /**
     * Gets the value of the textRotationAngle property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextRotationAngle() {
        if (this.textRotationAngle == null) {
            return "0";
        } else {
            return this.textRotationAngle;
        }
    }

    /**
     * Gets the value of the textSpaceBefore property.
     * 
     * @return possible object is {@link String }
     * 
     */
    public String getTextSpaceBefore() {
        return this.textSpaceBefore;
    }

    /**
     * Sets the value of the chartConnectBars property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartConnectBars(final String value) {
        this.chartConnectBars = value;
    }

    /**
     * Sets the value of the chartDataLabelNumber property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartDataLabelNumber(final String value) {
        this.chartDataLabelNumber = value;
    }

    /**
     * Sets the value of the chartDataLabelSymbol property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartDataLabelSymbol(final String value) {
        this.chartDataLabelSymbol = value;
    }

    /**
     * Sets the value of the chartDataLabelText property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartDataLabelText(final String value) {
        this.chartDataLabelText = value;
    }

    /**
     * Sets the value of the chartDeep property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartDeep(final String value) {
        this.chartDeep = value;
    }

    /**
     * Sets the value of the chartDisplayLabel property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartDisplayLabel(final String value) {
        this.chartDisplayLabel = value;
    }

    /**
     * Sets the value of the chartErrorCategory property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorCategory(final String value) {
        this.chartErrorCategory = value;
    }

    /**
     * Sets the value of the chartErrorLowerIndicator property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorLowerIndicator(final String value) {
        this.chartErrorLowerIndicator = value;
    }

    /**
     * Sets the value of the chartErrorLowerLimit property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorLowerLimit(final String value) {
        this.chartErrorLowerLimit = value;
    }

    /**
     * Sets the value of the chartErrorMargin property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorMargin(final String value) {
        this.chartErrorMargin = value;
    }

    /**
     * Sets the value of the chartErrorPercentage property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorPercentage(final String value) {
        this.chartErrorPercentage = value;
    }

    /**
     * Sets the value of the chartErrorUpperIndicator property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorUpperIndicator(final String value) {
        this.chartErrorUpperIndicator = value;
    }

    /**
     * Sets the value of the chartErrorUpperLimit property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartErrorUpperLimit(final String value) {
        this.chartErrorUpperLimit = value;
    }

    /**
     * Sets the value of the chartGapWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartGapWidth(final String value) {
        this.chartGapWidth = value;
    }

    /**
     * Sets the value of the chartIntervalMajor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartIntervalMajor(final String value) {
        this.chartIntervalMajor = value;
    }

    /**
     * Sets the value of the chartIntervalMinor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartIntervalMinor(final String value) {
        this.chartIntervalMinor = value;
    }

    /**
     * Sets the value of the chartLabelArrangement property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartLabelArrangement(final String value) {
        this.chartLabelArrangement = value;
    }

    /**
     * Sets the value of the chartLines property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartLines(final String value) {
        this.chartLines = value;
    }

    /**
     * Sets the value of the chartLinesUsed property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartLinesUsed(final String value) {
        this.chartLinesUsed = value;
    }

    /**
     * Sets the value of the chartLinkDataStyleToSource property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartLinkDataStyleToSource(final String value) {
        this.chartLinkDataStyleToSource = value;
    }

    /**
     * Sets the value of the chartLogarithmic property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartLogarithmic(final String value) {
        this.chartLogarithmic = value;
    }

    /**
     * Sets the value of the chartMaximum property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartMaximum(final String value) {
        this.chartMaximum = value;
    }

    /**
     * Sets the value of the chartMeanValue property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartMeanValue(final String value) {
        this.chartMeanValue = value;
    }

    /**
     * Sets the value of the chartMinimum property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartMinimum(final String value) {
        this.chartMinimum = value;
    }

    /**
     * Sets the value of the chartOrigin property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartOrigin(final String value) {
        this.chartOrigin = value;
    }

    /**
     * Sets the value of the chartOverlap property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartOverlap(final String value) {
        this.chartOverlap = value;
    }

    /**
     * Sets the value of the chartPercentage property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartPercentage(final String value) {
        this.chartPercentage = value;
    }

    /**
     * Sets the value of the chartPieOffset property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartPieOffset(final String value) {
        this.chartPieOffset = value;
    }

    /**
     * Sets the value of the chartRegressionType property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartRegressionType(final String value) {
        this.chartRegressionType = value;
    }

    /**
     * Sets the value of the chartScaleText property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartScaleText(final String value) {
        this.chartScaleText = value;
    }

    /**
     * Sets the value of the chartSeriesSource property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSeriesSource(final String value) {
        this.chartSeriesSource = value;
    }

    /**
     * Sets the value of the chartSolidType property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSolidType(final String value) {
        this.chartSolidType = value;
    }

    /**
     * Sets the value of the chartSplineOrder property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSplineOrder(final String value) {
        this.chartSplineOrder = value;
    }

    /**
     * Sets the value of the chartSplineResolution property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSplineResolution(final String value) {
        this.chartSplineResolution = value;
    }

    /**
     * Sets the value of the chartSplines property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSplines(final String value) {
        this.chartSplines = value;
    }

    /**
     * Sets the value of the chartStacked property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartStacked(final String value) {
        this.chartStacked = value;
    }

    /**
     * Sets the value of the chartStockUpdownBars property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartStockUpdownBars(final String value) {
        this.chartStockUpdownBars = value;
    }

    /**
     * Sets the value of the chartStockWithVolume property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartStockWithVolume(final String value) {
        this.chartStockWithVolume = value;
    }

    /**
     * Sets the value of the chartSymbol property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSymbol(final String value) {
        this.chartSymbol = value;
    }

    /**
     * Sets the value of the chartSymbolHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSymbolHeight(final String value) {
        this.chartSymbolHeight = value;
    }

    /**
     * Sets the value of the chartSymbolImageName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSymbolImageName(final String value) {
        this.chartSymbolImageName = value;
    }

    /**
     * Sets the value of the chartSymbolWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartSymbolWidth(final String value) {
        this.chartSymbolWidth = value;
    }

    /**
     * Sets the value of the chartTextOverlap property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartTextOverlap(final String value) {
        this.chartTextOverlap = value;
    }

    /**
     * Sets the value of the chartThreeDimensional property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartThreeDimensional(final String value) {
        this.chartThreeDimensional = value;
    }

    /**
     * Sets the value of the chartTickMarksMajorInner property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartTickMarksMajorInner(final String value) {
        this.chartTickMarksMajorInner = value;
    }

    /**
     * Sets the value of the chartTickMarksMajorOuter property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartTickMarksMajorOuter(final String value) {
        this.chartTickMarksMajorOuter = value;
    }

    /**
     * Sets the value of the chartTickMarksMinorInner property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartTickMarksMinorInner(final String value) {
        this.chartTickMarksMinorInner = value;
    }

    /**
     * Sets the value of the chartTickMarksMinorOuter property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartTickMarksMinorOuter(final String value) {
        this.chartTickMarksMinorOuter = value;
    }

    /**
     * Sets the value of the chartVertical property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartVertical(final String value) {
        this.chartVertical = value;
    }

    /**
     * Sets the value of the chartVisible property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setChartVisible(final String value) {
        this.chartVisible = value;
    }

    /**
     * Sets the value of the dr3DAmbientColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DAmbientColor(final String value) {
        this.dr3DAmbientColor = value;
    }

    /**
     * Sets the value of the dr3DBackfaceCulling property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DBackfaceCulling(final String value) {
        this.dr3DBackfaceCulling = value;
    }

    /**
     * Sets the value of the dr3DBackScale property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DBackScale(final String value) {
        this.dr3DBackScale = value;
    }

    /**
     * Sets the value of the dr3DCloseBack property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DCloseBack(final String value) {
        this.dr3DCloseBack = value;
    }

    /**
     * Sets the value of the dr3DCloseFront property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DCloseFront(final String value) {
        this.dr3DCloseFront = value;
    }

    /**
     * Sets the value of the dr3DDepth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DDepth(final String value) {
        this.dr3DDepth = value;
    }

    /**
     * Sets the value of the dr3DDiffuseColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DDiffuseColor(final String value) {
        this.dr3DDiffuseColor = value;
    }

    /**
     * Sets the value of the dr3DEdgeRounding property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DEdgeRounding(final String value) {
        this.dr3DEdgeRounding = value;
    }

    /**
     * Sets the value of the dr3DEdgeRoundingMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DEdgeRoundingMode(final String value) {
        this.dr3DEdgeRoundingMode = value;
    }

    /**
     * Sets the value of the dr3DEmissiveColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DEmissiveColor(final String value) {
        this.dr3DEmissiveColor = value;
    }

    /**
     * Sets the value of the dr3DEndAngle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DEndAngle(final String value) {
        this.dr3DEndAngle = value;
    }

    /**
     * Sets the value of the dr3DHorizontalSegments property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DHorizontalSegments(final String value) {
        this.dr3DHorizontalSegments = value;
    }

    /**
     * Sets the value of the dr3DLightingMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DLightingMode(final String value) {
        this.dr3DLightingMode = value;
    }

    /**
     * Sets the value of the dr3DNormalsDirection property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DNormalsDirection(final String value) {
        this.dr3DNormalsDirection = value;
    }

    /**
     * Sets the value of the dr3DNormalsKind property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DNormalsKind(final String value) {
        this.dr3DNormalsKind = value;
    }

    /**
     * Sets the value of the dr3DShadow property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DShadow(final String value) {
        this.dr3DShadow = value;
    }

    /**
     * Sets the value of the dr3DShininess property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DShininess(final String value) {
        this.dr3DShininess = value;
    }

    /**
     * Sets the value of the dr3DSpecularColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DSpecularColor(final String value) {
        this.dr3DSpecularColor = value;
    }

    /**
     * Sets the value of the dr3DTextureFilter property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DTextureFilter(final String value) {
        this.dr3DTextureFilter = value;
    }

    /**
     * Sets the value of the dr3DTextureGenerationModeX property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DTextureGenerationModeX(final String value) {
        this.dr3DTextureGenerationModeX = value;
    }

    /**
     * Sets the value of the dr3DTextureGenerationModeY property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DTextureGenerationModeY(final String value) {
        this.dr3DTextureGenerationModeY = value;
    }

    /**
     * Sets the value of the dr3DTextureKind property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DTextureKind(final String value) {
        this.dr3DTextureKind = value;
    }

    /**
     * Sets the value of the dr3DTextureMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DTextureMode(final String value) {
        this.dr3DTextureMode = value;
    }

    /**
     * Sets the value of the dr3DVerticalSegments property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDr3DVerticalSegments(final String value) {
        this.dr3DVerticalSegments = value;
    }

    /**
     * Sets the value of the drawAutoGrowHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawAutoGrowHeight(final String value) {
        this.drawAutoGrowHeight = value;
    }

    /**
     * Sets the value of the drawAutoGrowWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawAutoGrowWidth(final String value) {
        this.drawAutoGrowWidth = value;
    }

    /**
     * Sets the value of the drawBackgroundSize property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawBackgroundSize(final String value) {
        this.drawBackgroundSize = value;
    }

    /**
     * Sets the value of the drawBlue property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawBlue(final String value) {
        this.drawBlue = value;
    }

    /**
     * Sets the value of the drawCaptionAngle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionAngle(final String value) {
        this.drawCaptionAngle = value;
    }

    /**
     * Sets the value of the drawCaptionAngleType property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionAngleType(final String value) {
        this.drawCaptionAngleType = value;
    }

    /**
     * Sets the value of the drawCaptionEscape property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionEscape(final String value) {
        this.drawCaptionEscape = value;
    }

    /**
     * Sets the value of the drawCaptionEscapeDirection property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionEscapeDirection(final String value) {
        this.drawCaptionEscapeDirection = value;
    }

    /**
     * Sets the value of the drawCaptionFitLineLength property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionFitLineLength(final String value) {
        this.drawCaptionFitLineLength = value;
    }

    /**
     * Sets the value of the drawCaptionGap property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionGap(final String value) {
        this.drawCaptionGap = value;
    }

    /**
     * Sets the value of the drawCaptionLineLength property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionLineLength(final String value) {
        this.drawCaptionLineLength = value;
    }

    /**
     * Sets the value of the drawCaptionType property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawCaptionType(final String value) {
        this.drawCaptionType = value;
    }

    /**
     * Sets the value of the drawColorInversion property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawColorInversion(final String value) {
        this.drawColorInversion = value;
    }

    /**
     * Sets the value of the drawColorMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawColorMode(final String value) {
        this.drawColorMode = value;
    }

    /**
     * Sets the value of the drawContrast property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawContrast(final String value) {
        this.drawContrast = value;
    }

    /**
     * Sets the value of the drawDecimalPlaces property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawDecimalPlaces(final String value) {
        this.drawDecimalPlaces = value;
    }

    /**
     * Sets the value of the drawEndGuide property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawEndGuide(final String value) {
        this.drawEndGuide = value;
    }

    /**
     * Sets the value of the drawEndLineSpacingHorizontal property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawEndLineSpacingHorizontal(final String value) {
        this.drawEndLineSpacingHorizontal = value;
    }

    /**
     * Sets the value of the drawEndLineSpacingVertical property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawEndLineSpacingVertical(final String value) {
        this.drawEndLineSpacingVertical = value;
    }

    /**
     * Sets the value of the drawFill property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFill(final String value) {
        this.drawFill = value;
    }

    /**
     * Sets the value of the drawFillColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillColor(final String value) {
        this.drawFillColor = value;
    }

    /**
     * Sets the value of the drawFillGradientName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillGradientName(final String value) {
        this.drawFillGradientName = value;
    }

    /**
     * Sets the value of the drawFillHatchName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillHatchName(final String value) {
        this.drawFillHatchName = value;
    }

    /**
     * Sets the value of the drawFillHatchSolid property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillHatchSolid(final String value) {
        this.drawFillHatchSolid = value;
    }

    /**
     * Sets the value of the drawFillImageHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillImageHeight(final String value) {
        this.drawFillImageHeight = value;
    }

    /**
     * Sets the value of the drawFillImageName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillImageName(final String value) {
        this.drawFillImageName = value;
    }

    /**
     * Sets the value of the drawFillImageRefPoint property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillImageRefPoint(final String value) {
        this.drawFillImageRefPoint = value;
    }

    /**
     * Sets the value of the drawFillImageRefPointX property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillImageRefPointX(final String value) {
        this.drawFillImageRefPointX = value;
    }

    /**
     * Sets the value of the drawFillImageRefPointY property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillImageRefPointY(final String value) {
        this.drawFillImageRefPointY = value;
    }

    /**
     * Sets the value of the drawFillImageWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFillImageWidth(final String value) {
        this.drawFillImageWidth = value;
    }

    /**
     * Sets the value of the drawFitToContour property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFitToContour(final String value) {
        this.drawFitToContour = value;
    }

    /**
     * Sets the value of the drawFitToSize property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFitToSize(final String value) {
        this.drawFitToSize = value;
    }

    /**
     * Sets the value of the drawFontworkAdjust property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkAdjust(final String value) {
        this.drawFontworkAdjust = value;
    }

    /**
     * Sets the value of the drawFontworkDistance property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkDistance(final String value) {
        this.drawFontworkDistance = value;
    }

    /**
     * Sets the value of the drawFontworkForm property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkForm(final String value) {
        this.drawFontworkForm = value;
    }

    /**
     * Sets the value of the drawFontworkHideForm property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkHideForm(final String value) {
        this.drawFontworkHideForm = value;
    }

    /**
     * Sets the value of the drawFontworkMirror property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkMirror(final String value) {
        this.drawFontworkMirror = value;
    }

    /**
     * Sets the value of the drawFontworkOutline property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkOutline(final String value) {
        this.drawFontworkOutline = value;
    }

    /**
     * Sets the value of the drawFontworkShadow property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkShadow(final String value) {
        this.drawFontworkShadow = value;
    }

    /**
     * Sets the value of the drawFontworkShadowColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkShadowColor(final String value) {
        this.drawFontworkShadowColor = value;
    }

    /**
     * Sets the value of the drawFontworkShadowOffsetX property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkShadowOffsetX(final String value) {
        this.drawFontworkShadowOffsetX = value;
    }

    /**
     * Sets the value of the drawFontworkShadowOffsetY property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkShadowOffsetY(final String value) {
        this.drawFontworkShadowOffsetY = value;
    }

    /**
     * Sets the value of the drawFontworkShadowTransparence property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkShadowTransparence(final String value) {
        this.drawFontworkShadowTransparence = value;
    }

    /**
     * Sets the value of the drawFontworkStart property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkStart(final String value) {
        this.drawFontworkStart = value;
    }

    /**
     * Sets the value of the drawFontworkStyle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFontworkStyle(final String value) {
        this.drawFontworkStyle = value;
    }

    /**
     * Sets the value of the drawFrameDisplayBorder property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFrameDisplayBorder(final String value) {
        this.drawFrameDisplayBorder = value;
    }

    /**
     * Sets the value of the drawFrameDisplayScrollbar property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFrameDisplayScrollbar(final String value) {
        this.drawFrameDisplayScrollbar = value;
    }

    /**
     * Sets the value of the drawFrameMarginHorizontal property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFrameMarginHorizontal(final String value) {
        this.drawFrameMarginHorizontal = value;
    }

    /**
     * Sets the value of the drawFrameMarginVertical property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawFrameMarginVertical(final String value) {
        this.drawFrameMarginVertical = value;
    }

    /**
     * Sets the value of the drawGamma property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawGamma(final String value) {
        this.drawGamma = value;
    }

    /**
     * Sets the value of the drawGradientStepCount property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawGradientStepCount(final String value) {
        this.drawGradientStepCount = value;
    }

    /**
     * Sets the value of the drawGreen property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawGreen(final String value) {
        this.drawGreen = value;
    }

    /**
     * Sets the value of the drawGuideDistance property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawGuideDistance(final String value) {
        this.drawGuideDistance = value;
    }

    /**
     * Sets the value of the drawGuideOverhang property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawGuideOverhang(final String value) {
        this.drawGuideOverhang = value;
    }

    /**
     * Sets the value of the drawLineDistance property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawLineDistance(final String value) {
        this.drawLineDistance = value;
    }

    /**
     * Sets the value of the drawLuminance property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawLuminance(final String value) {
        this.drawLuminance = value;
    }

    /**
     * Sets the value of the drawMarkerEnd property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMarkerEnd(final String value) {
        this.drawMarkerEnd = value;
    }

    /**
     * Sets the value of the drawMarkerEndCenter property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMarkerEndCenter(final String value) {
        this.drawMarkerEndCenter = value;
    }

    /**
     * Sets the value of the drawMarkerEndWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMarkerEndWidth(final String value) {
        this.drawMarkerEndWidth = value;
    }

    /**
     * Sets the value of the drawMarkerStart property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMarkerStart(final String value) {
        this.drawMarkerStart = value;
    }

    /**
     * Sets the value of the drawMarkerStartCenter property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMarkerStartCenter(final String value) {
        this.drawMarkerStartCenter = value;
    }

    /**
     * Sets the value of the drawMarkerStartWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMarkerStartWidth(final String value) {
        this.drawMarkerStartWidth = value;
    }

    /**
     * Sets the value of the drawMeasureAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMeasureAlign(final String value) {
        this.drawMeasureAlign = value;
    }

    /**
     * Sets the value of the drawMeasureVerticalAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMeasureVerticalAlign(final String value) {
        this.drawMeasureVerticalAlign = value;
    }

    /**
     * Sets the value of the drawMirror property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMirror(final String value) {
        this.drawMirror = value;
    }

    /**
     * Sets the value of the drawMoveProtect property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawMoveProtect(final String value) {
        this.drawMoveProtect = value;
    }

    /**
     * Sets the value of the drawParallel property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawParallel(final String value) {
        this.drawParallel = value;
    }

    /**
     * Sets the value of the drawPlacing property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawPlacing(final String value) {
        this.drawPlacing = value;
    }

    /**
     * Sets the value of the drawRed property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawRed(final String value) {
        this.drawRed = value;
    }

    /**
     * Sets the value of the drawShadow property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawShadow(final String value) {
        this.drawShadow = value;
    }

    /**
     * Sets the value of the drawShadowColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawShadowColor(final String value) {
        this.drawShadowColor = value;
    }

    /**
     * Sets the value of the drawShadowOffsetX property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawShadowOffsetX(final String value) {
        this.drawShadowOffsetX = value;
    }

    /**
     * Sets the value of the drawShadowOffsetY property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawShadowOffsetY(final String value) {
        this.drawShadowOffsetY = value;
    }

    /**
     * Sets the value of the drawShadowTransparency property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawShadowTransparency(final String value) {
        this.drawShadowTransparency = value;
    }

    /**
     * Sets the value of the drawShowUnit property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawShowUnit(final String value) {
        this.drawShowUnit = value;
    }

    /**
     * Sets the value of the drawSizeProtect property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawSizeProtect(final String value) {
        this.drawSizeProtect = value;
    }

    /**
     * Sets the value of the drawStartGuide property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawStartGuide(final String value) {
        this.drawStartGuide = value;
    }

    /**
     * Sets the value of the drawStartLineSpacingHorizontal property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawStartLineSpacingHorizontal(final String value) {
        this.drawStartLineSpacingHorizontal = value;
    }

    /**
     * Sets the value of the drawStartLineSpacingVertical property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawStartLineSpacingVertical(final String value) {
        this.drawStartLineSpacingVertical = value;
    }

    /**
     * Sets the value of the drawStroke property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawStroke(final String value) {
        this.drawStroke = value;
    }

    /**
     * Sets the value of the drawStrokeDash property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawStrokeDash(final String value) {
        this.drawStrokeDash = value;
    }

    /**
     * Sets the value of the drawSymbolColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawSymbolColor(final String value) {
        this.drawSymbolColor = value;
    }

    /**
     * Sets the value of the drawTextareaHorizontalAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawTextareaHorizontalAlign(final String value) {
        this.drawTextareaHorizontalAlign = value;
    }

    /**
     * Sets the value of the drawTextareaVerticalAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawTextareaVerticalAlign(final String value) {
        this.drawTextareaVerticalAlign = value;
    }

    /**
     * Sets the value of the drawTileRepeatOffset property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawTileRepeatOffset(final String value) {
        this.drawTileRepeatOffset = value;
    }

    /**
     * Sets the value of the drawTransparency property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawTransparency(final String value) {
        this.drawTransparency = value;
    }

    /**
     * Sets the value of the drawTransparencyName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawTransparencyName(final String value) {
        this.drawTransparencyName = value;
    }

    /**
     * Sets the value of the drawUnit property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawUnit(final String value) {
        this.drawUnit = value;
    }

    /**
     * Sets the value of the drawVisibleAreaHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawVisibleAreaHeight(final String value) {
        this.drawVisibleAreaHeight = value;
    }

    /**
     * Sets the value of the drawVisibleAreaLeft property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawVisibleAreaLeft(final String value) {
        this.drawVisibleAreaLeft = value;
    }

    /**
     * Sets the value of the drawVisibleAreaTop property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawVisibleAreaTop(final String value) {
        this.drawVisibleAreaTop = value;
    }

    /**
     * Sets the value of the drawVisibleAreaWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawVisibleAreaWidth(final String value) {
        this.drawVisibleAreaWidth = value;
    }

    /**
     * Sets the value of the drawWritingMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setDrawWritingMode(final String value) {
        this.drawWritingMode = value;
    }

    /**
     * Sets the value of the foBackgroundColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBackgroundColor(final String value) {
        this.foBackgroundColor = value;
    }

    /**
     * Sets the value of the foBorder property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBorder(final String value) {
        this.foBorder = value;
    }

    /**
     * Sets the value of the foBorderBottom property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBorderBottom(final String value) {
        this.foBorderBottom = value;
    }

    /**
     * Sets the value of the foBorderLeft property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBorderLeft(final String value) {
        this.foBorderLeft = value;
    }

    /**
     * Sets the value of the foBorderRight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBorderRight(final String value) {
        this.foBorderRight = value;
    }

    /**
     * Sets the value of the foBorderTop property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBorderTop(final String value) {
        this.foBorderTop = value;
    }

    /**
     * Sets the value of the foBreakAfter property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBreakAfter(final String value) {
        this.foBreakAfter = value;
    }

    /**
     * Sets the value of the foBreakBefore property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoBreakBefore(final String value) {
        this.foBreakBefore = value;
    }

    /**
     * Sets the value of the foClip property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoClip(final String value) {
        this.foClip = value;
    }

    /**
     * Sets the value of the foColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoColor(final String value) {
        this.foColor = value;
    }

    /**
     * Sets the value of the foCountry property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoCountry(final String value) {
        this.foCountry = value;
    }

    /**
     * Sets the value of the foDirection property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoDirection(final String value) {
        this.foDirection = value;
    }

    /**
     * Sets the value of the foFontFamily property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoFontFamily(final String value) {
        this.foFontFamily = value;
    }

    /**
     * Sets the value of the foFontSize property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoFontSize(final String value) {
        this.foFontSize = value;
    }

    /**
     * Sets the value of the foFontStyle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoFontStyle(final String value) {
        this.foFontStyle = value;
    }

    /**
     * Sets the value of the foFontVariant property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoFontVariant(final String value) {
        this.foFontVariant = value;
    }

    /**
     * Sets the value of the foFontWeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoFontWeight(final String value) {
        this.foFontWeight = value;
    }

    /**
     * Sets the value of the foHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoHeight(final String value) {
        this.foHeight = value;
    }

    /**
     * Sets the value of the foHyphenate property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoHyphenate(final String value) {
        this.foHyphenate = value;
    }

    /**
     * Sets the value of the foHyphenateKeep property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoHyphenateKeep(final String value) {
        this.foHyphenateKeep = value;
    }

    /**
     * Sets the value of the foHyphenationLadderCount property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoHyphenationLadderCount(final String value) {
        this.foHyphenationLadderCount = value;
    }

    /**
     * Sets the value of the foHyphenationPushCharCount property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoHyphenationPushCharCount(final String value) {
        this.foHyphenationPushCharCount = value;
    }

    /**
     * Sets the value of the foHyphenationRemainCharCount property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoHyphenationRemainCharCount(final String value) {
        this.foHyphenationRemainCharCount = value;
    }

    /**
     * Sets the value of the foKeepTogether property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoKeepTogether(final String value) {
        this.foKeepTogether = value;
    }

    /**
     * Sets the value of the foKeepWithNext property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoKeepWithNext(final String value) {
        this.foKeepWithNext = value;
    }

    /**
     * Sets the value of the foLanguage property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoLanguage(final String value) {
        this.foLanguage = value;
    }

    /**
     * Sets the value of the foLetterSpacing property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoLetterSpacing(final String value) {
        this.foLetterSpacing = value;
    }

    /**
     * Sets the value of the foLineHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoLineHeight(final String value) {
        this.foLineHeight = value;
    }

    /**
     * Sets the value of the foMarginBottom property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMarginBottom(final String value) {
        this.foMarginBottom = value;
    }

    /**
     * Sets the value of the foMarginLeft property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMarginLeft(final String value) {
        this.foMarginLeft = value;
    }

    /**
     * Sets the value of the foMarginRight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMarginRight(final String value) {
        this.foMarginRight = value;
    }

    /**
     * Sets the value of the foMarginTop property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMarginTop(final String value) {
        this.foMarginTop = value;
    }

    /**
     * Sets the value of the foMaxHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMaxHeight(final String value) {
        this.foMaxHeight = value;
    }

    /**
     * Sets the value of the foMaxWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMaxWidth(final String value) {
        this.foMaxWidth = value;
    }

    /**
     * Sets the value of the foMinHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMinHeight(final String value) {
        this.foMinHeight = value;
    }

    /**
     * Sets the value of the foMinWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoMinWidth(final String value) {
        this.foMinWidth = value;
    }

    /**
     * Sets the value of the foOrphans property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoOrphans(final String value) {
        this.foOrphans = value;
    }

    /**
     * Sets the value of the foPadding property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPadding(final String value) {
        this.foPadding = value;
    }

    /**
     * Sets the value of the foPaddingBottom property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPaddingBottom(final String value) {
        this.foPaddingBottom = value;
    }

    /**
     * Sets the value of the foPaddingLeft property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPaddingLeft(final String value) {
        this.foPaddingLeft = value;
    }

    /**
     * Sets the value of the foPaddingRight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPaddingRight(final String value) {
        this.foPaddingRight = value;
    }

    /**
     * Sets the value of the foPaddingTop property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPaddingTop(final String value) {
        this.foPaddingTop = value;
    }

    /**
     * Sets the value of the foPageHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPageHeight(final String value) {
        this.foPageHeight = value;
    }

    /**
     * Sets the value of the foPageWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoPageWidth(final String value) {
        this.foPageWidth = value;
    }

    /**
     * Sets the value of the foScoreSpaces property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoScoreSpaces(final String value) {
        this.foScoreSpaces = value;
    }

    /**
     * Sets the value of the foTextAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoTextAlign(final String value) {
        this.foTextAlign = value;
    }

    /**
     * Sets the value of the foTextAlignLast property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoTextAlignLast(final String value) {
        this.foTextAlignLast = value;
    }

    /**
     * Sets the value of the foTextIndent property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoTextIndent(final String value) {
        this.foTextIndent = value;
    }

    /**
     * Sets the value of the foTextShadow property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoTextShadow(final String value) {
        this.foTextShadow = value;
    }

    /**
     * Sets the value of the foTextTransform property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoTextTransform(final String value) {
        this.foTextTransform = value;
    }

    /**
     * Sets the value of the foVerticalAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoVerticalAlign(final String value) {
        this.foVerticalAlign = value;
    }

    /**
     * Sets the value of the foWidows property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoWidows(final String value) {
        this.foWidows = value;
    }

    /**
     * Sets the value of the foWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoWidth(final String value) {
        this.foWidth = value;
    }

    /**
     * Sets the value of the foWrapOption property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setFoWrapOption(final String value) {
        this.foWrapOption = value;
    }

    /**
     * Sets the value of the presentationBackgroundObjectsVisible property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationBackgroundObjectsVisible(final String value) {
        this.presentationBackgroundObjectsVisible = value;
    }

    /**
     * Sets the value of the presentationBackgroundVisible property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationBackgroundVisible(final String value) {
        this.presentationBackgroundVisible = value;
    }

    /**
     * Sets the value of the presentationDuration property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationDuration(final String value) {
        this.presentationDuration = value;
    }

    /**
     * Sets the value of the presentationTransitionSpeed property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationTransitionSpeed(final String value) {
        this.presentationTransitionSpeed = value;
    }

    /**
     * Sets the value of the presentationTransitionStyle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationTransitionStyle(final String value) {
        this.presentationTransitionStyle = value;
    }

    /**
     * Sets the value of the presentationTransitionType property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationTransitionType(final String value) {
        this.presentationTransitionType = value;
    }

    /**
     * Sets the value of the presentationVisibility property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setPresentationVisibility(final String value) {
        this.presentationVisibility = value;
    }

    /**
     * Sets the value of the styleAutoTextIndent property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleAutoTextIndent(final String value) {
        this.styleAutoTextIndent = value;
    }

    /**
     * Sets the value of the styleBackgroundTransparency property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBackgroundTransparency(final String value) {
        this.styleBackgroundTransparency = value;
    }

    /**
     * Sets the value of the styleBorderLineWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBorderLineWidth(final String value) {
        this.styleBorderLineWidth = value;
    }

    /**
     * Sets the value of the styleBorderLineWidthBottom property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBorderLineWidthBottom(final String value) {
        this.styleBorderLineWidthBottom = value;
    }

    /**
     * Sets the value of the styleBorderLineWidthLeft property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBorderLineWidthLeft(final String value) {
        this.styleBorderLineWidthLeft = value;
    }

    /**
     * Sets the value of the styleBorderLineWidthRight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBorderLineWidthRight(final String value) {
        this.styleBorderLineWidthRight = value;
    }

    /**
     * Sets the value of the styleBorderLineWidthTop property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBorderLineWidthTop(final String value) {
        this.styleBorderLineWidthTop = value;
    }

    /**
     * Sets the value of the styleBreakInside property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleBreakInside(final String value) {
        this.styleBreakInside = value;
    }

    /**
     * Sets the value of the styleCellProtect property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleCellProtect(final String value) {
        this.styleCellProtect = value;
    }

    /**
     * Sets the value of the styleColumnWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleColumnWidth(final String value) {
        this.styleColumnWidth = value;
    }

    /**
     * Sets the value of the styleCountryAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleCountryAsian(final String value) {
        this.styleCountryAsian = value;
    }

    /**
     * Sets the value of the styleCountryComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleCountryComplex(final String value) {
        this.styleCountryComplex = value;
    }

    /**
     * Sets the value of the styleDecimalPlaces property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleDecimalPlaces(final String value) {
        this.styleDecimalPlaces = value;
    }

    /**
     * Sets the value of the styleDynamicSpacing property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleDynamicSpacing(final String value) {
        this.styleDynamicSpacing = value;
    }

    /**
     * Sets the value of the styleEditable property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleEditable(final String value) {
        this.styleEditable = value;
    }

    /**
     * Sets the value of the styleFirstPageNumber property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFirstPageNumber(final String value) {
        this.styleFirstPageNumber = value;
    }

    /**
     * Sets the value of the styleFontCharset property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontCharset(final String value) {
        this.styleFontCharset = value;
    }

    /**
     * Sets the value of the styleFontCharsetAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontCharsetAsian(final String value) {
        this.styleFontCharsetAsian = value;
    }

    /**
     * Sets the value of the styleFontCharsetComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontCharsetComplex(final String value) {
        this.styleFontCharsetComplex = value;
    }

    /**
     * Sets the value of the styleFontFamilyAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontFamilyAsian(final String value) {
        this.styleFontFamilyAsian = value;
    }

    /**
     * Sets the value of the styleFontFamilyComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontFamilyComplex(final String value) {
        this.styleFontFamilyComplex = value;
    }

    /**
     * Sets the value of the styleFontFamilyGeneric property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontFamilyGeneric(final String value) {
        this.styleFontFamilyGeneric = value;
    }

    /**
     * Sets the value of the styleFontFamilyGenericAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontFamilyGenericAsian(final String value) {
        this.styleFontFamilyGenericAsian = value;
    }

    /**
     * Sets the value of the styleFontFamilyGenericComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontFamilyGenericComplex(final String value) {
        this.styleFontFamilyGenericComplex = value;
    }

    /**
     * Sets the value of the styleFontIndependentLineSpacing property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontIndependentLineSpacing(final String value) {
        this.styleFontIndependentLineSpacing = value;
    }

    /**
     * Sets the value of the styleFontName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontName(final String value) {
        this.styleFontName = value;
    }

    /**
     * Sets the value of the styleFontNameAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontNameAsian(final String value) {
        this.styleFontNameAsian = value;
    }

    /**
     * Sets the value of the styleFontNameComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontNameComplex(final String value) {
        this.styleFontNameComplex = value;
    }

    /**
     * Sets the value of the styleFontPitch property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontPitch(final String value) {
        this.styleFontPitch = value;
    }

    /**
     * Sets the value of the styleFontPitchAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontPitchAsian(final String value) {
        this.styleFontPitchAsian = value;
    }

    /**
     * Sets the value of the styleFontPitchComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontPitchComplex(final String value) {
        this.styleFontPitchComplex = value;
    }

    /**
     * Sets the value of the styleFontRelief property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontRelief(final String value) {
        this.styleFontRelief = value;
    }

    /**
     * Sets the value of the styleFontSizeAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontSizeAsian(final String value) {
        this.styleFontSizeAsian = value;
    }

    /**
     * Sets the value of the styleFontSizeComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontSizeComplex(final String value) {
        this.styleFontSizeComplex = value;
    }

    /**
     * Sets the value of the styleFontSizeRel property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontSizeRel(final String value) {
        this.styleFontSizeRel = value;
    }

    /**
     * Sets the value of the styleFontSizeRelAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontSizeRelAsian(final String value) {
        this.styleFontSizeRelAsian = value;
    }

    /**
     * Sets the value of the styleFontSizeRelComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontSizeRelComplex(final String value) {
        this.styleFontSizeRelComplex = value;
    }

    /**
     * Sets the value of the styleFontStyleAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontStyleAsian(final String value) {
        this.styleFontStyleAsian = value;
    }

    /**
     * Sets the value of the styleFontStyleComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontStyleComplex(final String value) {
        this.styleFontStyleComplex = value;
    }

    /**
     * Sets the value of the styleFontStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontStyleName(final String value) {
        this.styleFontStyleName = value;
    }

    /**
     * Sets the value of the styleFontStyleNameAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontStyleNameAsian(final String value) {
        this.styleFontStyleNameAsian = value;
    }

    /**
     * Sets the value of the styleFontStyleNameComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontStyleNameComplex(final String value) {
        this.styleFontStyleNameComplex = value;
    }

    /**
     * Sets the value of the styleFontWeightAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontWeightAsian(final String value) {
        this.styleFontWeightAsian = value;
    }

    /**
     * Sets the value of the styleFontWeightComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFontWeightComplex(final String value) {
        this.styleFontWeightComplex = value;
    }

    /**
     * Sets the value of the styleFootnoteMaxHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleFootnoteMaxHeight(final String value) {
        this.styleFootnoteMaxHeight = value;
    }

    /**
     * Sets the value of the styleGlyphOrientationVertical property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleGlyphOrientationVertical(final String value) {
        this.styleGlyphOrientationVertical = value;
    }

    /**
     * Sets the value of the styleHorizontalPos property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleHorizontalPos(final String value) {
        this.styleHorizontalPos = value;
    }

    /**
     * Sets the value of the styleHorizontalRel property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleHorizontalRel(final String value) {
        this.styleHorizontalRel = value;
    }

    /**
     * Sets the value of the styleJoinBorder property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleJoinBorder(final String value) {
        this.styleJoinBorder = value;
    }

    /**
     * Sets the value of the styleJustifySingleWord property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleJustifySingleWord(final String value) {
        this.styleJustifySingleWord = value;
    }

    /**
     * Sets the value of the styleLanguageAsian property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLanguageAsian(final String value) {
        this.styleLanguageAsian = value;
    }

    /**
     * Sets the value of the styleLanguageComplex property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLanguageComplex(final String value) {
        this.styleLanguageComplex = value;
    }

    /**
     * Sets the value of the styleLayoutGridBaseHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridBaseHeight(final String value) {
        this.styleLayoutGridBaseHeight = value;
    }

    /**
     * Sets the value of the styleLayoutGridColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridColor(final String value) {
        this.styleLayoutGridColor = value;
    }

    /**
     * Sets the value of the styleLayoutGridDisplay property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridDisplay(final String value) {
        this.styleLayoutGridDisplay = value;
    }

    /**
     * Sets the value of the styleLayoutGridLines property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridLines(final String value) {
        this.styleLayoutGridLines = value;
    }

    /**
     * Sets the value of the styleLayoutGridMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridMode(final String value) {
        this.styleLayoutGridMode = value;
    }

    /**
     * Sets the value of the styleLayoutGridPrint property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridPrint(final String value) {
        this.styleLayoutGridPrint = value;
    }

    /**
     * Sets the value of the styleLayoutGridRubyBelow property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridRubyBelow(final String value) {
        this.styleLayoutGridRubyBelow = value;
    }

    /**
     * Sets the value of the styleLayoutGridRubyHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLayoutGridRubyHeight(final String value) {
        this.styleLayoutGridRubyHeight = value;
    }

    /**
     * Sets the value of the styleLetterKerning property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLetterKerning(final String value) {
        this.styleLetterKerning = value;
    }

    /**
     * Sets the value of the styleLineBreak property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLineBreak(final String value) {
        this.styleLineBreak = value;
    }

    /**
     * Sets the value of the styleLineHeightAtLeast property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLineHeightAtLeast(final String value) {
        this.styleLineHeightAtLeast = value;
    }

    /**
     * Sets the value of the styleLineSpacing property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleLineSpacing(final String value) {
        this.styleLineSpacing = value;
    }

    /**
     * Sets the value of the styleListStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleListStyleName(final String value) {
        this.styleListStyleName = value;
    }

    /**
     * Sets the value of the styleMayBreakBetweenRows property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleMayBreakBetweenRows(final String value) {
        this.styleMayBreakBetweenRows = value;
    }

    /**
     * Sets the value of the styleMinRowHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleMinRowHeight(final String value) {
        this.styleMinRowHeight = value;
    }

    /**
     * Sets the value of the styleMirror property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleMirror(final String value) {
        this.styleMirror = value;
    }

    /**
     * Sets the value of the styleNumberWrappedParagraphs property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleNumberWrappedParagraphs(final String value) {
        this.styleNumberWrappedParagraphs = value;
    }

    /**
     * Sets the value of the styleNumFormat property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleNumFormat(final String value) {
        this.styleNumFormat = value;
    }

    /**
     * Sets the value of the styleNumLetterSync property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleNumLetterSync(final String value) {
        this.styleNumLetterSync = value;
    }

    /**
     * Sets the value of the styleNumPrefix property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleNumPrefix(final String value) {
        this.styleNumPrefix = value;
    }

    /**
     * Sets the value of the styleNumSuffix property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleNumSuffix(final String value) {
        this.styleNumSuffix = value;
    }

    /**
     * Sets the value of the stylePageNumber property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePageNumber(final String value) {
        this.stylePageNumber = value;
    }

    /**
     * Sets the value of the stylePaperTrayName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePaperTrayName(final String value) {
        this.stylePaperTrayName = value;
    }

    /**
     * Sets the value of the stylePrint property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePrint(final String value) {
        this.stylePrint = value;
    }

    /**
     * Sets the value of the stylePrintContent property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePrintContent(final String value) {
        this.stylePrintContent = value;
    }

    /**
     * Sets the value of the stylePrintOrientation property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePrintOrientation(final String value) {
        this.stylePrintOrientation = value;
    }

    /**
     * Sets the value of the stylePrintPageOrder property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePrintPageOrder(final String value) {
        this.stylePrintPageOrder = value;
    }

    /**
     * Sets the value of the styleProtect property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleProtect(final String value) {
        this.styleProtect = value;
    }

    /**
     * Sets the value of the stylePunctuationWrap property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStylePunctuationWrap(final String value) {
        this.stylePunctuationWrap = value;
    }

    /**
     * Sets the value of the styleRegisterTrue property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRegisterTrue(final String value) {
        this.styleRegisterTrue = value;
    }

    /**
     * Sets the value of the styleRegisterTruthRefStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRegisterTruthRefStyleName(final String value) {
        this.styleRegisterTruthRefStyleName = value;
    }

    /**
     * Sets the value of the styleRelColumnWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRelColumnWidth(final String value) {
        this.styleRelColumnWidth = value;
    }

    /**
     * Sets the value of the styleRelWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRelWidth(final String value) {
        this.styleRelWidth = value;
    }

    /**
     * Sets the value of the styleRepeat property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRepeat(final String value) {
        this.styleRepeat = value;
    }

    /**
     * Sets the value of the styleRotationAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRotationAlign(final String value) {
        this.styleRotationAlign = value;
    }

    /**
     * Sets the value of the styleRotationAngle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRotationAngle(final String value) {
        this.styleRotationAngle = value;
    }

    /**
     * Sets the value of the styleRowHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRowHeight(final String value) {
        this.styleRowHeight = value;
    }

    /**
     * Sets the value of the styleRubyAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRubyAlign(final String value) {
        this.styleRubyAlign = value;
    }

    /**
     * Sets the value of the styleRubyPosition property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRubyPosition(final String value) {
        this.styleRubyPosition = value;
    }

    /**
     * Sets the value of the styleRunThrough property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleRunThrough(final String value) {
        this.styleRunThrough = value;
    }

    /**
     * Sets the value of the styleScaleTo property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleScaleTo(final String value) {
        this.styleScaleTo = value;
    }

    /**
     * Sets the value of the styleScaleToPages property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleScaleToPages(final String value) {
        this.styleScaleToPages = value;
    }

    /**
     * Sets the value of the styleShadow property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleShadow(final String value) {
        this.styleShadow = value;
    }

    /**
     * Sets the value of the styleSnapToLayoutGrid property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleSnapToLayoutGrid(final String value) {
        this.styleSnapToLayoutGrid = value;
    }

    /**
     * Sets the value of the styleTableCentering property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTableCentering(final String value) {
        this.styleTableCentering = value;
    }

    /**
     * Sets the value of the styleTabStopDistance property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTabStopDistance(final String value) {
        this.styleTabStopDistance = value;
    }

    /**
     * Sets the value of the styleTextAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextAlign(final String value) {
        this.styleTextAlign = value;
    }

    /**
     * Sets the value of the styleTextAlignSource property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextAlignSource(final String value) {
        this.styleTextAlignSource = value;
    }

    /**
     * Sets the value of the styleTextAutospace property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextAutospace(final String value) {
        this.styleTextAutospace = value;
    }

    /**
     * Sets the value of the styleTextBackgroundColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextBackgroundColor(final String value) {
        this.styleTextBackgroundColor = value;
    }

    /**
     * Sets the value of the styleTextBlinking property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextBlinking(final String value) {
        this.styleTextBlinking = value;
    }

    /**
     * Sets the value of the styleTextCombine property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextCombine(final String value) {
        this.styleTextCombine = value;
    }

    /**
     * Sets the value of the styleTextCombineEndChar property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextCombineEndChar(final String value) {
        this.styleTextCombineEndChar = value;
    }

    /**
     * Sets the value of the styleTextCombineStartChar property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextCombineStartChar(final String value) {
        this.styleTextCombineStartChar = value;
    }

    /**
     * Sets the value of the styleTextCrossingOut property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextCrossingOut(final String value) {
        this.styleTextCrossingOut = value;
    }

    /**
     * Sets the value of the styleTextEmphasize property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextEmphasize(final String value) {
        this.styleTextEmphasize = value;
    }

    /**
     * Sets the value of the styleTextOutline property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextOutline(final String value) {
        this.styleTextOutline = value;
    }

    /**
     * Sets the value of the styleTextPosition property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextPosition(final String value) {
        this.styleTextPosition = value;
    }

    /**
     * Sets the value of the styleTextRotationAngle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextRotationAngle(final String value) {
        this.styleTextRotationAngle = value;
    }

    /**
     * Sets the value of the styleTextRotationScale property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextRotationScale(final String value) {
        this.styleTextRotationScale = value;
    }

    /**
     * Sets the value of the styleTextScale property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextScale(final String value) {
        this.styleTextScale = value;
    }

    /**
     * Sets the value of the styleTextUnderline property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextUnderline(final String value) {
        this.styleTextUnderline = value;
    }

    /**
     * Sets the value of the styleTextUnderlineColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleTextUnderlineColor(final String value) {
        this.styleTextUnderlineColor = value;
    }

    /**
     * Sets the value of the styleUseOptimalColumnWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleUseOptimalColumnWidth(final String value) {
        this.styleUseOptimalColumnWidth = value;
    }

    /**
     * Sets the value of the styleUseOptimalRowHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleUseOptimalRowHeight(final String value) {
        this.styleUseOptimalRowHeight = value;
    }

    /**
     * Sets the value of the styleUseWindowFontColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleUseWindowFontColor(final String value) {
        this.styleUseWindowFontColor = value;
    }

    /**
     * Sets the value of the styleVerticalAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleVerticalAlign(final String value) {
        this.styleVerticalAlign = value;
    }

    /**
     * Sets the value of the styleVerticalPos property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleVerticalPos(final String value) {
        this.styleVerticalPos = value;
    }

    /**
     * Sets the value of the styleVerticalRel property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleVerticalRel(final String value) {
        this.styleVerticalRel = value;
    }

    /**
     * Sets the value of the styleWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleWidth(final String value) {
        this.styleWidth = value;
    }

    /**
     * Sets the value of the styleWrap property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleWrap(final String value) {
        this.styleWrap = value;
    }

    /**
     * Sets the value of the styleWrapContour property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleWrapContour(final String value) {
        this.styleWrapContour = value;
    }

    /**
     * Sets the value of the styleWrapContourMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleWrapContourMode(final String value) {
        this.styleWrapContourMode = value;
    }

    /**
     * Sets the value of the styleWritingMode property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setStyleWritingMode(final String value) {
        this.styleWritingMode = value;
    }

    /**
     * Sets the value of the svgHeight property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgHeight(final String value) {
        this.svgHeight = value;
    }

    /**
     * Sets the value of the svgStrokeColor property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgStrokeColor(final String value) {
        this.svgStrokeColor = value;
    }

    /**
     * Sets the value of the svgStrokeLinejoin property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgStrokeLinejoin(final String value) {
        this.svgStrokeLinejoin = value;
    }

    /**
     * Sets the value of the svgStrokeOpacity property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgStrokeOpacity(final String value) {
        this.svgStrokeOpacity = value;
    }

    /**
     * Sets the value of the svgStrokeWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgStrokeWidth(final String value) {
        this.svgStrokeWidth = value;
    }

    /**
     * Sets the value of the svgWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgWidth(final String value) {
        this.svgWidth = value;
    }

    /**
     * Sets the value of the svgX property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgX(final String value) {
        this.svgX = value;
    }

    /**
     * Sets the value of the svgY property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setSvgY(final String value) {
        this.svgY = value;
    }

    /**
     * Sets the value of the tableAlign property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableAlign(final String value) {
        this.tableAlign = value;
    }

    /**
     * Sets the value of the tableBorderModel property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableBorderModel(final String value) {
        this.tableBorderModel = value;
    }

    /**
     * Sets the value of the tableDisplay property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTableDisplay(final String value) {
        this.tableDisplay = value;
    }

    /**
     * Sets the value of the tablePageStyleName property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTablePageStyleName(final String value) {
        this.tablePageStyleName = value;
    }

    /**
     * Sets the value of the textAnchorPageNumber property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnchorPageNumber(final String value) {
        this.textAnchorPageNumber = value;
    }

    /**
     * Sets the value of the textAnchorType property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnchorType(final String value) {
        this.textAnchorType = value;
    }

    /**
     * Sets the value of the textAnimation property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimation(final String value) {
        this.textAnimation = value;
    }

    /**
     * Sets the value of the textAnimationDelay property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimationDelay(final String value) {
        this.textAnimationDelay = value;
    }

    /**
     * Sets the value of the textAnimationDirection property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimationDirection(final String value) {
        this.textAnimationDirection = value;
    }

    /**
     * Sets the value of the textAnimationRepeat property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimationRepeat(final String value) {
        this.textAnimationRepeat = value;
    }

    /**
     * Sets the value of the textAnimationStartInside property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimationStartInside(final String value) {
        this.textAnimationStartInside = value;
    }

    /**
     * Sets the value of the textAnimationSteps property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimationSteps(final String value) {
        this.textAnimationSteps = value;
    }

    /**
     * Sets the value of the textAnimationStopInside property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextAnimationStopInside(final String value) {
        this.textAnimationStopInside = value;
    }

    /**
     * Sets the value of the textDisplay property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextDisplay(final String value) {
        this.textDisplay = value;
    }

    /**
     * Sets the value of the textDontBalanceTextColumns property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextDontBalanceTextColumns(final String value) {
        this.textDontBalanceTextColumns = value;
    }

    /**
     * Sets the value of the textEnableNumbering property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextEnableNumbering(final String value) {
        this.textEnableNumbering = value;
    }

    /**
     * Sets the value of the textLineBreak property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextLineBreak(final String value) {
        this.textLineBreak = value;
    }

    /**
     * Sets the value of the textLineNumber property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextLineNumber(final String value) {
        this.textLineNumber = value;
    }

    /**
     * Sets the value of the textMinLabelDistance property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextMinLabelDistance(final String value) {
        this.textMinLabelDistance = value;
    }

    /**
     * Sets the value of the textMinLabelWidth property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextMinLabelWidth(final String value) {
        this.textMinLabelWidth = value;
    }

    /**
     * Sets the value of the textNumberLines property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextNumberLines(final String value) {
        this.textNumberLines = value;
    }

    /**
     * Sets the value of the textRotationAngle property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextRotationAngle(final String value) {
        this.textRotationAngle = value;
    }

    /**
     * Sets the value of the textSpaceBefore property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setTextSpaceBefore(final String value) {
        this.textSpaceBefore = value;
    }

}
